/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v1.config;

import java.util.List;
import javax.annotation.Resource;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.config.api.JaxbListWrapper;
import org.opennms.netmgt.config.javamail.End2endMailConfig;
import org.opennms.netmgt.config.javamail.ReadmailConfig;
import org.opennms.netmgt.config.javamail.SendmailConfig;
import org.opennms.netmgt.dao.api.JavaMailConfigurationDao;
import org.opennms.netmgt.events.api.EventProxy;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.web.rest.support.MultivaluedMapImpl;
import org.opennms.web.rest.v1.OnmsRestService;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class JavamailConfigurationResource
extends OnmsRestService
implements InitializingBean {
    @Resource(name="javamailConfigDao")
    private JavaMailConfigurationDao m_javamailConfigurationDao;
    @Resource(name="eventProxy")
    private EventProxy m_eventProxy;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.m_javamailConfigurationDao, (String)"javamailConfigurationDao must be set!");
        Assert.notNull((Object)this.m_eventProxy, (String)"eventProxy must be set!");
    }

    @GET
    @Path(value="default/readmail")
    @Produces(value={"text/plain"})
    public Response getDefaultReadmailConfiguration() {
        ReadmailConfig config = this.m_javamailConfigurationDao.getDefaultReadmailConfig();
        if (config == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)config.getName()).build();
    }

    @GET
    @Path(value="default/sendmail")
    @Produces(value={"text/plain"})
    public Response getDefaultSendmailConfiguration() {
        SendmailConfig config = this.m_javamailConfigurationDao.getDefaultSendmailConfig();
        if (config == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)config.getName()).build();
    }

    @PUT
    @Path(value="default/readmail/{readmailConfig}")
    public Response setDefaultReadmailConfiguration(@PathParam(value="readmailConfig") String readmailConfigName) {
        this.m_javamailConfigurationDao.setDefaultReadmailConfig(readmailConfigName);
        return this.saveConfiguration();
    }

    @PUT
    @Path(value="default/sendmail/{sendmailConfig}")
    public Response setDefaultSendmailConfiguration(@PathParam(value="sendmailConfig") String sendmailConfigName) {
        this.m_javamailConfigurationDao.setDefaultSendmailConfig(sendmailConfigName);
        return this.saveConfiguration();
    }

    @GET
    @Path(value="readmails")
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    public Response getReadmailConfigurations() {
        ReadmailConfigList readmails = new ReadmailConfigList(this.m_javamailConfigurationDao.getReadmailConfigs());
        return Response.ok((Object)((Object)readmails)).build();
    }

    @GET
    @Path(value="sendmails")
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    public Response getSendmailConfigurations() {
        SendmailConfigList sendmails = new SendmailConfigList(this.m_javamailConfigurationDao.getSendmailConfigs());
        return Response.ok((Object)((Object)sendmails)).build();
    }

    @GET
    @Path(value="end2ends")
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    public Response getEnd2endConfigurations() {
        End2endConfigList sendmails = new End2endConfigList(this.m_javamailConfigurationDao.getEnd2EndConfigs());
        return Response.ok((Object)((Object)sendmails)).build();
    }

    @GET
    @Path(value="readmails/{readmailConfig}")
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    public ReadmailConfig getReadmailConfiguration(@PathParam(value="readmailConfig") String readmailConfig) {
        ReadmailConfig readmail;
        ReadmailConfig readmailConfig2 = readmail = "default".equals(readmailConfig) ? this.m_javamailConfigurationDao.getDefaultReadmailConfig() : this.m_javamailConfigurationDao.getReadMailConfig(readmailConfig);
        if (readmail == null) {
            throw JavamailConfigurationResource.getException(Response.Status.NOT_FOUND, "Readmail configuration {} was not found.", readmailConfig);
        }
        return readmail;
    }

    @GET
    @Path(value="sendmails/{sendmailConfig}")
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    public SendmailConfig getSendmailConfiguration(@PathParam(value="sendmailConfig") String sendmailConfig) {
        SendmailConfig sendmail;
        SendmailConfig sendmailConfig2 = sendmail = "default".equals(sendmailConfig) ? this.m_javamailConfigurationDao.getDefaultSendmailConfig() : this.m_javamailConfigurationDao.getSendMailConfig(sendmailConfig);
        if (sendmail == null) {
            throw JavamailConfigurationResource.getException(Response.Status.NOT_FOUND, "Sendmail configuration {} was not found.", sendmailConfig);
        }
        return sendmail;
    }

    @GET
    @Path(value="end2ends/{end2endConfig}")
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    public End2endMailConfig getEnd2EndMailConfiguration(@PathParam(value="end2endConfig") String end2endConfig) {
        End2endMailConfig end2end = this.m_javamailConfigurationDao.getEnd2endConfig(end2endConfig);
        if (end2end == null) {
            throw JavamailConfigurationResource.getException(Response.Status.NOT_FOUND, "End2End configuration {} was not found.", end2endConfig);
        }
        return end2end;
    }

    @POST
    @Path(value="readmails")
    @Consumes(value={"application/xml", "application/json", "application/atom+xml"})
    public Response setReadmailConfiguration(ReadmailConfig readmailConfig) {
        this.writeLock();
        try {
            if (readmailConfig == null) {
                throw JavamailConfigurationResource.getException(Response.Status.BAD_REQUEST, "Readmail configuration object cannot be null", new String[0]);
            }
            this.m_javamailConfigurationDao.addReadMailConfig(readmailConfig);
            this.saveConfiguration();
            Response response = Response.noContent().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    @POST
    @Path(value="sendmails")
    @Consumes(value={"application/xml", "application/json", "application/atom+xml"})
    public Response setSendmailConfiguration(SendmailConfig sendmailConfig) {
        this.writeLock();
        try {
            if (sendmailConfig == null) {
                throw JavamailConfigurationResource.getException(Response.Status.BAD_REQUEST, "Sendmail configuration object cannot be null", new String[0]);
            }
            this.m_javamailConfigurationDao.addSendMailConfig(sendmailConfig);
            this.saveConfiguration();
            Response response = Response.noContent().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    @POST
    @Path(value="end2ends")
    @Consumes(value={"application/xml", "application/json", "application/atom+xml"})
    public Response setEnd2EndMailConfiguration(End2endMailConfig end2endMailConfig) {
        this.writeLock();
        try {
            if (end2endMailConfig == null) {
                throw JavamailConfigurationResource.getException(Response.Status.BAD_REQUEST, "End2End configuration object cannot be null", new String[0]);
            }
            this.m_javamailConfigurationDao.addEnd2endMailConfig(end2endMailConfig);
            this.saveConfiguration();
            Response response = Response.noContent().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="readmails/{readmailConfig}")
    public Response updateReadmailConfiguration(@PathParam(value="readmailConfig") String readmailConfigName, MultivaluedMapImpl params) {
        this.writeLock();
        try {
            ReadmailConfig readmailConfig = this.getReadmailConfiguration(readmailConfigName);
            if (this.updateConfiguration(readmailConfig, params)) {
                this.saveConfiguration();
                Response response = Response.noContent().build();
                return response;
            }
            Response response = Response.notModified().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="sendmails/{sendmailConfig}")
    public Response updateSendmailConfiguration(@PathParam(value="sendmailConfig") String sendmailConfigName, MultivaluedMapImpl params) {
        this.writeLock();
        try {
            SendmailConfig sendmailConfig = this.getSendmailConfiguration(sendmailConfigName);
            if (this.updateConfiguration(sendmailConfig, params)) {
                this.saveConfiguration();
                Response response = Response.noContent().build();
                return response;
            }
            Response response = Response.notModified().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="end2ends/{end2endConfig}")
    public Response updateEnd2endConfiguration(@PathParam(value="end2endConfig") String end2endConfigName, MultivaluedMapImpl params) {
        this.writeLock();
        try {
            End2endMailConfig end2endConfig = this.getEnd2EndMailConfiguration(end2endConfigName);
            if (this.updateConfiguration(end2endConfig, params)) {
                this.saveConfiguration();
                Response response = Response.noContent().build();
                return response;
            }
            Response response = Response.notModified().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    @DELETE
    @Path(value="readmails/{readmailConfig}")
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    public Response removeReadmailConfig(@PathParam(value="readmailConfig") String readmailConfig) {
        if (this.m_javamailConfigurationDao.removeReadMailConfig(readmailConfig)) {
            return this.saveConfiguration();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @DELETE
    @Path(value="sendmails/{sendmailConfig}")
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    public Response removeSendmailConfig(@PathParam(value="sendmailConfig") String sendmailConfig) {
        if (this.m_javamailConfigurationDao.removeSendMailConfig(sendmailConfig)) {
            return this.saveConfiguration();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @DELETE
    @Path(value="end2ends/{end2endConfig}")
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    public Response removeEnd2endConfig(@PathParam(value="end2endConfig") String end2endConfig) {
        if (this.m_javamailConfigurationDao.removeEnd2endConfig(end2endConfig)) {
            return this.saveConfiguration();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    private boolean updateConfiguration(Object config, MultivaluedMapImpl params) {
        boolean modified = false;
        BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)config);
        for (String key : params.keySet()) {
            if (!wrapper.isWritableProperty(key)) continue;
            String stringValue = (String)params.getFirst(key);
            Object value = wrapper.convertIfNecessary((Object)stringValue, wrapper.getPropertyType(key));
            wrapper.setPropertyValue(key, value);
            modified = true;
        }
        return modified;
    }

    public Response saveConfiguration() {
        this.writeLock();
        try {
            this.m_javamailConfigurationDao.saveConfiguration();
            EventBuilder eb = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfig", "ReST");
            eb.addParam("daemonName", "EmailNBI");
            this.m_eventProxy.send(eb.getEvent());
            Response response = Response.noContent().build();
            return response;
        }
        catch (Throwable t) {
            throw JavamailConfigurationResource.getException(Response.Status.INTERNAL_SERVER_ERROR, t);
        }
        finally {
            this.writeUnlock();
        }
    }

    @XmlRootElement(name="end2end-configs")
    public static class End2endConfigList
    extends JaxbListWrapper<String> {
        public End2endConfigList() {
        }

        public End2endConfigList(List<End2endMailConfig> end2endConfigs) {
            end2endConfigs.forEach(d -> this.add(d.getName()));
        }

        @XmlElement(name="end2end-config")
        public List<String> getEnd2endConfigs() {
            return this.getObjects();
        }
    }

    @XmlRootElement(name="sendmail-configs")
    public static class ReadmailConfigList
    extends JaxbListWrapper<String> {
        public ReadmailConfigList() {
        }

        public ReadmailConfigList(List<ReadmailConfig> sendmailConfigs) {
            sendmailConfigs.forEach(d -> this.add(d.getName()));
        }

        @XmlElement(name="readmail-config")
        public List<String> getReadmailConfigs() {
            return this.getObjects();
        }
    }

    @XmlRootElement(name="sendmail-configs")
    public static class SendmailConfigList
    extends JaxbListWrapper<String> {
        public SendmailConfigList() {
        }

        public SendmailConfigList(List<SendmailConfig> sendmailConfigs) {
            sendmailConfigs.forEach(d -> this.add(d.getName()));
        }

        @XmlElement(name="sendmail-config")
        public List<String> getSendmailConfigs() {
            return this.getObjects();
        }
    }
}

