/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v1;

import java.io.IOException;
import java.util.NoSuchElementException;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.core.Response;
import org.graphdrawing.graphml.GraphmlType;
import org.opennms.features.graphml.model.GraphML;
import org.opennms.features.graphml.model.GraphMLReader;
import org.opennms.features.graphml.model.InvalidGraphException;
import org.opennms.web.rest.support.graphml.GraphmlRepository;
import org.opennms.web.rest.support.graphml.GraphmlRepositoryImpl;
import org.springframework.stereotype.Component;

@Component
@Path(value="graphml")
public class GraphMLRestService {
    private GraphmlRepository graphmlRepository = new GraphmlRepositoryImpl();

    @POST
    @Path(value="{graph-name}")
    public Response createGraph(@PathParam(value="graph-name") String graphname, GraphmlType graphmlType) throws IOException {
        if (this.graphmlRepository.exists(graphname)) {
            return Response.status((int)500).entity((Object)("Graph with name " + graphname + " already exists")).build();
        }
        try {
            GraphML convertedGraphML = GraphMLReader.convert((GraphmlType)graphmlType);
            String label = (String)convertedGraphML.getProperty("label", (Object)graphname);
            this.graphmlRepository.save(graphname, label, graphmlType);
            return Response.status((Response.Status)Response.Status.CREATED).build();
        }
        catch (InvalidGraphException ex) {
            return Response.status((int)500).entity((Object)ex.getMessage()).build();
        }
    }

    @DELETE
    @Path(value="{graph-name}")
    public Response deleteGraph(@PathParam(value="graph-name") String graphname) throws IOException {
        if (!this.graphmlRepository.exists(graphname)) {
            throw new NoSuchElementException("No GraphML file found with name  " + graphname);
        }
        this.graphmlRepository.delete(graphname);
        return Response.ok().build();
    }

    @GET
    @Path(value="{graph-name}")
    public Response getGraph(@PathParam(value="graph-name") String graphname) throws IOException {
        GraphmlType byName = this.graphmlRepository.findByName(graphname);
        return Response.ok((Object)byName).build();
    }
}

