/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v1;

import java.net.URI;
import java.security.Principal;
import java.util.Collections;
import java.util.Comparator;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.opennms.netmgt.config.UserManager;
import org.opennms.netmgt.model.OnmsUser;
import org.opennms.netmgt.model.OnmsUserList;
import org.opennms.web.rest.support.MultivaluedMapImpl;
import org.opennms.web.rest.v1.OnmsRestService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="userRestService")
@Path(value="users")
@Transactional
public class UserRestService
extends OnmsRestService {
    private static final Logger LOG = LoggerFactory.getLogger(UserRestService.class);
    private static final Comparator<OnmsUser> USER_COMPARATOR = new Comparator<OnmsUser>(){

        @Override
        public int compare(OnmsUser a, OnmsUser b) {
            return a.getUsername().compareTo(b.getUsername());
        }
    };
    @Autowired
    private UserManager m_userManager;

    @GET
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    public OnmsUserList getUsers(@Context SecurityContext securityContext) {
        try {
            return UserRestService.filterUserPasswords(securityContext, this.m_userManager.getOnmsUserList());
        }
        catch (Throwable t) {
            throw UserRestService.getException(Response.Status.INTERNAL_SERVER_ERROR, t);
        }
    }

    @GET
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    @Path(value="{username}")
    public OnmsUser getUser(@Context SecurityContext securityContext, @PathParam(value="username") String username) {
        OnmsUser user = this.getOnmsUser(username);
        return UserRestService.filterUserPassword(securityContext, user);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"application/xml"})
    public Response addUser(@Context SecurityContext securityContext, @Context UriInfo uriInfo, OnmsUser user) {
        this.writeLock();
        try {
            if (!UserRestService.hasEditRights(securityContext)) {
                throw UserRestService.getException(Response.Status.BAD_REQUEST, "User {} does not have write access to users!", securityContext.getUserPrincipal().getName());
            }
            LOG.debug("addUser: Adding user {}", (Object)user);
            try {
                this.m_userManager.save(user);
            }
            catch (Throwable t) {
                throw UserRestService.getException(Response.Status.INTERNAL_SERVER_ERROR, t);
            }
            Response response = Response.created((URI)UserRestService.getRedirectUri(uriInfo, user.getUsername())).build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="{userCriteria}")
    public Response updateUser(@Context SecurityContext securityContext, @PathParam(value="userCriteria") String userCriteria, MultivaluedMapImpl params) {
        this.writeLock();
        try {
            Response response;
            if (!UserRestService.hasEditRights(securityContext)) {
                throw UserRestService.getException(Response.Status.BAD_REQUEST, "User {} does not have write access to users!", securityContext.getUserPrincipal().getName());
            }
            OnmsUser user = this.getOnmsUser(userCriteria);
            LOG.debug("updateUser: updating user {}", (Object)user);
            boolean modified = false;
            BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)user);
            for (String key : params.keySet()) {
                if (!wrapper.isWritableProperty(key)) continue;
                String stringValue = (String)params.getFirst(key);
                Object value = wrapper.convertIfNecessary((Object)stringValue, wrapper.getPropertyType(key));
                wrapper.setPropertyValue(key, value);
                modified = true;
            }
            if (modified) {
                LOG.debug("updateUser: user {} updated", (Object)user);
                try {
                    this.m_userManager.save(user);
                }
                catch (Throwable t) {
                    throw UserRestService.getException(Response.Status.INTERNAL_SERVER_ERROR, t);
                }
                response = Response.noContent().build();
                return response;
            }
            response = Response.notModified().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="{userCriteria}")
    public Response deleteUser(@Context SecurityContext securityContext, @PathParam(value="userCriteria") String userCriteria) {
        this.writeLock();
        try {
            if (!UserRestService.hasEditRights(securityContext)) {
                throw UserRestService.getException(Response.Status.BAD_REQUEST, "User {} does not have write access to users!", securityContext.getUserPrincipal().getName());
            }
            OnmsUser user = this.getOnmsUser(userCriteria);
            LOG.debug("deleteUser: deleting user {}", (Object)user);
            try {
                this.m_userManager.deleteUser(user.getUsername());
            }
            catch (Throwable t) {
                throw UserRestService.getException(Response.Status.INTERNAL_SERVER_ERROR, t);
            }
            Response response = Response.noContent().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    private OnmsUser getOnmsUser(String username) {
        OnmsUser user = null;
        try {
            user = this.m_userManager.getOnmsUser(username);
        }
        catch (Throwable t) {
            throw UserRestService.getException(Response.Status.INTERNAL_SERVER_ERROR, t);
        }
        if (user == null) {
            throw UserRestService.getException(Response.Status.NOT_FOUND, "User {} does not exist.", username);
        }
        return user;
    }

    private static boolean hasEditRights(SecurityContext securityContext) {
        return securityContext.isUserInRole("ROLE_ADMIN") || securityContext.isUserInRole("ROLE_REST");
    }

    private static OnmsUserList filterUserPasswords(SecurityContext securityContext, OnmsUserList users) {
        Collections.sort(users.getUsers(), USER_COMPARATOR);
        for (OnmsUser user : users) {
            UserRestService.filterUserPassword(securityContext, user);
        }
        return users;
    }

    private static OnmsUser filterUserPassword(SecurityContext securityContext, OnmsUser user) {
        if (!UserRestService.hasEditRights(securityContext)) {
            Principal principal = securityContext.getUserPrincipal();
            if (!user.getUsername().equals(principal.getName())) {
                user.setPassword("xxxxxxxx");
                user.setPasswordSalted(Boolean.valueOf(false));
            }
        }
        return user;
    }
}

