/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v2;

import java.util.Collection;
import javax.ws.rs.Path;
import org.opennms.core.config.api.JaxbListWrapper;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.criteria.restrictions.Restrictions;
import org.opennms.netmgt.dao.api.NotificationDao;
import org.opennms.netmgt.model.OnmsNotification;
import org.opennms.netmgt.model.OnmsNotificationCollection;
import org.opennms.web.rest.v2.AbstractDaoRestService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@Path(value="notifications")
@Transactional
public class NotificationRestService
extends AbstractDaoRestService<OnmsNotification, Integer> {
    @Autowired
    private NotificationDao m_dao;

    protected NotificationDao getDao() {
        return this.m_dao;
    }

    @Override
    protected Class<OnmsNotification> getDaoClass() {
        return OnmsNotification.class;
    }

    @Override
    protected CriteriaBuilder getCriteriaBuilder() {
        CriteriaBuilder builder = new CriteriaBuilder(OnmsNotification.class);
        builder.alias("node", "node", Alias.JoinType.LEFT_JOIN);
        builder.alias("node.ipInterfaces", "ipInterface", Alias.JoinType.LEFT_JOIN, (Restriction)Restrictions.or((Restriction[])new Restriction[]{Restrictions.eq((String)"ipAddress", (Object)"ipInterface.ipAddress"), Restrictions.isNull((String)"ipAddress")}));
        builder.alias("event", "event", Alias.JoinType.LEFT_JOIN);
        builder.alias("serviceType", "serviceType", Alias.JoinType.LEFT_JOIN);
        builder.orderBy("notifyId").desc();
        return builder;
    }

    @Override
    protected JaxbListWrapper<OnmsNotification> createListWrapper(Collection<OnmsNotification> list) {
        return new OnmsNotificationCollection(list);
    }
}

