/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v2;

import com.googlecode.concurentlocks.ReadWriteUpdateLock;
import com.googlecode.concurentlocks.ReentrantReadWriteUpdateLock;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.apache.cxf.jaxrs.ext.search.PropertyNotFoundException;
import org.apache.cxf.jaxrs.ext.search.SearchCondition;
import org.apache.cxf.jaxrs.ext.search.SearchContext;
import org.opennms.core.config.api.JaxbListWrapper;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.netmgt.dao.api.OnmsDao;
import org.opennms.web.api.RestUtils;
import org.opennms.web.rest.support.CriteriaBuilderSearchVisitor;
import org.opennms.web.rest.support.MultivaluedMapImpl;
import org.opennms.web.rest.support.RedirectHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.annotation.Transactional;

@Transactional
public abstract class AbstractDaoRestService<T, K extends Serializable> {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractDaoRestService.class);
    private final ReadWriteUpdateLock m_globalLock = new ReentrantReadWriteUpdateLock();
    private final Lock m_writeLock = this.m_globalLock.writeLock();
    protected static final int DEFAULT_LIMIT = 10;

    protected abstract OnmsDao<T, K> getDao();

    protected abstract Class<T> getDaoClass();

    protected abstract CriteriaBuilder getCriteriaBuilder();

    protected abstract JaxbListWrapper<T> createListWrapper(Collection<T> var1);

    protected final void writeLock() {
        this.m_writeLock.lock();
    }

    protected final void writeUnlock() {
        this.m_writeLock.unlock();
    }

    protected Criteria getCriteria(UriInfo uriInfo, SearchContext searchContext) {
        MultivaluedMap params = uriInfo.getQueryParameters();
        CriteriaBuilder builder = this.getCriteriaBuilder();
        if (searchContext != null) {
            try {
                SearchCondition condition = searchContext.getCondition(this.getDaoClass());
                if (condition != null) {
                    CriteriaBuilderSearchVisitor<T> visitor = new CriteriaBuilderSearchVisitor<T>(builder, this.getDaoClass());
                    condition.accept(visitor);
                }
            }
            catch (ArrayIndexOutOfBoundsException | PropertyNotFoundException e) {
                LOG.warn(e.getClass().getSimpleName() + " while parsing FIQL search, ignoring: " + e.getMessage());
            }
        }
        AbstractDaoRestService.applyLimitOffsetOrderBy((MultivaluedMap<String, String>)params, builder);
        Criteria crit = builder.toCriteria();
        return crit;
    }

    @GET
    @Produces(value={"application/json", "application/xml", "application/atom+xml"})
    public Response get(@Context UriInfo uriInfo, @Context SearchContext searchContext) {
        Criteria crit = this.getCriteria(uriInfo, searchContext);
        List coll = this.getDao().findMatching(crit);
        if (coll == null || coll.size() < 1) {
            return Response.status((Response.Status)Response.Status.NO_CONTENT).build();
        }
        Integer offset = crit.getOffset();
        crit.setLimit(null);
        crit.setOffset(null);
        crit.setOrders(new ArrayList());
        int totalCount = this.getDao().countMatching(crit);
        JaxbListWrapper<T> list = this.createListWrapper(coll);
        list.setTotalCount(Integer.valueOf(totalCount));
        list.setOffset(offset);
        offset = offset == null ? 0 : offset;
        return Response.ok(list).header("Content-Range", (Object)String.format("items %d-%d/%d", offset, offset + coll.size() - 1, totalCount)).build();
    }

    @GET
    @Path(value="count")
    @Produces(value={"text/plain"})
    public Response getCount(@Context UriInfo uriInfo, @Context SearchContext searchContext) {
        return Response.ok((Object)String.valueOf(this.getDao().countMatching(this.getCriteria(uriInfo, searchContext)))).build();
    }

    @GET
    @Path(value="{id}")
    @Produces(value={"application/json", "application/xml", "application/atom+xml"})
    public Response get(@PathParam(value="id") K id) {
        Object retval = this.getDao().get(id);
        if (retval == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        return Response.ok((Object)retval).build();
    }

    @POST
    @Path(value="{id}")
    public Response createSpecific() {
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }

    @POST
    @Consumes(value={"application/json", "application/xml"})
    public Response create(@Context UriInfo uriInfo, T object) {
        Serializable id = this.getDao().save(object);
        return Response.created((URI)AbstractDaoRestService.getRedirectUri(uriInfo, id)).build();
    }

    @PUT
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response updateMany(@Context UriInfo uriInfo, @Context SearchContext searchContext, MultivaluedMapImpl params) {
        return Response.status((Response.Status)Response.Status.NOT_IMPLEMENTED).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Consumes(value={"application/json", "application/xml"})
    @Path(value="{id}")
    public Response update(@Context UriInfo uriInfo, @PathParam(value="id") K id, T object) {
        this.writeLock();
        try {
            if (object == null) {
                Response response = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                return response;
            }
            LOG.debug("update: updating object {}", object);
            this.getDao().saveOrUpdate(object);
            Response response = Response.noContent().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="{id}")
    public Response updateProperties(@Context UriInfo uriInfo, @PathParam(value="id") K id, MultivaluedMapImpl params) {
        this.writeLock();
        try {
            Object object = this.getDao().get(id);
            if (object == null) {
                Response response = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                return response;
            }
            LOG.debug("update: updating object {}", object);
            RestUtils.setBeanProperties((Object)object, (MultivaluedMap)params);
            LOG.debug("update: object {} updated", object);
            this.getDao().saveOrUpdate(object);
            Response response = Response.noContent().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    public Response deleteMany(@Context UriInfo uriInfo, @Context SearchContext searchContext) {
        this.writeLock();
        try {
            Criteria crit = this.getCriteria(uriInfo, searchContext);
            List objects = this.getDao().findMatching(crit);
            if (objects == null || objects.size() == 0) {
                Response response = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                return response;
            }
            for (Object object : objects) {
                LOG.debug("delete: deleting object {}", object);
                this.getDao().delete(object);
            }
            Response response = Response.ok().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="{id}")
    public Response delete(@PathParam(value="id") K criteria) {
        this.writeLock();
        try {
            Object object = this.getDao().get(criteria);
            if (object == null) {
                Response response = Response.status((Response.Status)Response.Status.NOT_FOUND).build();
                return response;
            }
            LOG.debug("delete: deleting object {}", criteria);
            this.getDao().delete(object);
            Response response = Response.ok().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    private static void applyLimitOffsetOrderBy(MultivaluedMap<String, String> p, CriteriaBuilder builder) {
        AbstractDaoRestService.applyLimitOffsetOrderBy(p, builder, 10);
    }

    private static void applyLimitOffsetOrderBy(MultivaluedMap<String, String> p, CriteriaBuilder builder, Integer defaultLimit) {
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.putAll((Map)p);
        builder.limit(defaultLimit);
        if (params.containsKey("limit") && params.getFirst("limit") != null && !"".equals(((String)params.getFirst("limit")).trim())) {
            builder.limit(Integer.valueOf(((String)params.getFirst("limit")).trim()));
            params.remove("limit");
        }
        if (params.containsKey("offset") && params.getFirst("offset") != null && !"".equals(((String)params.getFirst("offset")).trim())) {
            builder.offset(Integer.valueOf(((String)params.getFirst("offset")).trim()));
            params.remove("offset");
        }
        if (params.containsKey("orderBy") && params.getFirst("orderBy") != null && !"".equals(((String)params.getFirst("orderBy")).trim())) {
            builder.clearOrder();
            builder.orderBy(((String)params.getFirst("orderBy")).trim());
            params.remove("orderBy");
            if (params.containsKey("order") && params.getFirst("order") != null && !"".equals(((String)params.getFirst("order")).trim())) {
                if ("desc".equalsIgnoreCase(((String)params.getFirst("order")).trim())) {
                    builder.desc();
                } else {
                    builder.asc();
                }
                params.remove("order");
            }
        }
    }

    private static URI getRedirectUri(UriInfo uriInfo, Object ... pathComponents) {
        return RedirectHelper.getRedirectUri(uriInfo, pathComponents);
    }
}

