/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v1.config;

import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import javax.ws.rs.GET;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.opennms.core.config.api.ConfigurationResource;
import org.opennms.core.config.api.ConfigurationResourceException;
import org.opennms.netmgt.config.collectd.CollectdConfiguration;
import org.opennms.netmgt.config.monitoringLocations.LocationDef;
import org.opennms.netmgt.dao.api.MonitoringLocationDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="collectionConfigurationResource")
public class CollectionConfigurationResource {
    private static final Logger LOG = LoggerFactory.getLogger(CollectionConfigurationResource.class);
    @Autowired
    private MonitoringLocationDao m_monitoringLocationDao;
    @Resource(name="collectd-configuration.xml")
    private ConfigurationResource<CollectdConfiguration> m_collectdConfigResource;

    @GET
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    public Response getCollectdConfigurationForLocation(@PathParam(value="location") String location) throws ConfigurationResourceException {
        LocationDef def = (LocationDef)this.m_monitoringLocationDao.get((Serializable)((Object)location));
        if (def == null) {
            LOG.warn("Unable to find monitoring location {}", (Object)location);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        List collectionPackageNames = def.getCollectionPackageNames();
        if (collectionPackageNames != null && collectionPackageNames.size() > 0) {
            CollectdConfiguration collectdConfig = ((CollectdConfiguration)this.m_collectdConfigResource.get()).getCollectdConfigurationForPackages(collectionPackageNames);
            return Response.ok((Object)collectdConfig).build();
        }
        LOG.warn("Monitoring location {} does not have a collection package defined.", (Object)location);
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }
}

