/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v1.config;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.net.URI;
import java.util.List;
import javax.annotation.Resource;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.config.api.JaxbListWrapper;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.alarmd.northbounder.snmptrap.SnmpTrapMappingGroup;
import org.opennms.netmgt.alarmd.northbounder.snmptrap.SnmpTrapNorthbounderConfig;
import org.opennms.netmgt.alarmd.northbounder.snmptrap.SnmpTrapNorthbounderConfigDao;
import org.opennms.netmgt.alarmd.northbounder.snmptrap.SnmpTrapSink;
import org.opennms.netmgt.events.api.EventProxy;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.web.rest.support.MultivaluedMapImpl;
import org.opennms.web.rest.v1.OnmsRestService;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class SnmpTrapNorthbounderConfigurationResource
extends OnmsRestService
implements InitializingBean {
    @Resource(name="snmpTrapNorthbounderConfigDao")
    private SnmpTrapNorthbounderConfigDao m_snmpTrapNorthbounderConfigDao;
    @Resource(name="eventProxy")
    private EventProxy m_eventProxy;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.m_snmpTrapNorthbounderConfigDao, (String)"snmpTrapNorthbounderConfigDao must be set!");
        Assert.notNull((Object)this.m_eventProxy, (String)"eventProxy must be set!");
    }

    @GET
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    public Response getConfiguration() {
        return Response.ok((Object)this.m_snmpTrapNorthbounderConfigDao.getConfig()).build();
    }

    @POST
    public Response setConfiguration(@Context UriInfo uriInfo, SnmpTrapNorthbounderConfig config) {
        this.writeLock();
        try {
            File configFile = this.m_snmpTrapNorthbounderConfigDao.getConfigResource().getFile();
            JaxbUtils.marshal((Object)config, (Writer)new FileWriter(configFile));
            this.notifyDaemons();
            Response response = Response.seeOther((URI)SnmpTrapNorthbounderConfigurationResource.getRedirectUri(uriInfo, new Object[0])).build();
            return response;
        }
        catch (Throwable t) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type("text/plain").entity((Object)t.getMessage()).build());
        }
        finally {
            this.writeUnlock();
        }
    }

    @GET
    @Path(value="status")
    @Produces(value={"text/plain"})
    public Response getStatus() {
        return Response.ok((Object)this.m_snmpTrapNorthbounderConfigDao.getConfig().isEnabled()).build();
    }

    @PUT
    @Path(value="status")
    @Produces(value={"text/plain"})
    public Response getStatus(@QueryParam(value="enabled") Boolean enabled) throws WebApplicationException {
        this.writeLock();
        try {
            this.m_snmpTrapNorthbounderConfigDao.getConfig().setEnabled(enabled);
            Response response = this.saveConfiguration();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    @GET
    @Path(value="trapsinks")
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    public Response getSnmpTrapSinks() {
        SnmpTrapSinkList trapSinks = new SnmpTrapSinkList(this.m_snmpTrapNorthbounderConfigDao.getConfig().getSnmpTrapSinks());
        return Response.ok((Object)((Object)trapSinks)).build();
    }

    @GET
    @Path(value="trapsinks/{trapsinkName}")
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    public Response getSnmpTrapSink(@PathParam(value="trapsinkName") String trapSinkName) {
        SnmpTrapSink trapSink = this.m_snmpTrapNorthbounderConfigDao.getConfig().getSnmpTrapSink(trapSinkName);
        if (trapSink == null) {
            return Response.status((int)404).build();
        }
        return Response.ok((Object)trapSink).build();
    }

    @GET
    @Path(value="trapsinks/{trapsinkName}/import-mappings")
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    public Response getImportMappings(@PathParam(value="trapsinkName") String trapSinkName) {
        SnmpTrapSink trapSink = this.m_snmpTrapNorthbounderConfigDao.getConfig().getSnmpTrapSink(trapSinkName);
        if (trapSink == null) {
            return Response.status((int)404).build();
        }
        return Response.ok((Object)((Object)new ImportMappings(trapSink.getImportMappings()))).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="trapsinks")
    @Consumes(value={"application/xml", "application/json", "application/atom+xml"})
    public Response setSnmpTrapSink(@Context UriInfo uriInfo, SnmpTrapSink snmpTrapSink) {
        this.writeLock();
        try {
            this.m_snmpTrapNorthbounderConfigDao.getConfig().addSnmpTrapSink(snmpTrapSink);
            this.saveConfiguration();
            Response response = Response.seeOther((URI)SnmpTrapNorthbounderConfigurationResource.getRedirectUri(uriInfo, new Object[0])).build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    @POST
    @Path(value="trapsinks/{trapsinkName}/import-mappings")
    @Consumes(value={"application/xml", "application/json", "application/atom+xml"})
    public Response setImportMapping(@Context UriInfo uriInfo, @PathParam(value="trapsinkName") String trapSinkName, SnmpTrapMappingGroup mappingGroup) {
        this.writeLock();
        try {
            SnmpTrapSink trapSink = this.m_snmpTrapNorthbounderConfigDao.getConfig().getSnmpTrapSink(trapSinkName);
            if (trapSink == null) {
                Response response = Response.status((int)404).build();
                return response;
            }
            trapSink.addImportMapping(mappingGroup);
            this.saveConfiguration();
            Response response = Response.seeOther((URI)SnmpTrapNorthbounderConfigurationResource.getRedirectUri(uriInfo, new Object[0])).build();
            return response;
        }
        catch (Throwable t) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type("text/plain").entity((Object)t.getMessage()).build());
        }
        finally {
            this.writeUnlock();
        }
    }

    @PUT
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="trapsinks/{trapsinkName}")
    public Response updateSnmpTrapSink(@Context UriInfo uriInfo, @PathParam(value="trapsinkName") String trapSinkName, MultivaluedMapImpl params) {
        this.writeLock();
        try {
            Response response;
            boolean modified = false;
            SnmpTrapSink trapSink = this.m_snmpTrapNorthbounderConfigDao.getConfig().getSnmpTrapSink(trapSinkName);
            if (trapSink == null) {
                Response response2 = Response.status((int)404).build();
                return response2;
            }
            BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)trapSink);
            for (String key : params.keySet()) {
                if (!wrapper.isWritableProperty(key)) continue;
                String stringValue = (String)params.getFirst(key);
                Object value = wrapper.convertIfNecessary((Object)stringValue, wrapper.getPropertyType(key));
                wrapper.setPropertyValue(key, value);
                modified = true;
            }
            if (modified) {
                this.saveConfiguration();
                response = Response.seeOther((URI)SnmpTrapNorthbounderConfigurationResource.getRedirectUri(uriInfo, new Object[0])).build();
                return response;
            }
            response = Response.notModified().build();
            return response;
        }
        catch (Throwable t) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type("text/plain").entity((Object)t.getMessage()).build());
        }
        finally {
            this.writeUnlock();
        }
    }

    @PUT
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="trapsinks/{trapsinkName}/import-mappings/{mappingName}")
    public Response updateImportMapping(@Context UriInfo uriInfo, @PathParam(value="trapsinkName") String trapSinkName, @PathParam(value="mappingName") String mappingName, MultivaluedMapImpl params) {
        this.writeLock();
        try {
            Response response;
            boolean modified = false;
            SnmpTrapSink trapSink = this.m_snmpTrapNorthbounderConfigDao.getConfig().getSnmpTrapSink(trapSinkName);
            if (trapSink == null) {
                Response response2 = Response.status((int)404).build();
                return response2;
            }
            SnmpTrapMappingGroup mappingGroup = trapSink.getImportMapping(mappingName);
            if (mappingGroup == null) {
                Response response3 = Response.status((int)404).build();
                return response3;
            }
            BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)mappingGroup);
            for (String key : params.keySet()) {
                if (!wrapper.isWritableProperty(key)) continue;
                String stringValue = (String)params.getFirst(key);
                Object value = wrapper.convertIfNecessary((Object)stringValue, wrapper.getPropertyType(key));
                wrapper.setPropertyValue(key, value);
                modified = true;
            }
            if (modified) {
                trapSink.addImportMapping(mappingGroup);
                this.saveConfiguration();
                response = Response.seeOther((URI)SnmpTrapNorthbounderConfigurationResource.getRedirectUri(uriInfo, new Object[0])).build();
                return response;
            }
            response = Response.notModified().build();
            return response;
        }
        catch (Throwable t) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type("text/plain").entity((Object)t.getMessage()).build());
        }
        finally {
            this.writeUnlock();
        }
    }

    @DELETE
    @Path(value="trapsinks/{trapsinkName}/import-mappings/{mappingName}")
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    public Response removeImportMapping(@PathParam(value="trapsinkName") String trapSinkName, @PathParam(value="mappingName") String mappingName) {
        SnmpTrapSink trapSink = this.m_snmpTrapNorthbounderConfigDao.getConfig().getSnmpTrapSink(trapSinkName);
        if (trapSink == null) {
            return Response.status((int)404).build();
        }
        if (trapSink.removeImportMapping(mappingName)) {
            return this.saveConfiguration();
        }
        return Response.notModified().build();
    }

    @DELETE
    @Path(value="trapsinks/{trapsinkName}")
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    public Response removeSnmpTrapSink(@PathParam(value="trapsinkName") String trapSinkName) {
        if (this.m_snmpTrapNorthbounderConfigDao.getConfig().removeSnmpTrapSink(trapSinkName)) {
            return this.saveConfiguration();
        }
        return Response.status((int)404).build();
    }

    private Response saveConfiguration() {
        try {
            this.m_snmpTrapNorthbounderConfigDao.save();
            this.notifyDaemons();
            return Response.ok().build();
        }
        catch (Throwable t) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type("text/plain").entity((Object)t.getMessage()).build());
        }
    }

    private void notifyDaemons() throws Exception {
        EventBuilder eb = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfig", "ReST");
        eb.addParam("daemonName", "SnmpTrapNBI");
        this.m_eventProxy.send(eb.getEvent());
    }

    @XmlRootElement(name="import-mappings")
    public static class ImportMappings
    extends JaxbListWrapper<String> {
        public ImportMappings() {
        }

        public ImportMappings(List<String> mappings) {
            this.addAll(mappings);
        }

        @XmlElement(name="import-mapping")
        public List<String> getImportMappings() {
            return this.getObjects();
        }
    }

    @XmlRootElement(name="trap-sinks")
    public static class SnmpTrapSinkList
    extends JaxbListWrapper<String> {
        public SnmpTrapSinkList() {
        }

        public SnmpTrapSinkList(List<SnmpTrapSink> trapSinks) {
            trapSinks.forEach(d -> this.add(d.getName()));
        }

        @XmlElement(name="trap-sink")
        public List<String> getTrapSinks() {
            return this.getObjects();
        }
    }
}

