/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v1;

import java.net.InetAddress;
import java.net.URI;
import javax.annotation.PreDestroy;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.SnmpConfigAccessService;
import org.opennms.netmgt.config.SnmpEventInfo;
import org.opennms.netmgt.snmp.SnmpAgentConfig;
import org.opennms.web.rest.support.MultivaluedMapImpl;
import org.opennms.web.rest.v1.OnmsRestService;
import org.opennms.web.svclayer.model.SnmpInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="snmpConfigRestService")
@Path(value="snmpConfig")
@Transactional
public class SnmpConfigRestService
extends OnmsRestService {
    @Autowired
    private SnmpConfigAccessService m_accessService;

    @PreDestroy
    protected void tearDown() {
        if (this.m_accessService != null) {
            this.m_accessService.flushAll();
        }
    }

    @GET
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    @Path(value="{ipAddr}")
    public SnmpInfo getSnmpInfo(@PathParam(value="ipAddr") String ipAddr) {
        InetAddress addr = InetAddressUtils.addr((String)ipAddr);
        if (addr == null) {
            throw new WebApplicationException(Response.serverError().build());
        }
        SnmpAgentConfig config = this.m_accessService.getAgentConfig(addr);
        return new SnmpInfo(config);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Consumes(value={"application/xml", "application/json", "application/atom+xml"})
    @Path(value="{ipAddr}")
    public Response setSnmpInfo(@Context UriInfo uriInfo, @PathParam(value="ipAddr") String ipAddress, SnmpInfo snmpInfo) {
        this.writeLock();
        try {
            SnmpEventInfo eventInfo;
            if (ipAddress.contains("-")) {
                String[] addrs = SnmpConfigRestService.getAddresses(ipAddress);
                eventInfo = snmpInfo.createEventInfo(addrs[0], addrs[1]);
            } else {
                eventInfo = snmpInfo.createEventInfo(ipAddress);
            }
            this.m_accessService.define(eventInfo);
            Response response = Response.seeOther((URI)SnmpConfigRestService.getRedirectUri(uriInfo, new Object[0])).build();
            return response;
        }
        catch (Throwable e) {
            Response response = Response.serverError().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="{ipAddr}")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Transactional
    public Response updateInterface(@Context UriInfo uriInfo, @PathParam(value="ipAddr") String ipAddress, MultivaluedMapImpl params) {
        this.writeLock();
        try {
            SnmpEventInfo eventInfo;
            SnmpInfo info = new SnmpInfo();
            SnmpConfigRestService.setProperties(params, info);
            if (ipAddress.contains("-")) {
                String[] addrs = SnmpConfigRestService.getAddresses(ipAddress);
                eventInfo = info.createEventInfo(addrs[0], addrs[1]);
            } else {
                eventInfo = info.createEventInfo(ipAddress);
            }
            this.m_accessService.define(eventInfo);
            Response response = Response.seeOther((URI)SnmpConfigRestService.getRedirectUri(uriInfo, new Object[0])).build();
            return response;
        }
        catch (Throwable e) {
            Response response = Response.serverError().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    protected static String[] getAddresses(String input) {
        if (input == null || input.trim().isEmpty()) {
            return new String[]{null, null};
        }
        return input.trim().split("-", 2);
    }
}

