/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v1;

import java.net.InetAddress;
import java.net.URI;
import java.util.Collection;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ResourceContext;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.events.api.EventProxy;
import org.opennms.netmgt.events.api.EventProxyException;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsIpInterfaceList;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.web.rest.support.MultivaluedMapImpl;
import org.opennms.web.rest.v1.OnmsMonitoredServiceResource;
import org.opennms.web.rest.v1.OnmsRestService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="onmsIpInterfaceResource")
@Transactional
public class OnmsIpInterfaceResource
extends OnmsRestService {
    private static final Logger LOG = LoggerFactory.getLogger(OnmsIpInterfaceResource.class);
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private IpInterfaceDao m_ipInterfaceDao;
    @Autowired
    @Qualifier(value="eventProxy")
    private EventProxy m_eventProxy;

    @GET
    @Produces(value={"application/xml", "application/json"})
    public OnmsIpInterfaceList getIpInterfaces(@Context UriInfo uriInfo, @PathParam(value="nodeCriteria") String nodeCriteria) {
        LOG.debug("getIpInterfaces: reading interfaces for node {}", (Object)nodeCriteria);
        OnmsNode node = this.m_nodeDao.get(nodeCriteria);
        MultivaluedMap params = uriInfo.getQueryParameters();
        CriteriaBuilder builder = new CriteriaBuilder(OnmsIpInterface.class);
        builder.alias("monitoredServices.serviceType", "serviceType", Alias.JoinType.LEFT_JOIN);
        builder.ne("isManaged", (Object)"D");
        builder.limit(Integer.valueOf(20));
        OnmsIpInterfaceResource.applyQueryFilters((MultivaluedMap<String, String>)params, builder);
        builder.alias("node", "node");
        builder.eq("node.id", (Object)node.getId());
        OnmsIpInterfaceList interfaceList = new OnmsIpInterfaceList((Collection)this.m_ipInterfaceDao.findMatching(builder.toCriteria()));
        interfaceList.setTotalCount(Integer.valueOf(this.m_ipInterfaceDao.countMatching(builder.count().toCriteria())));
        return interfaceList;
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="{ipAddress}")
    public OnmsIpInterface getIpInterface(@PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="ipAddress") String ipAddress) {
        OnmsNode node = this.m_nodeDao.get(nodeCriteria);
        if (node == null) {
            throw OnmsIpInterfaceResource.getException(Response.Status.BAD_REQUEST, "getIpInterface: can't find node " + nodeCriteria, new String[0]);
        }
        return node.getIpInterfaceByIpAddress(InetAddressUtils.getInetAddress((String)ipAddress));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"application/xml"})
    public Response addIpInterface(@Context UriInfo uriInfo, @PathParam(value="nodeCriteria") String nodeCriteria, OnmsIpInterface ipInterface) {
        this.writeLock();
        try {
            OnmsNode node = this.m_nodeDao.get(nodeCriteria);
            if (node == null) {
                throw OnmsIpInterfaceResource.getException(Response.Status.BAD_REQUEST, "addIpInterface: can't find node " + nodeCriteria, new String[0]);
            }
            if (ipInterface == null) {
                throw OnmsIpInterfaceResource.getException(Response.Status.BAD_REQUEST, "addIpInterface: ipInterface object cannot be null", new String[0]);
            }
            if (ipInterface.getIpAddress() == null) {
                throw OnmsIpInterfaceResource.getException(Response.Status.BAD_REQUEST, "addIpInterface: ipInterface's ipAddress cannot be null", new String[0]);
            }
            if (ipInterface.getIpAddress().getAddress() == null) {
                throw OnmsIpInterfaceResource.getException(Response.Status.BAD_REQUEST, "addIpInterface: ipInterface's ipAddress bytes cannot be null", new String[0]);
            }
            LOG.debug("addIpInterface: adding interface {}", (Object)ipInterface);
            node.addIpInterface(ipInterface);
            this.m_ipInterfaceDao.save((Object)ipInterface);
            EventBuilder bldr = new EventBuilder("uei.opennms.org/nodes/nodeGainedInterface", this.getClass().getName());
            bldr.setNodeid((long)node.getId().intValue());
            bldr.setInterface(ipInterface.getIpAddress());
            try {
                this.m_eventProxy.send(bldr.getEvent());
            }
            catch (EventProxyException ex) {
                throw OnmsIpInterfaceResource.getException(Response.Status.BAD_REQUEST, ex.getMessage(), new String[0]);
            }
            Response response = Response.seeOther((URI)OnmsIpInterfaceResource.getRedirectUri(uriInfo, InetAddressUtils.str((InetAddress)ipInterface.getIpAddress()))).build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="{ipAddress}")
    public Response updateIpInterface(@Context UriInfo uriInfo, @PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="ipAddress") String ipAddress, MultivaluedMapImpl params) {
        this.writeLock();
        try {
            OnmsNode node = this.m_nodeDao.get(nodeCriteria);
            if (node == null) {
                throw OnmsIpInterfaceResource.getException(Response.Status.BAD_REQUEST, "deleteIpInterface: can't find node " + nodeCriteria, new String[0]);
            }
            OnmsIpInterface ipInterface = node.getIpInterfaceByIpAddress(ipAddress);
            if (ipInterface == null) {
                throw OnmsIpInterfaceResource.getException(Response.Status.CONFLICT, "deleteIpInterface: can't find interface with ip address " + ipAddress + " for node " + nodeCriteria, new String[0]);
            }
            LOG.debug("updateIpInterface: updating ip interface {}", (Object)ipInterface);
            BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)ipInterface);
            for (String key : params.keySet()) {
                if ("nodeId".equals(key) || !wrapper.isWritableProperty(key)) continue;
                String stringValue = (String)params.getFirst(key);
                Object value = wrapper.convertIfNecessary((Object)stringValue, wrapper.getPropertyType(key));
                wrapper.setPropertyValue(key, value);
            }
            LOG.debug("updateIpInterface: ip interface {} updated", (Object)ipInterface);
            this.m_ipInterfaceDao.saveOrUpdate((Object)ipInterface);
            Response response = Response.seeOther((URI)OnmsIpInterfaceResource.getRedirectUri(uriInfo, new Object[0])).build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="{ipAddress}")
    public Response deleteIpInterface(@PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="ipAddress") String ipAddress) {
        this.writeLock();
        try {
            OnmsNode node = this.m_nodeDao.get(nodeCriteria);
            if (node == null) {
                throw OnmsIpInterfaceResource.getException(Response.Status.BAD_REQUEST, "deleteIpInterface: can't find node " + nodeCriteria, new String[0]);
            }
            OnmsIpInterface intf = node.getIpInterfaceByIpAddress(InetAddressUtils.getInetAddress((String)ipAddress));
            if (intf == null) {
                throw OnmsIpInterfaceResource.getException(Response.Status.CONFLICT, "deleteIpInterface: can't find interface with ip address " + ipAddress + " for node " + nodeCriteria, new String[0]);
            }
            LOG.debug("deleteIpInterface: deleting interface {} from node {}", (Object)ipAddress, (Object)nodeCriteria);
            node.getIpInterfaces().remove(intf);
            this.m_nodeDao.save((Object)node);
            EventBuilder bldr = new EventBuilder("uei.opennms.org/nodes/interfaceDeleted", this.getClass().getName());
            bldr.setNodeid((long)node.getId().intValue());
            bldr.setInterface(InetAddressUtils.addr((String)ipAddress));
            try {
                this.m_eventProxy.send(bldr.getEvent());
            }
            catch (EventProxyException ex) {
                throw OnmsIpInterfaceResource.getException(Response.Status.BAD_REQUEST, ex.getMessage(), new String[0]);
            }
            Response response = Response.ok().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    @Path(value="{ipAddress}/services")
    public OnmsMonitoredServiceResource getServices(@Context ResourceContext context) {
        return (OnmsMonitoredServiceResource)context.getResource(OnmsMonitoredServiceResource.class);
    }
}

