/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v1;

import java.io.Serializable;
import java.text.ParseException;
import java.util.Collection;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.netmgt.dao.api.MinionDao;
import org.opennms.netmgt.model.OnmsMinionCollection;
import org.opennms.netmgt.model.minion.OnmsMinion;
import org.opennms.web.rest.v1.OnmsRestService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="minionRestService")
@Path(value="minions")
public class MinionRestService
extends OnmsRestService {
    @Autowired
    private MinionDao m_minionDao;

    @GET
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    @Path(value="{minionId}")
    @Transactional
    public OnmsMinion getMinion(@PathParam(value="minionId") String minionId) {
        return (OnmsMinion)this.m_minionDao.get((Serializable)((Object)minionId));
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="{minionId}/{key}")
    @Transactional
    public String getMinionProperty(@PathParam(value="minionId") String minionId, @PathParam(value="key") String key) {
        return (String)this.m_minionDao.findById(minionId).getProperties().get(key);
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="count")
    @Transactional
    public String getCount() {
        return Integer.toString(this.m_minionDao.countAll());
    }

    @GET
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    @Transactional
    public OnmsMinionCollection getMinions(@Context UriInfo uriInfo) throws ParseException {
        CriteriaBuilder builder = this.getCriteriaBuilder((MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        OnmsMinionCollection coll = new OnmsMinionCollection((Collection)this.m_minionDao.findMatching(builder.toCriteria()));
        coll.setTotalCount(Integer.valueOf(this.m_minionDao.countMatching(builder.clearOrder().toCriteria())));
        return coll;
    }

    private CriteriaBuilder getCriteriaBuilder(MultivaluedMap<String, String> params) {
        CriteriaBuilder builder = new CriteriaBuilder(OnmsMinion.class);
        MinionRestService.applyQueryFilters(params, builder);
        return builder;
    }
}

