/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v1;

import java.io.Serializable;
import java.net.URI;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import javax.ws.rs.Consumes;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;
import org.opennms.core.criteria.Alias;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.netmgt.dao.api.EventDao;
import org.opennms.netmgt.model.OnmsEvent;
import org.opennms.netmgt.model.OnmsEventCollection;
import org.opennms.web.rest.support.MultivaluedMapImpl;
import org.opennms.web.rest.v1.OnmsRestService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="eventRestService")
@Path(value="events")
public class EventRestService
extends OnmsRestService {
    private static final DateTimeFormatter ISO8601_FORMATTER_MILLIS = ISODateTimeFormat.dateTime();
    private static final DateTimeFormatter ISO8601_FORMATTER = ISODateTimeFormat.dateTimeNoMillis();
    @Autowired
    private EventDao m_eventDao;

    @GET
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    @Path(value="{eventId}")
    @Transactional
    public OnmsEvent getEvent(@PathParam(value="eventId") Integer eventId) {
        return (OnmsEvent)this.m_eventDao.get((Serializable)eventId);
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="count")
    @Transactional
    public String getCount() {
        return Integer.toString(this.m_eventDao.countAll());
    }

    @GET
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    @Transactional
    public OnmsEventCollection getEvents(@Context UriInfo uriInfo) throws ParseException {
        CriteriaBuilder builder = EventRestService.getCriteriaBuilder((MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        builder.orderBy("eventTime").asc();
        OnmsEventCollection coll = new OnmsEventCollection((Collection)this.m_eventDao.findMatching(builder.toCriteria()));
        coll.setTotalCount(Integer.valueOf(this.m_eventDao.countMatching(builder.count().toCriteria())));
        return coll;
    }

    @GET
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    @Path(value="between")
    @Transactional
    public OnmsEventCollection getEventsBetween(@Context UriInfo uriInfo) throws ParseException {
        Date end;
        Date begin;
        String column;
        MultivaluedMap params = uriInfo.getQueryParameters();
        if (params.containsKey((Object)"column")) {
            column = (String)params.getFirst((Object)"column");
            params.remove((Object)"column");
        } else {
            column = "eventTime";
        }
        if (params.containsKey((Object)"begin")) {
            try {
                begin = ISO8601_FORMATTER.parseLocalDateTime((String)params.getFirst((Object)"begin")).toDate();
            }
            catch (Throwable t1) {
                try {
                    begin = ISO8601_FORMATTER_MILLIS.parseDateTime((String)params.getFirst((Object)"begin")).toDate();
                }
                catch (Throwable t2) {
                    throw EventRestService.getException(Response.Status.BAD_REQUEST, "Can't parse start date", new String[0]);
                }
            }
            params.remove((Object)"begin");
        } else {
            begin = new Date(0L);
        }
        if (params.containsKey((Object)"end")) {
            try {
                end = ISO8601_FORMATTER.parseLocalDateTime((String)params.getFirst((Object)"end")).toDate();
            }
            catch (Throwable t1) {
                try {
                    end = ISO8601_FORMATTER_MILLIS.parseLocalDateTime((String)params.getFirst((Object)"end")).toDate();
                }
                catch (Throwable t2) {
                    throw EventRestService.getException(Response.Status.BAD_REQUEST, "Can't parse end date", new String[0]);
                }
            }
            params.remove((Object)"end");
        } else {
            end = new Date();
        }
        CriteriaBuilder builder = EventRestService.getCriteriaBuilder((MultivaluedMap<String, String>)params);
        builder.match("all");
        try {
            builder.between(column, (Object)begin, (Object)end);
        }
        catch (Throwable t) {
            throw EventRestService.getException(Response.Status.BAD_REQUEST, "Unable to parse " + begin + " and " + end + " as dates!", new String[0]);
        }
        OnmsEventCollection coll = new OnmsEventCollection((Collection)this.m_eventDao.findMatching(builder.toCriteria()));
        coll.setTotalCount(Integer.valueOf(this.m_eventDao.countMatching(builder.count().toCriteria())));
        return coll;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="{eventId}")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Transactional
    public Response updateEvent(@Context SecurityContext securityContext, @Context UriInfo uriInfo, @PathParam(value="eventId") String eventId, @FormParam(value="ack") Boolean ack) {
        this.writeLock();
        try {
            OnmsEvent event = (OnmsEvent)this.m_eventDao.get((Serializable)Integer.valueOf(eventId));
            if (ack == null) {
                throw EventRestService.getException(Response.Status.BAD_REQUEST, "Must supply the 'ack' parameter, set to either 'true' or 'false'", new String[0]);
            }
            this.processEventAck(securityContext, event, ack);
            Response response = Response.seeOther((URI)EventRestService.getRedirectUri(uriInfo, new Object[0])).build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Transactional
    public Response updateEvents(@Context SecurityContext securityContext, @Context UriInfo uriInfo, MultivaluedMapImpl formProperties) {
        this.writeLock();
        try {
            Boolean ack = false;
            if (formProperties.containsKey("ack")) {
                ack = "true".equals(formProperties.getFirst("ack"));
                formProperties.remove("ack");
            }
            CriteriaBuilder builder = EventRestService.getCriteriaBuilder(formProperties);
            builder.orderBy("eventTime").desc();
            for (OnmsEvent event : this.m_eventDao.findMatching(builder.toCriteria())) {
                this.processEventAck(securityContext, event, ack);
            }
            Response response = Response.seeOther((URI)EventRestService.getRedirectUri(uriInfo, new Object[0])).build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    private void processEventAck(SecurityContext securityContext, OnmsEvent event, Boolean ack) {
        if (ack.booleanValue()) {
            event.setEventAckTime(new Date());
            event.setEventAckUser(securityContext.getUserPrincipal().getName());
        } else {
            event.setEventAckTime(null);
            event.setEventAckUser(null);
        }
        this.m_eventDao.save((Object)event);
    }

    private static CriteriaBuilder getCriteriaBuilder(MultivaluedMap<String, String> params) {
        CriteriaBuilder builder = new CriteriaBuilder(OnmsEvent.class);
        builder.alias("node", "node", Alias.JoinType.LEFT_JOIN);
        builder.alias("node.snmpInterfaces", "snmpInterface", Alias.JoinType.LEFT_JOIN);
        builder.alias("node.ipInterfaces", "ipInterface", Alias.JoinType.LEFT_JOIN);
        builder.alias("serviceType", "serviceType", Alias.JoinType.LEFT_JOIN);
        EventRestService.applyQueryFilters(params, builder);
        return builder;
    }
}

