/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v1;

import java.io.Serializable;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.netmgt.dao.api.AcknowledgmentDao;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.model.AckAction;
import org.opennms.netmgt.model.Acknowledgeable;
import org.opennms.netmgt.model.OnmsAcknowledgment;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsAlarmCollection;
import org.opennms.netmgt.model.alarm.AlarmSummaryCollection;
import org.opennms.web.rest.support.MultivaluedMapImpl;
import org.opennms.web.rest.v1.AlarmRestServiceBase;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="alarmRestService")
@Path(value="alarms")
public class AlarmRestService
extends AlarmRestServiceBase {
    @Autowired
    private AlarmDao m_alarmDao;
    @Autowired
    private AcknowledgmentDao m_ackDao;

    @GET
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    @Path(value="{alarmId}")
    @Transactional
    public Response getAlarm(@Context SecurityContext securityContext, @PathParam(value="alarmId") Integer alarmId) {
        AlarmRestService.assertUserReadCredentials(securityContext);
        if ("summaries".equals(alarmId)) {
            AlarmSummaryCollection collection = new AlarmSummaryCollection((Collection)this.m_alarmDao.getNodeAlarmSummaries());
            return collection == null ? Response.noContent().build() : Response.ok((Object)collection).build();
        }
        OnmsAlarm alarm = (OnmsAlarm)this.m_alarmDao.get((Serializable)alarmId);
        return alarm == null ? Response.noContent().build() : Response.ok((Object)alarm).build();
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="count")
    @Transactional
    public String getCount(@Context SecurityContext securityContext) {
        AlarmRestService.assertUserReadCredentials(securityContext);
        return Integer.toString(this.m_alarmDao.countAll());
    }

    @GET
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    @Transactional
    public OnmsAlarmCollection getAlarms(@Context SecurityContext securityContext, @Context UriInfo uriInfo) {
        AlarmRestService.assertUserReadCredentials(securityContext);
        CriteriaBuilder builder = this.getCriteriaBuilder((MultivaluedMap<String, String>)uriInfo.getQueryParameters(), false);
        builder.distinct();
        OnmsAlarmCollection coll = new OnmsAlarmCollection((Collection)this.m_alarmDao.findMatching(builder.toCriteria()));
        coll.setTotalCount(Integer.valueOf(this.m_alarmDao.countMatching(builder.count().toCriteria())));
        return coll;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="{alarmId}")
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Transactional
    public Response updateAlarm(@Context UriInfo uriInfo, @Context SecurityContext securityContext, @PathParam(value="alarmId") Integer alarmId, MultivaluedMapImpl formProperties) {
        this.writeLock();
        try {
            if (alarmId == null) {
                Response response = this.getBadRequestResponse("Unable to determine alarm ID to update based on query path.");
                return response;
            }
            String ackValue = (String)formProperties.getFirst("ack");
            formProperties.remove("ack");
            String escalateValue = (String)formProperties.getFirst("escalate");
            formProperties.remove("escalate");
            String clearValue = (String)formProperties.getFirst("clear");
            formProperties.remove("clear");
            String ackUserValue = (String)formProperties.getFirst("ackUser");
            formProperties.remove("ackUser");
            OnmsAlarm alarm = (OnmsAlarm)this.m_alarmDao.get((Serializable)alarmId);
            if (alarm == null) {
                Response response = this.getBadRequestResponse("Unable to locate alarm with ID '" + alarmId + "'");
                return response;
            }
            String ackUser = ackUserValue == null ? securityContext.getUserPrincipal().getName() : ackUserValue;
            AlarmRestService.assertUserEditCredentials(securityContext, ackUser);
            OnmsAcknowledgment acknowledgement = new OnmsAcknowledgment((Acknowledgeable)alarm, ackUser);
            acknowledgement.setAckAction(AckAction.UNSPECIFIED);
            if (ackValue != null) {
                if (Boolean.parseBoolean(ackValue)) {
                    acknowledgement.setAckAction(AckAction.ACKNOWLEDGE);
                } else {
                    acknowledgement.setAckAction(AckAction.UNACKNOWLEDGE);
                }
            } else if (escalateValue != null) {
                if (Boolean.parseBoolean(escalateValue)) {
                    acknowledgement.setAckAction(AckAction.ESCALATE);
                }
            } else if (clearValue != null) {
                if (Boolean.parseBoolean(clearValue)) {
                    acknowledgement.setAckAction(AckAction.CLEAR);
                }
            } else {
                Response response = this.getBadRequestResponse("Must supply one of the 'ack', 'escalate', or 'clear' parameters, set to either 'true' or 'false'.");
                return response;
            }
            this.m_ackDao.processAck(acknowledgement);
            Response response = Response.seeOther((URI)AlarmRestService.getRedirectUri(uriInfo, new Object[0])).build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Transactional
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response updateAlarms(@Context UriInfo uriInfo, @Context SecurityContext securityContext, MultivaluedMapImpl formProperties) {
        this.writeLock();
        try {
            Response response;
            String ackValue = (String)formProperties.getFirst("ack");
            formProperties.remove("ack");
            String escalateValue = (String)formProperties.getFirst("escalate");
            formProperties.remove("escalate");
            String clearValue = (String)formProperties.getFirst("clear");
            formProperties.remove("clear");
            CriteriaBuilder builder = this.getCriteriaBuilder(formProperties, false);
            builder.distinct();
            builder.limit(Integer.valueOf(0));
            builder.offset(Integer.valueOf(0));
            String ackUser = formProperties.containsKey("ackUser") ? (String)formProperties.getFirst("ackUser") : securityContext.getUserPrincipal().getName();
            formProperties.remove("ackUser");
            AlarmRestService.assertUserEditCredentials(securityContext, ackUser);
            List alarms = this.m_alarmDao.findMatching(builder.toCriteria());
            for (OnmsAlarm alarm : alarms) {
                OnmsAcknowledgment acknowledgement = new OnmsAcknowledgment((Acknowledgeable)alarm, ackUser);
                acknowledgement.setAckAction(AckAction.UNSPECIFIED);
                if (ackValue != null) {
                    if (Boolean.parseBoolean(ackValue)) {
                        acknowledgement.setAckAction(AckAction.ACKNOWLEDGE);
                    } else {
                        acknowledgement.setAckAction(AckAction.UNACKNOWLEDGE);
                    }
                } else if (escalateValue != null) {
                    if (Boolean.parseBoolean(escalateValue)) {
                        acknowledgement.setAckAction(AckAction.ESCALATE);
                    }
                } else if (clearValue != null) {
                    if (Boolean.parseBoolean(clearValue)) {
                        acknowledgement.setAckAction(AckAction.CLEAR);
                    }
                } else {
                    throw AlarmRestService.getException(Response.Status.BAD_REQUEST, "Must supply one of the 'ack', 'escalate', or 'clear' parameters, set to either 'true' or 'false'.", new String[0]);
                }
                this.m_ackDao.processAck(acknowledgement);
            }
            if (alarms.size() == 1) {
                response = Response.seeOther((URI)AlarmRestService.getRedirectUri(uriInfo, ((OnmsAlarm)alarms.get(0)).getId())).build();
                return response;
            }
            response = Response.seeOther((URI)AlarmRestService.getRedirectUri(uriInfo, new Object[0])).build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    private static void assertUserReadCredentials(SecurityContext securityContext) {
        String currentUser = securityContext.getUserPrincipal().getName();
        if (securityContext.isUserInRole("ROLE_ADMIN")) {
            return;
        }
        if (securityContext.isUserInRole("ROLE_REST") || securityContext.isUserInRole("ROLE_USER") || securityContext.isUserInRole("ROLE_MOBILE")) {
            return;
        }
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("User '" + currentUser + "', is not allowed to read alarms.")).type("text/plain").build());
    }

    private static void assertUserEditCredentials(SecurityContext securityContext, String ackUser) {
        String currentUser = securityContext.getUserPrincipal().getName();
        if (securityContext.isUserInRole("ROLE_ADMIN")) {
            return;
        }
        if (securityContext.isUserInRole("ROLE_READONLY")) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("User '" + currentUser + "', is a read-only user!")).type("text/plain").build());
        }
        if ((securityContext.isUserInRole("ROLE_REST") || securityContext.isUserInRole("ROLE_USER") || securityContext.isUserInRole("ROLE_MOBILE")) && ackUser.equals(currentUser)) {
            return;
        }
        throw new WebApplicationException(Response.status((Response.Status)Response.Status.FORBIDDEN).entity((Object)("User '" + currentUser + "', is not allowed to perform updates to alarms as user '" + ackUser + "'")).type("text/plain").build());
    }
}

