/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v1.config;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.net.URI;
import java.util.List;
import javax.annotation.Resource;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.config.api.JaxbListWrapper;
import org.opennms.core.xml.JaxbUtils;
import org.opennms.netmgt.alarmd.northbounder.email.EmailDestination;
import org.opennms.netmgt.alarmd.northbounder.email.EmailNorthbounderConfig;
import org.opennms.netmgt.alarmd.northbounder.email.EmailNorthbounderConfigDao;
import org.opennms.netmgt.events.api.EventProxy;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.web.rest.support.MultivaluedMapImpl;
import org.opennms.web.rest.v1.OnmsRestService;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class EmailNorthbounderConfigurationResource
extends OnmsRestService
implements InitializingBean {
    @Resource(name="emailNorthbounderConfigDao")
    private EmailNorthbounderConfigDao m_emailNorthbounderConfigDao;
    @Resource(name="eventProxy")
    private EventProxy m_eventProxy;

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.m_emailNorthbounderConfigDao, (String)"emailNorthbounderConfigDao must be set!");
        Assert.notNull((Object)this.m_eventProxy, (String)"eventProxy must be set!");
    }

    @GET
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    public Response getConfiguration() {
        return Response.ok((Object)this.m_emailNorthbounderConfigDao.getConfig()).build();
    }

    @POST
    public Response setConfiguration(@Context UriInfo uriInfo, EmailNorthbounderConfig config) {
        this.writeLock();
        try {
            File configFile = this.m_emailNorthbounderConfigDao.getConfigResource().getFile();
            JaxbUtils.marshal((Object)config, (Writer)new FileWriter(configFile));
            this.notifyDaemons();
            Response response = Response.seeOther((URI)EmailNorthbounderConfigurationResource.getRedirectUri(uriInfo, new Object[0])).build();
            return response;
        }
        catch (Throwable t) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type("text/plain").entity((Object)t.getMessage()).build());
        }
        finally {
            this.writeUnlock();
        }
    }

    @GET
    @Path(value="status")
    @Produces(value={"text/plain"})
    public Response getStatus() {
        return Response.ok((Object)this.m_emailNorthbounderConfigDao.getConfig().isEnabled()).build();
    }

    @PUT
    @Path(value="status")
    @Produces(value={"text/plain"})
    public Response getStatus(@QueryParam(value="enabled") Boolean enabled) throws WebApplicationException {
        this.writeLock();
        try {
            this.m_emailNorthbounderConfigDao.getConfig().setEnabled(enabled);
            Response response = this.saveConfiguration();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    @GET
    @Path(value="destinations")
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    public Response getEmailDestinations() {
        EmailDestinationList destinations = new EmailDestinationList(this.m_emailNorthbounderConfigDao.getConfig().getEmailDestinations());
        return Response.ok((Object)((Object)destinations)).build();
    }

    @GET
    @Path(value="destinations/{destinationName}")
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    public Response getEmailDestination(@PathParam(value="destinationName") String destinationName) {
        EmailDestination destination = this.m_emailNorthbounderConfigDao.getConfig().getEmailDestination(destinationName);
        if (destination == null) {
            return Response.status((int)404).build();
        }
        return Response.ok((Object)destination).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="destinations")
    @Consumes(value={"application/xml", "application/json", "application/atom+xml"})
    public Response setEmailDestination(@Context UriInfo uriInfo, EmailDestination destination) {
        this.writeLock();
        try {
            this.m_emailNorthbounderConfigDao.getConfig().addEmailDestination(destination);
            this.saveConfiguration();
            Response response = Response.seeOther((URI)EmailNorthbounderConfigurationResource.getRedirectUri(uriInfo, new Object[0])).build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    @PUT
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="destinations/{destinationName}")
    public Response updateEmailDestination(@Context UriInfo uriInfo, @PathParam(value="destinationName") String destinationName, MultivaluedMapImpl params) {
        this.writeLock();
        try {
            Response response;
            boolean modified = false;
            EmailDestination destination = this.m_emailNorthbounderConfigDao.getConfig().getEmailDestination(destinationName);
            if (destination == null) {
                Response response2 = Response.status((int)404).build();
                return response2;
            }
            BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)destination);
            for (String key : params.keySet()) {
                if (!wrapper.isWritableProperty(key)) continue;
                String stringValue = (String)params.getFirst(key);
                Object value = wrapper.convertIfNecessary((Object)stringValue, wrapper.getPropertyType(key));
                wrapper.setPropertyValue(key, value);
                modified = true;
            }
            if (modified) {
                this.saveConfiguration();
                response = Response.seeOther((URI)EmailNorthbounderConfigurationResource.getRedirectUri(uriInfo, new Object[0])).build();
                return response;
            }
            response = Response.notModified().build();
            return response;
        }
        catch (Throwable t) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type("text/plain").entity((Object)t.getMessage()).build());
        }
        finally {
            this.writeUnlock();
        }
    }

    @DELETE
    @Path(value="destinations/{destinationName}")
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    public Response removeEmailDestination(@PathParam(value="destinationName") String destinationName) {
        if (this.m_emailNorthbounderConfigDao.getConfig().removeEmailDestination(destinationName)) {
            return this.saveConfiguration();
        }
        return Response.status((int)404).build();
    }

    private Response saveConfiguration() {
        try {
            this.m_emailNorthbounderConfigDao.save();
            this.notifyDaemons();
            return Response.ok().build();
        }
        catch (Throwable t) {
            throw new WebApplicationException(Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).type("text/plain").entity((Object)t.getMessage()).build());
        }
    }

    private void notifyDaemons() throws Exception {
        EventBuilder eb = new EventBuilder("uei.opennms.org/internal/reloadDaemonConfig", "ReST");
        eb.addParam("daemonName", "EmailNBI");
        this.m_eventProxy.send(eb.getEvent());
    }

    @XmlRootElement(name="email-destinations")
    public static class EmailDestinationList
    extends JaxbListWrapper<String> {
        public EmailDestinationList() {
        }

        public EmailDestinationList(List<EmailDestination> destinations) {
            destinations.forEach(d -> this.add(d.getName()));
        }

        @XmlElement(name="destination")
        public List<String> getDestinations() {
            return this.getObjects();
        }
    }
}

