/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v1;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.HashMap;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.json.JSONObject;
import org.opennms.web.rest.v1.OnmsRestService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="infoRestService")
@Path(value="info")
@Transactional
public class InfoRestService
extends OnmsRestService {
    private static final Logger LOG = LoggerFactory.getLogger(InfoRestService.class);
    private static final String m_displayVersion = System.getProperty("version.display", "");
    private static final String m_version;

    @GET
    @Produces(value={"application/json"})
    public Response getInfo() throws ParseException {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("displayVersion", m_displayVersion);
        info.put("version", m_version);
        InputStream installerProperties = this.getClass().getResourceAsStream("/installer.properties");
        if (installerProperties != null) {
            Properties props = new Properties();
            try {
                props.load(installerProperties);
                installerProperties.close();
                info.put("packageName", (String)props.get("install.package.name"));
                info.put("packageDescription", (String)props.get("install.package.description"));
            }
            catch (IOException e) {
                LOG.debug("Unable to read from installer.properties in the classpath.", (Throwable)e);
            }
        }
        JSONObject jo = new JSONObject(info);
        return Response.ok((Object)jo.toString(), (String)"application/json").build();
    }

    static {
        Pattern versionPattern = Pattern.compile("^(\\d+\\.\\d+\\.\\d+).*?$");
        Matcher m = versionPattern.matcher(m_displayVersion);
        m_version = m.matches() ? m.group(1) : m_displayVersion;
    }
}

