/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.cxf.jaxrs.ext.search.PrimitiveStatement;
import org.apache.cxf.jaxrs.ext.search.SearchCondition;
import org.apache.cxf.jaxrs.ext.search.SearchUtils;
import org.apache.cxf.jaxrs.ext.search.visitor.AbstractSearchConditionVisitor;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.core.criteria.restrictions.AllRestriction;
import org.opennms.core.criteria.restrictions.Restriction;
import org.opennms.core.criteria.restrictions.Restrictions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CriteriaBuilderSearchVisitor<T>
extends AbstractSearchConditionVisitor<T, CriteriaBuilder> {
    private static final Logger LOG = LoggerFactory.getLogger(CriteriaBuilderSearchVisitor.class);
    private final Class<T> m_class;
    private CriteriaBuilder m_criteriaBuilder;

    public CriteriaBuilderSearchVisitor(CriteriaBuilder criteriaBuilder, Class<T> clazz) {
        this(criteriaBuilder, clazz, null);
    }

    public CriteriaBuilderSearchVisitor(CriteriaBuilder criteriaBuilder, Class<T> clazz, Map<String, String> fieldMap) {
        super(fieldMap);
        this.m_class = clazz;
        this.m_criteriaBuilder = criteriaBuilder;
        this.setWildcardStringMatch(true);
    }

    public void visit(SearchCondition<T> sc) {
        PrimitiveStatement statement = sc.getStatement();
        if (statement != null) {
            if (statement.getProperty() != null) {
                String name = this.getRealPropertyName(statement.getProperty());
                AbstractSearchConditionVisitor.ClassValue clsValue = this.getPrimitiveFieldClass(statement, name, statement.getValue().getClass(), statement.getValueType(), statement.getValue());
                boolean isWildcard = false;
                if (String.class.equals((Object)clsValue.getCls()) && SearchUtils.containsWildcard((String)((String)clsValue.getValue()))) {
                    isWildcard = true;
                    clsValue.setValue((Object)SearchUtils.toSqlWildcardString((String)((String)clsValue.getValue()), (boolean)this.isWildcardStringMatch()));
                }
                switch (sc.getConditionType()) {
                    case EQUALS: {
                        if (isWildcard) {
                            this.m_criteriaBuilder.like(name, clsValue.getValue());
                            break;
                        }
                        this.m_criteriaBuilder.eq(name, clsValue.getValue());
                        break;
                    }
                    case NOT_EQUALS: {
                        if (isWildcard) {
                            this.m_criteriaBuilder.not().like(name, clsValue.getValue());
                            break;
                        }
                        this.m_criteriaBuilder.ne(name, clsValue.getValue());
                        break;
                    }
                    case LESS_THAN: {
                        this.m_criteriaBuilder.lt(name, clsValue.getValue());
                        break;
                    }
                    case GREATER_THAN: {
                        this.m_criteriaBuilder.gt(name, clsValue.getValue());
                        break;
                    }
                    case LESS_OR_EQUALS: {
                        this.m_criteriaBuilder.le(name, clsValue.getValue());
                        break;
                    }
                    case GREATER_OR_EQUALS: {
                        this.m_criteriaBuilder.ge(name, clsValue.getValue());
                        break;
                    }
                }
            }
        } else {
            ArrayList<AllRestriction> subRestrictions = new ArrayList<AllRestriction>();
            for (SearchCondition condition : sc.getSearchConditions()) {
                CriteriaBuilderSearchVisitor<T> newVisitor = new CriteriaBuilderSearchVisitor<T>(new CriteriaBuilder(this.m_class), this.m_class);
                condition.accept(newVisitor);
                Collection restrictions = newVisitor.getQuery().toCriteria().getRestrictions();
                if (restrictions == null || restrictions.size() <= 0) continue;
                Object subRestriction = restrictions.size() > 1 ? Restrictions.all((Collection)restrictions) : (Restriction)restrictions.iterator().next();
                LOG.info(subRestriction.toString());
                subRestrictions.add((AllRestriction)subRestriction);
            }
            switch (sc.getConditionType()) {
                case OR: {
                    LOG.info("OR criteria");
                    this.m_criteriaBuilder.or(subRestrictions.toArray(new Restriction[0]));
                    break;
                }
                case AND: {
                    LOG.info("AND criteria");
                    this.m_criteriaBuilder.and(subRestrictions.toArray(new Restriction[0]));
                    break;
                }
            }
        }
    }

    public CriteriaBuilder getQuery() {
        return this.m_criteriaBuilder;
    }
}

