/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v1;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsCategoryCollection;
import org.opennms.netmgt.model.OnmsGroup;
import org.opennms.netmgt.model.OnmsGroupList;
import org.opennms.netmgt.model.OnmsUser;
import org.opennms.netmgt.model.OnmsUserList;
import org.opennms.web.rest.support.MultivaluedMapImpl;
import org.opennms.web.rest.v1.CategoryRestService;
import org.opennms.web.rest.v1.OnmsRestService;
import org.opennms.web.svclayer.api.GroupService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="groupRestService")
@Path(value="groups")
@Transactional
public class GroupRestService
extends OnmsRestService {
    private static final Logger LOG = LoggerFactory.getLogger(GroupRestService.class);
    @Autowired
    private GroupService m_groupService;
    @Autowired
    private CategoryRestService m_categoryRestService;

    @GET
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    public OnmsGroupList getGroups() {
        this.readLock();
        try {
            OnmsGroupList list = this.m_groupService.getOnmsGroupList();
            ArrayList groups = new ArrayList(list.getGroups());
            Collections.sort(groups, new Comparator<OnmsGroup>(){

                @Override
                public int compare(OnmsGroup a, OnmsGroup b) {
                    return a.getName().compareTo(b.getName());
                }
            });
            list.setGroups(groups);
            OnmsGroupList onmsGroupList = list;
            return onmsGroupList;
        }
        catch (Throwable t) {
            throw GroupRestService.getException(Response.Status.BAD_REQUEST, t);
        }
        finally {
            this.readUnlock();
        }
    }

    @GET
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    @Path(value="{groupName}")
    public OnmsGroup getGroup(@PathParam(value="groupName") String groupName) {
        this.readLock();
        try {
            OnmsGroup group = this.getOnmsGroup(groupName);
            if (group != null) {
                OnmsGroup onmsGroup = group;
                return onmsGroup;
            }
            try {
                throw GroupRestService.getException(Response.Status.NOT_FOUND, groupName + " does not exist", new String[0]);
            }
            catch (Throwable t) {
                if (t instanceof WebApplicationException) {
                    throw (WebApplicationException)t;
                }
                throw GroupRestService.getException(Response.Status.BAD_REQUEST, t);
            }
        }
        finally {
            this.readUnlock();
        }
    }

    @POST
    @Consumes(value={"application/xml"})
    public Response addGroup(@Context UriInfo uriInfo, OnmsGroup group) {
        this.writeLock();
        try {
            LOG.debug("addGroup: Adding group {}", (Object)group);
            this.m_groupService.saveGroup(group);
            Response response = Response.seeOther((URI)GroupRestService.getRedirectUri(uriInfo, group.getName())).build();
            return response;
        }
        catch (Throwable t) {
            throw GroupRestService.getException(Response.Status.BAD_REQUEST, t);
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="{groupName}")
    public Response updateGroup(@Context UriInfo uriInfo, @PathParam(value="groupName") String groupName, MultivaluedMapImpl params) {
        this.writeLock();
        try {
            OnmsGroup group = null;
            try {
                group = this.m_groupService.getOnmsGroup(groupName);
            }
            catch (Throwable t) {
                throw GroupRestService.getException(Response.Status.BAD_REQUEST, t);
            }
            if (group == null) {
                throw GroupRestService.getException(Response.Status.BAD_REQUEST, "updateGroup: Group does not exist: " + groupName, new String[0]);
            }
            LOG.debug("updateGroup: updating group {}", (Object)group);
            BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)group);
            for (String key : params.keySet()) {
                if (!wrapper.isWritableProperty(key)) continue;
                String stringValue = (String)params.getFirst(key);
                Object value = wrapper.convertIfNecessary((Object)stringValue, wrapper.getPropertyType(key));
                wrapper.setPropertyValue(key, value);
            }
            LOG.debug("updateGroup: group {} updated", (Object)group);
            try {
                this.m_groupService.saveGroup(group);
            }
            catch (Throwable t) {
                throw GroupRestService.getException(Response.Status.INTERNAL_SERVER_ERROR, t);
            }
            Response response = Response.seeOther((URI)GroupRestService.getRedirectUri(uriInfo, new Object[0])).build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    @DELETE
    @Path(value="{groupName}")
    public Response deleteGroup(@PathParam(value="groupName") String groupName) {
        this.writeLock();
        try {
            OnmsGroup group = this.getOnmsGroup(groupName);
            LOG.debug("deleteGroup: deleting group {}", (Object)group);
            this.m_groupService.deleteGroup(groupName);
            Response response = Response.ok().build();
            return response;
        }
        catch (Throwable t) {
            throw GroupRestService.getException(Response.Status.BAD_REQUEST, t);
        }
        finally {
            this.writeUnlock();
        }
    }

    @PUT
    @Path(value="{groupName}/users/{userName}")
    public Response addUser(@Context UriInfo uriInfo, @PathParam(value="groupName") String groupName, @PathParam(value="userName") String userName) {
        this.writeLock();
        try {
            this.getOnmsGroup(groupName);
            boolean success = this.m_groupService.addUser(groupName, userName);
            if (success) {
                Response response = Response.seeOther((URI)GroupRestService.getRedirectUri(uriInfo, new Object[0])).build();
                return response;
            }
        }
        catch (Throwable t) {
            throw GroupRestService.getException(Response.Status.INTERNAL_SERVER_ERROR, t);
        }
        finally {
            this.writeUnlock();
        }
        throw GroupRestService.getException(Response.Status.BAD_REQUEST, "User with name '{}' already added or does not exist.", userName);
    }

    @DELETE
    @Path(value="{groupName}/users/{userName}")
    public Response removeUser(@PathParam(value="groupName") String groupName, @PathParam(value="userName") String userName) {
        this.writeLock();
        try {
            OnmsGroup group = this.getOnmsGroup(groupName);
            if (group.getUsers().contains(userName)) {
                group.removeUser(userName);
                this.m_groupService.saveGroup(group);
                Response response = Response.ok().build();
                return response;
            }
            try {
                throw GroupRestService.getException(Response.Status.BAD_REQUEST, "User is not in the group '" + groupName + "': " + userName, new String[0]);
            }
            catch (Throwable t) {
                if (t instanceof WebApplicationException) {
                    throw (WebApplicationException)t;
                }
                throw GroupRestService.getException(Response.Status.INTERNAL_SERVER_ERROR, t);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @GET
    @Path(value="{groupName}/users/")
    public OnmsUserList listUsersOfGroup(@PathParam(value="groupName") String groupName) {
        OnmsGroup group = this.getOnmsGroup(groupName);
        if (group != null) {
            return this.m_groupService.getUsersOfGroup(groupName);
        }
        throw GroupRestService.getException(Response.Status.BAD_REQUEST, "Group with name '{}' does not exist.", groupName);
    }

    @GET
    @Path(value="{groupName}/users/{userName}")
    public OnmsUser getUser(@PathParam(value="groupName") String groupName, @PathParam(value="userName") String userName) {
        OnmsGroup group = this.getOnmsGroup(groupName);
        if (group != null) {
            OnmsUser user = this.m_groupService.getUserForGroup(groupName, userName);
            if (user != null) {
                return user;
            }
            throw GroupRestService.getException(Response.Status.NOT_FOUND, "User with name '{}' does not exist in group '{}'", userName, groupName);
        }
        throw GroupRestService.getException(Response.Status.NOT_FOUND, "User with name '{}' does not exist in group '{}'", userName, groupName);
    }

    @PUT
    @Path(value="{groupName}/categories/{categoryName}")
    public OnmsCategory addCategory(@PathParam(value="groupName") String groupName, @PathParam(value="categoryName") String categoryName) {
        this.writeLock();
        try {
            boolean success = this.m_groupService.addCategory(groupName, categoryName);
            if (success) {
                OnmsCategory onmsCategory = this.m_categoryRestService.getCategory(categoryName);
                return onmsCategory;
            }
            try {
                throw GroupRestService.getException(Response.Status.BAD_REQUEST, "Category with name '{}' already added or does not exist.", categoryName);
            }
            catch (Throwable t) {
                if (t instanceof WebApplicationException) {
                    throw (WebApplicationException)t;
                }
                throw GroupRestService.getException(Response.Status.INTERNAL_SERVER_ERROR, t);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @DELETE
    @Path(value="{groupName}/categories/{categoryName}")
    public Response removeCategory(@PathParam(value="groupName") String groupName, @PathParam(value="categoryName") String categoryName) {
        this.writeLock();
        try {
            boolean success = this.m_groupService.removeCategory(groupName, categoryName);
            if (success) {
                Response response = Response.ok().build();
                return response;
            }
            try {
                throw GroupRestService.getException(Response.Status.BAD_REQUEST, "Category with name '{}' does not exist. Remove failed.", categoryName);
            }
            catch (Throwable t) {
                if (t instanceof WebApplicationException) {
                    throw (WebApplicationException)t;
                }
                throw GroupRestService.getException(Response.Status.INTERNAL_SERVER_ERROR, t);
            }
        }
        finally {
            this.writeUnlock();
        }
    }

    @GET
    @Path(value="{groupName}/categories/{categoryName}")
    public OnmsCategory getCategoryForGroup(@PathParam(value="groupName") String groupName, @PathParam(value="categoryName") String categoryName) {
        this.getOnmsGroup(groupName);
        List categories = this.m_groupService.getAuthorizedCategories(groupName);
        for (OnmsCategory eachCategory : categories) {
            if (!eachCategory.getName().equals(categoryName)) continue;
            return eachCategory;
        }
        throw GroupRestService.getException(Response.Status.NOT_FOUND, "Category with name '{}' does not exist for group '{}'.", categoryName, groupName);
    }

    @GET
    @Path(value="{groupName}/categories")
    public OnmsCategoryCollection listCategories(@PathParam(value="groupName") String groupName) {
        this.writeLock();
        try {
            OnmsCategoryCollection onmsCategoryCollection = new OnmsCategoryCollection((Collection)this.m_groupService.getAuthorizedCategories(groupName));
            return onmsCategoryCollection;
        }
        catch (Throwable t) {
            if (t instanceof WebApplicationException) {
                throw (WebApplicationException)t;
            }
            throw GroupRestService.getException(Response.Status.INTERNAL_SERVER_ERROR, t);
        }
        finally {
            this.writeUnlock();
        }
    }

    protected OnmsGroup getOnmsGroup(String groupName) {
        OnmsGroup group = null;
        try {
            group = this.m_groupService.getOnmsGroup(groupName);
        }
        catch (Throwable t) {
            throw GroupRestService.getException(Response.Status.BAD_REQUEST, t);
        }
        if (group == null) {
            throw GroupRestService.getException(Response.Status.NOT_FOUND, "Group does not exist: " + groupName, new String[0]);
        }
        return group;
    }
}

