/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v1;

import java.io.IOException;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.codehaus.jackson.annotate.JsonProperty;
import org.codehaus.jackson.map.annotate.JsonRootName;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.ValidationException;
import org.opennms.core.config.api.JaxbListWrapper;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.MonitoredServiceDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.web.category.AvailabilityIpInterface;
import org.opennms.web.category.AvailabilityMonitoredService;
import org.opennms.web.category.AvailabilityNode;
import org.opennms.web.category.Category;
import org.opennms.web.category.CategoryList;
import org.opennms.web.category.CategoryModel;
import org.opennms.web.category.NodeList;
import org.opennms.web.rest.v1.OnmsRestService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="availabilityRestService")
@Path(value="availability")
@Transactional
@Produces(value={"application/xml", "application/json", "application/atom+xml"})
public class AvailabilityRestService
extends OnmsRestService {
    private static final Logger LOG = LoggerFactory.getLogger(AvailabilityRestService.class);
    private static CategoryList m_categoryList;
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private IpInterfaceDao m_ipInterfaceDao;
    @Autowired
    private MonitoredServiceDao m_monitoredServiceDao;

    private static void assertCategoryListExists() throws ServletException {
        if (m_categoryList == null) {
            m_categoryList = new CategoryList();
        }
    }

    @GET
    public AvailabilityData getNodeAvailability() {
        try {
            return new AvailabilityData(m_categoryList.getCategoryData());
        }
        catch (IOException | MarshalException | ValidationException e) {
            LOG.warn("Failed to get availability data: {}", (Object)e.getMessage(), (Object)e);
            throw AvailabilityRestService.getException(Response.Status.BAD_REQUEST, "Failed to get availability data.", new String[0]);
        }
    }

    @GET
    @Path(value="/categories/{category}")
    public Category getCategory(@PathParam(value="category") String categoryName) {
        try {
            String category = URLDecoder.decode(categoryName, "UTF-8");
            return CategoryModel.getInstance().getCategory(category);
        }
        catch (IOException | MarshalException | ValidationException e) {
            LOG.warn("Failed to get availability data for category {}: {}", new Object[]{categoryName, e.getMessage(), e});
            throw AvailabilityRestService.getException(Response.Status.BAD_REQUEST, "Failed to get availability data for category " + categoryName, new String[0]);
        }
    }

    @GET
    @Path(value="/categories/{category}/nodes")
    public NodeList getCategoryNodes(@PathParam(value="category") String categoryName) {
        try {
            String category = URLDecoder.decode(categoryName, "UTF-8");
            Category cat = CategoryModel.getInstance().getCategory(category);
            if (cat != null) {
                return cat.getNodes();
            }
            return null;
        }
        catch (IOException | MarshalException | ValidationException e) {
            LOG.warn("Failed to get availability data for category {}: {}", new Object[]{categoryName, e.getMessage(), e});
            throw AvailabilityRestService.getException(Response.Status.BAD_REQUEST, "Failed to get availability data for category " + categoryName, new String[0]);
        }
    }

    @GET
    @Path(value="/categories/{category}/nodes/{nodeId}")
    public AvailabilityNode getCategoryNode(@PathParam(value="category") String categoryName, @PathParam(value="nodeId") Long nodeId) {
        try {
            String category = URLDecoder.decode(categoryName, "UTF-8");
            Category cat = CategoryModel.getInstance().getCategory(category);
            if (cat != null) {
                return this.getAvailabilityNode(cat.getNode(nodeId).getId().intValue());
            }
            return null;
        }
        catch (Exception e) {
            LOG.warn("Failed to get availability data for category {}: {}", new Object[]{categoryName, e.getMessage(), e});
            throw AvailabilityRestService.getException(Response.Status.BAD_REQUEST, "Failed to get availability data for category " + categoryName, new String[0]);
        }
    }

    @GET
    @Path(value="/nodes/{nodeId}")
    public AvailabilityNode getNode(@PathParam(value="nodeId") Integer nodeId) {
        try {
            return this.getAvailabilityNode(nodeId);
        }
        catch (Exception e) {
            LOG.warn("Failed to get availability data for node {}: {}", new Object[]{nodeId, e.getMessage(), e});
            throw AvailabilityRestService.getException(Response.Status.BAD_REQUEST, "Failed to get availability data for node " + nodeId, new String[0]);
        }
    }

    AvailabilityNode getAvailabilityNode(int id) throws Exception {
        OnmsNode dbNode = (OnmsNode)this.m_nodeDao.get((Serializable)Integer.valueOf(id));
        this.initialize(dbNode);
        if (dbNode == null) {
            return null;
        }
        double nodeAvail = CategoryModel.getNodeAvailability((int)id);
        AvailabilityNode node = new AvailabilityNode(dbNode, nodeAvail);
        for (OnmsIpInterface iface : dbNode.getIpInterfaces()) {
            double ifaceAvail = CategoryModel.getInterfaceAvailability((int)id, (String)InetAddressUtils.str((InetAddress)iface.getIpAddress()));
            AvailabilityIpInterface ai = new AvailabilityIpInterface(iface, ifaceAvail);
            for (OnmsMonitoredService svc : iface.getMonitoredServices()) {
                double serviceAvail = CategoryModel.getServiceAvailability((int)id, (String)InetAddressUtils.str((InetAddress)iface.getIpAddress()), (int)svc.getServiceId());
                AvailabilityMonitoredService ams = new AvailabilityMonitoredService(svc, serviceAvail);
                ai.addService(ams);
            }
            node.addIpInterface(ai);
        }
        return node;
    }

    private void initialize(OnmsNode dbNode) {
        this.m_nodeDao.initialize((Object)dbNode);
        this.m_nodeDao.initialize((Object)dbNode.getIpInterfaces());
        for (OnmsIpInterface iface : dbNode.getIpInterfaces()) {
            this.m_nodeDao.initialize((Object)iface.getMonitoredServices());
        }
    }

    void setNodeDao(NodeDao dao) {
        this.m_nodeDao = dao;
    }

    void setIpInterfaceDao(IpInterfaceDao dao) {
        this.m_ipInterfaceDao = dao;
    }

    void setMonitoredServiceDao(MonitoredServiceDao dao) {
        this.m_monitoredServiceDao = dao;
    }

    static {
        try {
            AvailabilityRestService.assertCategoryListExists();
        }
        catch (ServletException e) {
            LOG.warn("Failed to create category list.", (Throwable)e);
        }
    }

    @XmlRootElement(name="categories")
    @JsonRootName(value="categories")
    private static final class CategoryRestList
    extends JaxbListWrapper<Category> {
        private static final long serialVersionUID = 1L;

        public CategoryRestList() {
        }

        public CategoryRestList(Collection<? extends Category> categories) {
            super(categories);
        }

        @XmlElement(name="category")
        @JsonProperty(value="category")
        public List<Category> getObjects() {
            return super.getObjects();
        }
    }

    @XmlRootElement(name="section")
    @XmlAccessorType(value=XmlAccessType.NONE)
    private static final class CategoryRestInfo {
        @XmlAttribute(name="name")
        private final String m_categoryName;
        @XmlElement(name="categories")
        private final CategoryRestList m_categories;

        public CategoryRestInfo() {
            this.m_categoryName = null;
            this.m_categories = new CategoryRestList();
        }

        public CategoryRestInfo(String categoryName, List<Category> categories) {
            this.m_categoryName = categoryName;
            this.m_categories = new CategoryRestList(categories);
        }
    }

    @XmlRootElement(name="availability")
    @XmlAccessorType(value=XmlAccessType.NONE)
    private static final class AvailabilityData {
        @XmlElement(name="section")
        private final List<CategoryRestInfo> m_categoryList = new ArrayList<CategoryRestInfo>();

        protected AvailabilityData() {
        }

        public AvailabilityData(Map<String, List<Category>> categoryData) {
            for (Map.Entry<String, List<Category>> entry : categoryData.entrySet()) {
                this.m_categoryList.add(new CategoryRestInfo(entry.getKey(), entry.getValue()));
            }
        }
    }
}

