/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v1;

import java.beans.PropertyEditor;
import java.net.URI;
import java.util.Date;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.events.api.EventProxy;
import org.opennms.netmgt.events.api.EventProxyException;
import org.opennms.netmgt.model.OnmsAssetRecord;
import org.opennms.netmgt.model.OnmsGeolocation;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.web.api.ISO8601DateEditor;
import org.opennms.web.rest.support.MultivaluedMapImpl;
import org.opennms.web.rest.v1.OnmsRestService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="assetRecordResource")
@Path(value="assetRecord")
@Transactional
public class AssetRecordResource
extends OnmsRestService {
    private static final Logger LOG = LoggerFactory.getLogger(AssetRecordResource.class);
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    @Qualifier(value="eventProxy")
    private EventProxy m_eventProxy;

    @GET
    @Produces(value={"application/xml", "application/json"})
    public OnmsAssetRecord getAssetRecord(@PathParam(value="nodeCriteria") String nodeCriteria) {
        OnmsNode node = this.m_nodeDao.get(nodeCriteria);
        if (node == null) {
            throw AssetRecordResource.getException(Response.Status.BAD_REQUEST, "getAssetRecord: Can't find node " + nodeCriteria, new String[0]);
        }
        return AssetRecordResource.getAssetRecord(node);
    }

    @PUT
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response updateAssetRecord(@Context UriInfo uriInfo, @PathParam(value="nodeCriteria") String nodeCriteria, MultivaluedMapImpl params) {
        OnmsNode node = this.m_nodeDao.get(nodeCriteria);
        if (node == null) {
            throw AssetRecordResource.getException(Response.Status.BAD_REQUEST, "updateAssetRecord: Can't find node " + nodeCriteria, new String[0]);
        }
        OnmsAssetRecord assetRecord = AssetRecordResource.getAssetRecord(node);
        if (assetRecord == null) {
            throw AssetRecordResource.getException(Response.Status.BAD_REQUEST, "updateAssetRecord: Node " + node + " could not update ", new String[0]);
        }
        if (assetRecord.getGeolocation() == null) {
            assetRecord.setGeolocation(new OnmsGeolocation());
        }
        LOG.debug("updateAssetRecord: updating category {}", (Object)assetRecord);
        BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)assetRecord);
        wrapper.registerCustomEditor(Date.class, (PropertyEditor)new ISO8601DateEditor());
        for (String key : params.keySet()) {
            if (!wrapper.isWritableProperty(key)) continue;
            String stringValue = (String)params.getFirst(key);
            Object value = wrapper.convertIfNecessary((Object)stringValue, wrapper.getPropertyType(key));
            wrapper.setPropertyValue(key, value);
        }
        LOG.debug("updateAssetRecord: assetRecord {} updated", (Object)assetRecord);
        this.m_nodeDao.saveOrUpdate((Object)node);
        try {
            this.sendEvent("uei.opennms.org/nodes/assetInfoChanged", node.getId());
        }
        catch (EventProxyException e) {
            throw AssetRecordResource.getException(Response.Status.BAD_REQUEST, e.getMessage(), new String[0]);
        }
        return Response.seeOther((URI)AssetRecordResource.getRedirectUri(uriInfo, new Object[0])).build();
    }

    private static OnmsAssetRecord getAssetRecord(OnmsNode node) {
        return node.getAssetRecord();
    }

    private void sendEvent(String uei, int nodeId) throws EventProxyException {
        EventBuilder bldr = new EventBuilder(uei, this.getClass().getName());
        bldr.setNodeid((long)nodeId);
        this.m_eventProxy.send(bldr.getEvent());
    }
}

