/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v1;

import java.io.Serializable;
import java.util.Collection;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.UriInfo;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.netmgt.dao.api.AcknowledgmentDao;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.dao.api.NotificationDao;
import org.opennms.netmgt.model.AckAction;
import org.opennms.netmgt.model.Acknowledgeable;
import org.opennms.netmgt.model.OnmsAcknowledgment;
import org.opennms.netmgt.model.OnmsAcknowledgmentCollection;
import org.opennms.netmgt.model.OnmsAlarm;
import org.opennms.netmgt.model.OnmsNotification;
import org.opennms.web.rest.v1.OnmsRestService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="acknowledgmentRestService")
@Path(value="acks")
public class AcknowledgmentRestService
extends OnmsRestService {
    @Autowired
    private AcknowledgmentDao m_ackDao;
    @Autowired
    private AlarmDao m_alarmDao;
    @Autowired
    private NotificationDao m_notificationDao;

    @GET
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    @Path(value="{id}")
    @Transactional
    public OnmsAcknowledgment getAcknowledgment(@PathParam(value="id") String alarmId) {
        return (OnmsAcknowledgment)this.m_ackDao.get((Serializable)new Integer(alarmId));
    }

    @GET
    @Produces(value={"text/plain"})
    @Path(value="count")
    @Transactional
    public String getCount() {
        return Integer.toString(this.m_ackDao.countAll());
    }

    @GET
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    @Transactional
    public OnmsAcknowledgmentCollection getAcks(@Context UriInfo uriInfo) {
        CriteriaBuilder builder = AcknowledgmentRestService.getQueryFilters((MultivaluedMap<String, String>)uriInfo.getQueryParameters());
        OnmsAcknowledgmentCollection coll = new OnmsAcknowledgmentCollection((Collection)this.m_ackDao.findMatching(builder.toCriteria()));
        builder.clearOrder();
        builder.limit(null);
        builder.offset(null);
        coll.setTotalCount(Integer.valueOf(this.m_ackDao.countMatching(builder.toCriteria())));
        return coll;
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Transactional
    public OnmsAcknowledgment acknowledge(MultivaluedMap<String, String> formParams) {
        String alarmId = (String)formParams.getFirst((Object)"alarmId");
        String notifId = (String)formParams.getFirst((Object)"notifId");
        String action = (String)formParams.getFirst((Object)"action");
        if (action == null) {
            action = "ack";
        }
        OnmsAcknowledgment ack = null;
        if (alarmId == null && notifId == null) {
            throw new IllegalArgumentException("You must supply either an alarmId or notifId!");
        }
        if (alarmId != null && notifId != null) {
            throw new IllegalArgumentException("You cannot supply both an alarmId and a notifId!");
        }
        if (alarmId != null) {
            OnmsAlarm alarm = (OnmsAlarm)this.m_alarmDao.get((Serializable)Integer.valueOf(alarmId));
            ack = new OnmsAcknowledgment((Acknowledgeable)alarm);
        } else if (notifId != null) {
            OnmsNotification notification = (OnmsNotification)this.m_notificationDao.get((Serializable)Integer.valueOf(notifId));
            ack = new OnmsAcknowledgment((Acknowledgeable)notification);
        }
        if ("ack".equals(action)) {
            ack.setAckAction(AckAction.ACKNOWLEDGE);
        } else if ("unack".equals(action)) {
            ack.setAckAction(AckAction.UNACKNOWLEDGE);
        } else if ("clear".equals(action)) {
            ack.setAckAction(AckAction.CLEAR);
        } else if ("esc".equals(action)) {
            ack.setAckAction(AckAction.ESCALATE);
        } else {
            throw new IllegalArgumentException("Must supply the 'action' parameter, set to either 'ack, 'unack', 'clear', or 'esc'");
        }
        this.m_ackDao.processAck(ack);
        return ack;
    }

    private static CriteriaBuilder getQueryFilters(MultivaluedMap<String, String> params) {
        CriteriaBuilder builder = new CriteriaBuilder(OnmsAcknowledgment.class);
        AcknowledgmentRestService.applyQueryFilters(params, builder);
        builder.orderBy("ackTime").desc();
        return builder;
    }
}

