/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v1.config;

import java.io.Serializable;
import java.util.List;
import javax.annotation.Resource;
import javax.ws.rs.GET;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.opennms.core.config.api.ConfigurationResource;
import org.opennms.core.config.api.ConfigurationResourceException;
import org.opennms.netmgt.config.monitoringLocations.LocationDef;
import org.opennms.netmgt.config.poller.PollerConfiguration;
import org.opennms.netmgt.dao.api.MonitoringLocationDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="pollerConfigurationResource")
public class PollerConfigurationResource {
    private static final Logger LOG = LoggerFactory.getLogger(PollerConfigurationResource.class);
    @Autowired
    private MonitoringLocationDao m_monitoringLocationDao;
    @Resource(name="poller-configuration.xml")
    private ConfigurationResource<PollerConfiguration> m_pollerConfigResource;

    @GET
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    public Response getPollerConfigurationForLocation(@PathParam(value="location") String location) throws ConfigurationResourceException {
        LocationDef def = (LocationDef)this.m_monitoringLocationDao.get((Serializable)((Object)location));
        if (def == null) {
            LOG.warn("Unable to find monitoring location {}", (Object)location);
            return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
        }
        List pollingPackageNames = def.getPollingPackageNames();
        if (pollingPackageNames != null && pollingPackageNames.size() > 0) {
            PollerConfiguration pollerConfig = ((PollerConfiguration)this.m_pollerConfigResource.get()).getPollerConfigurationForPackages(pollingPackageNames);
            return Response.ok((Object)pollerConfig).build();
        }
        LOG.warn("Monitoring location {} does not have a polling package defined.", (Object)location);
        return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
    }
}

