/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v1;

import com.googlecode.concurentlocks.ReadWriteUpdateLock;
import com.googlecode.concurentlocks.ReentrantReadWriteUpdateLock;
import java.beans.IntrospectionException;
import java.beans.PropertyEditor;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import javax.xml.datatype.XMLGregorianCalendar;
import org.opennms.core.criteria.Criteria;
import org.opennms.core.criteria.CriteriaBuilder;
import org.opennms.netmgt.model.InetAddressTypeEditor;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.model.OnmsSeverityEditor;
import org.opennms.netmgt.model.PrimaryType;
import org.opennms.netmgt.model.PrimaryTypeEditor;
import org.opennms.netmgt.provision.persist.StringXmlCalendarPropertyEditor;
import org.opennms.web.api.ISO8601DateEditor;
import org.opennms.web.api.RestUtils;
import org.opennms.web.rest.support.MultivaluedMapImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeanWrapperImpl;

public class OnmsRestService {
    private static final Logger LOG = LoggerFactory.getLogger(OnmsRestService.class);
    private final ReadWriteUpdateLock m_globalLock = new ReentrantReadWriteUpdateLock();
    private final Lock m_readLock = this.m_globalLock.updateLock();
    private final Lock m_writeLock = this.m_globalLock.writeLock();
    protected static final int DEFAULT_LIMIT = 10;

    protected final void readLock() {
        this.m_readLock.lock();
    }

    protected final void readUnlock() {
        this.m_readLock.unlock();
    }

    protected final void writeLock() {
        this.m_writeLock.lock();
    }

    protected final void writeUnlock() {
        this.m_writeLock.unlock();
    }

    protected static void applyQueryFilters(MultivaluedMap<String, String> p, CriteriaBuilder builder) {
        OnmsRestService.applyQueryFilters(p, builder, 10);
    }

    protected static void applyQueryFilters(MultivaluedMap<String, String> p, CriteriaBuilder builder, Integer defaultLimit) {
        String match;
        String query;
        MultivaluedMapImpl params = new MultivaluedMapImpl();
        params.putAll((Map)p);
        builder.distinct();
        builder.limit(defaultLimit);
        if (params.containsKey("limit")) {
            builder.limit(Integer.valueOf((String)params.getFirst("limit")));
            params.remove("limit");
        }
        if (params.containsKey("offset")) {
            builder.offset(Integer.valueOf((String)params.getFirst("offset")));
            params.remove("offset");
        }
        if (params.containsKey("orderBy")) {
            builder.clearOrder();
            builder.orderBy((String)params.getFirst("orderBy"));
            params.remove("orderBy");
            if (params.containsKey("order")) {
                if ("desc".equalsIgnoreCase((String)params.getFirst("order"))) {
                    builder.desc();
                } else {
                    builder.asc();
                }
                params.remove("order");
            }
        }
        if ((query = OnmsRestService.removeParameter(params, "query")) != null) {
            builder.sql((Object)query);
        }
        String matchType = (match = OnmsRestService.removeParameter(params, "match")) == null ? "all" : match;
        builder.match(matchType);
        Class criteriaClass = builder.toCriteria().getCriteriaClass();
        BeanWrapper wrapper = OnmsRestService.getBeanWrapperForClass(criteriaClass);
        String comparatorParam = OnmsRestService.removeParameter(params, "comparator", "eq").toLowerCase();
        Criteria currentCriteria = builder.toCriteria();
        for (String key : params.keySet()) {
            for (String paramValue : (List)params.get(key)) {
                Object value;
                if ("null".equalsIgnoreCase(paramValue)) {
                    builder.isNull(key);
                    continue;
                }
                if ("notnull".equalsIgnoreCase(paramValue)) {
                    builder.isNotNull(key);
                    continue;
                }
                Class<Object> type = Object.class;
                try {
                    type = currentCriteria.getType(key);
                }
                catch (IntrospectionException e) {
                    LOG.debug("Unable to determine type for key {}", (Object)key);
                }
                if (type == null) {
                    type = Object.class;
                }
                LOG.warn("comparator = {}, key = {}, propertyType = {}", new Object[]{comparatorParam, key, type});
                if (comparatorParam.equals("contains") || comparatorParam.equals("iplike") || comparatorParam.equals("ilike") || comparatorParam.equals("like")) {
                    value = paramValue;
                } else {
                    LOG.debug("convertIfNecessary({}, {})", (Object)key, (Object)paramValue);
                    try {
                        value = wrapper.convertIfNecessary((Object)paramValue, type);
                    }
                    catch (Throwable t) {
                        LOG.debug("failed to introspect (key = {}, value = {})", new Object[]{key, paramValue, t});
                        value = paramValue;
                    }
                }
                try {
                    Method m = builder.getClass().getMethod(comparatorParam, String.class, Object.class);
                    m.invoke((Object)builder, key, value);
                }
                catch (Throwable t) {
                    LOG.warn("Unable to find method for comparator: {}, key: {}, value: {}", new Object[]{comparatorParam, key, value, t});
                }
            }
        }
    }

    protected static BeanWrapper getBeanWrapperForClass(Class<?> criteriaClass) {
        BeanWrapperImpl wrapper = new BeanWrapperImpl(criteriaClass);
        wrapper.registerCustomEditor(XMLGregorianCalendar.class, (PropertyEditor)new StringXmlCalendarPropertyEditor());
        wrapper.registerCustomEditor(Date.class, (PropertyEditor)new ISO8601DateEditor());
        wrapper.registerCustomEditor(InetAddress.class, (PropertyEditor)new InetAddressTypeEditor());
        wrapper.registerCustomEditor(OnmsSeverity.class, (PropertyEditor)new OnmsSeverityEditor());
        wrapper.registerCustomEditor(PrimaryType.class, (PropertyEditor)new PrimaryTypeEditor());
        return wrapper;
    }

    protected static String removeParameter(MultivaluedMap<String, String> params, String key) {
        if (params.containsKey((Object)key)) {
            String value = (String)params.getFirst((Object)key);
            params.remove((Object)key);
            return value;
        }
        return null;
    }

    protected static String removeParameter(MultivaluedMap<String, String> params, String key, String defaultValue) {
        String value = OnmsRestService.removeParameter(params, key);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    protected static <T> WebApplicationException getException(Response.Status status, String msg, String ... params) throws WebApplicationException {
        if (params != null) {
            msg = MessageFormatter.arrayFormat((String)msg, (Object[])params).getMessage();
        }
        LOG.error(msg);
        return new WebApplicationException(Response.status((Response.Status)status).type("text/plain").entity((Object)msg).build());
    }

    protected static <T> WebApplicationException getException(Response.Status status, Throwable t) throws WebApplicationException {
        LOG.error(t.getMessage(), t);
        return new WebApplicationException(Response.status((Response.Status)status).type("text/plain").entity((Object)t.getMessage()).build());
    }

    protected static URI getRedirectUri(UriInfo uriInfo, Object ... pathComponents) {
        if (pathComponents != null && pathComponents.length == 0) {
            URI requestUri = uriInfo.getRequestUri();
            try {
                return new URI(requestUri.getScheme(), requestUri.getUserInfo(), requestUri.getHost(), requestUri.getPort(), requestUri.getPath().replaceAll("/$", ""), null, null);
            }
            catch (URISyntaxException e) {
                return requestUri;
            }
        }
        UriBuilder builder = uriInfo.getRequestUriBuilder();
        for (Object component : pathComponents) {
            if (component == null) continue;
            builder = builder.path(component.toString());
        }
        return builder.build(new Object[0]);
    }

    protected static void setProperties(MultivaluedMapImpl params, Object req) {
        RestUtils.setBeanProperties((Object)req, (MultivaluedMap)params);
    }

    protected static enum ComparisonOperation {
        EQ,
        NE,
        ILIKE,
        LIKE,
        IPLIKE,
        GT,
        LT,
        GE,
        LE,
        CONTAINS;

    }
}

