/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v1;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.json.JSONObject;
import org.opennms.netmgt.dao.api.AlarmDao;
import org.opennms.netmgt.dao.api.OutageDao;
import org.opennms.netmgt.model.HeatMapElement;
import org.opennms.web.rest.v1.OnmsRestService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="heatMapRestService")
@Path(value="heatmap")
public class HeatMapRestService
extends OnmsRestService {
    private static final String CATEGORY_FILTER_PROPERTY_KEY = "org.opennms.heatmap.categoryFilter";
    private static final String CATEGORY_FILTER_PROPERTY_DEFAULT = ".*";
    private static final String FOREIGNSOURCE_FILTER_PROPERTY_KEY = "org.opennms.heatmap.foreignSourceFilter";
    private static final String FOREIGNSOURCE_FILTER_PROPERTY_DEFAULT = ".*";
    private static final String SERVICE_FILTER_PROPERTY_KEY = "org.opennms.heatmap.serviceFilter";
    private static final String SERVICE_FILTER_PROPERTY_DEFAULT = ".*";
    private static final String ONLY_UNACKNOWLEDGED_PROPERTY_KEY = "org.opennms.heatmap.onlyUnacknowledged";
    private static final String ONLY_UNACKNOWLEDGED_PROPERTY_DEFAULT = "false";
    private static final Logger LOG = LoggerFactory.getLogger(HeatMapRestService.class);
    @Autowired
    private OutageDao m_outageDao;
    @Autowired
    private AlarmDao m_alarmDao;

    private Map<String, List<Map<String, Object>>> transformResults(List<HeatMapElement> heatMapElements, String filter) {
        ArrayList itemList = new ArrayList();
        HashMap<String, Integer> elementSizes = new HashMap<String, Integer>();
        int totalServices = 0;
        for (HeatMapElement heatMapElement : heatMapElements) {
            if (heatMapElement.getServicesTotal() <= 0 || filter != null && !heatMapElement.getName().matches(filter)) continue;
            elementSizes.put(heatMapElement.getName(), heatMapElement.getServicesTotal());
            HashMap<String, Object> item = new HashMap<String, Object>();
            item.put("id", heatMapElement.getName());
            item.put("elementId", heatMapElement.getId());
            item.put("color", Lists.newArrayList((Object[])new Double[]{heatMapElement.getColor()}));
            itemList.add(item);
            totalServices += heatMapElement.getServicesTotal();
        }
        for (Map map : itemList) {
            int nodesInEntity = (Integer)elementSizes.get(map.get("id"));
            double size = (double)nodesInEntity / (double)totalServices;
            map.put("size", Lists.newArrayList((Object[])new Double[]{size}));
        }
        HashMap<String, List<Map<String, Object>>> map = new HashMap<String, List<Map<String, Object>>>();
        map.put("children", itemList);
        return map;
    }

    @GET
    @Produces(value={"application/json"})
    @Transactional
    @Path(value="outages/categories")
    public Response outagesByCategories() throws IOException {
        List heatMapElements = this.m_outageDao.getHeatMapItemsForEntity("categories.categoryname", "categories.categoryid", null, null, new String[0]);
        JSONObject jo = new JSONObject(this.transformResults(heatMapElements, System.getProperty(CATEGORY_FILTER_PROPERTY_KEY, ".*")));
        return Response.ok((Object)jo.toString(), (String)"application/json").build();
    }

    @GET
    @Produces(value={"application/json"})
    @Transactional
    @Path(value="outages/foreignSources")
    public Response outagesByForeignsources() throws IOException {
        List heatMapElements = this.m_outageDao.getHeatMapItemsForEntity("foreignsource", "0", null, null, new String[]{"foreignsource"});
        JSONObject jo = new JSONObject(this.transformResults(heatMapElements, System.getProperty(FOREIGNSOURCE_FILTER_PROPERTY_KEY, ".*")));
        return Response.ok((Object)jo.toString(), (String)"application/json").build();
    }

    @GET
    @Produces(value={"application/json"})
    @Transactional
    @Path(value="outages/managedServices")
    public Response outagesByServices() throws IOException {
        List heatMapElements = this.m_outageDao.getHeatMapItemsForEntity("service.servicename", "service.serviceid", null, null, new String[0]);
        JSONObject jo = new JSONObject(this.transformResults(heatMapElements, System.getProperty(SERVICE_FILTER_PROPERTY_KEY, ".*")));
        return Response.ok((Object)jo.toString(), (String)"application/json").build();
    }

    @GET
    @Produces(value={"application/json"})
    @Transactional
    @Path(value="outages/nodesByCategory/{category}")
    public Response outagesOfNodesByCategory(@PathParam(value="category") String category) throws IOException {
        List heatMapElements = this.m_outageDao.getHeatMapItemsForEntity("node.nodelabel", "node.nodeid", "categories.categoryname", category, new String[0]);
        JSONObject jo = new JSONObject(this.transformResults(heatMapElements, null));
        return Response.ok((Object)jo.toString(), (String)"application/json").build();
    }

    @GET
    @Produces(value={"application/json"})
    @Transactional
    @Path(value="outages/nodesByForeignSource/{foreignSource}")
    public Response outagesOfNodesByForeignSource(@PathParam(value="foreignSource") String foreignSource) throws IOException {
        List heatMapElements = this.m_outageDao.getHeatMapItemsForEntity("node.nodelabel", "node.nodeid", "foreignsource", foreignSource, new String[0]);
        JSONObject jo = new JSONObject(this.transformResults(heatMapElements, null));
        return Response.ok((Object)jo.toString(), (String)"application/json").build();
    }

    @GET
    @Produces(value={"application/json"})
    @Transactional
    @Path(value="outages/nodesByManagedService/{managedService}")
    public Response outagesOfNodesByService(@PathParam(value="managedService") String managedService) throws IOException {
        List heatMapElements = this.m_outageDao.getHeatMapItemsForEntity("node.nodelabel", "node.nodeid", "service.servicename", managedService, new String[0]);
        JSONObject jo = new JSONObject(this.transformResults(heatMapElements, null));
        return Response.ok((Object)jo.toString(), (String)"application/json").build();
    }

    @GET
    @Produces(value={"application/json"})
    @Transactional
    @Path(value="alarms/categories")
    public Response alarmsByCategories() throws IOException {
        boolean processAcknowledged = !Boolean.parseBoolean(System.getProperty(ONLY_UNACKNOWLEDGED_PROPERTY_KEY, ONLY_UNACKNOWLEDGED_PROPERTY_DEFAULT));
        List heatMapElements = this.m_alarmDao.getHeatMapItemsForEntity("categories.categoryname", "categories.categoryid", processAcknowledged, null, null, new String[0]);
        JSONObject jo = new JSONObject(this.transformResults(heatMapElements, System.getProperty(CATEGORY_FILTER_PROPERTY_KEY, ".*")));
        return Response.ok((Object)jo.toString(), (String)"application/json").build();
    }

    @GET
    @Produces(value={"application/json"})
    @Transactional
    @Path(value="alarms/foreignSources")
    public Response alarmsByForeignsources() throws IOException {
        boolean processAcknowledged = !Boolean.parseBoolean(System.getProperty(ONLY_UNACKNOWLEDGED_PROPERTY_KEY, ONLY_UNACKNOWLEDGED_PROPERTY_DEFAULT));
        List heatMapElements = this.m_alarmDao.getHeatMapItemsForEntity("foreignsource", "0", processAcknowledged, null, null, new String[]{"foreignsource"});
        JSONObject jo = new JSONObject(this.transformResults(heatMapElements, System.getProperty(FOREIGNSOURCE_FILTER_PROPERTY_KEY, ".*")));
        return Response.ok((Object)jo.toString(), (String)"application/json").build();
    }

    @GET
    @Produces(value={"application/json"})
    @Transactional
    @Path(value="alarms/managedServices")
    public Response alarmsByServices() throws IOException {
        boolean processAcknowledged = !Boolean.parseBoolean(System.getProperty(ONLY_UNACKNOWLEDGED_PROPERTY_KEY, ONLY_UNACKNOWLEDGED_PROPERTY_DEFAULT));
        List heatMapElements = this.m_alarmDao.getHeatMapItemsForEntity("service.servicename", "service.serviceid", processAcknowledged, null, null, new String[0]);
        JSONObject jo = new JSONObject(this.transformResults(heatMapElements, System.getProperty(SERVICE_FILTER_PROPERTY_KEY, ".*")));
        return Response.ok((Object)jo.toString(), (String)"application/json").build();
    }

    @GET
    @Produces(value={"application/json"})
    @Transactional
    @Path(value="alarms/nodesByCategory/{category}")
    public Response alarmsOfNodesByCategory(@PathParam(value="category") String category) throws IOException {
        boolean processAcknowledged = !Boolean.parseBoolean(System.getProperty(ONLY_UNACKNOWLEDGED_PROPERTY_KEY, ONLY_UNACKNOWLEDGED_PROPERTY_DEFAULT));
        List heatMapElements = this.m_alarmDao.getHeatMapItemsForEntity("node.nodelabel", "node.nodeid", processAcknowledged, "categories.categoryname", category, new String[0]);
        JSONObject jo = new JSONObject(this.transformResults(heatMapElements, null));
        return Response.ok((Object)jo.toString(), (String)"application/json").build();
    }

    @GET
    @Produces(value={"application/json"})
    @Transactional
    @Path(value="alarms/nodesByForeignSource/{foreignSource}")
    public Response alarmsOfNodesByForeignSource(@PathParam(value="foreignSource") String foreignSource) throws IOException {
        boolean processAcknowledged = !Boolean.parseBoolean(System.getProperty(ONLY_UNACKNOWLEDGED_PROPERTY_KEY, ONLY_UNACKNOWLEDGED_PROPERTY_DEFAULT));
        List heatMapElements = this.m_alarmDao.getHeatMapItemsForEntity("node.nodelabel", "node.nodeid", processAcknowledged, "foreignsource", foreignSource, new String[0]);
        JSONObject jo = new JSONObject(this.transformResults(heatMapElements, null));
        return Response.ok((Object)jo.toString(), (String)"application/json").build();
    }

    @GET
    @Produces(value={"application/json"})
    @Transactional
    @Path(value="alarms/nodesByManagedService/{managedService}")
    public Response alarmsOfNodesByService(@PathParam(value="managedService") String managedService) throws IOException {
        boolean processAcknowledged = !Boolean.parseBoolean(System.getProperty(ONLY_UNACKNOWLEDGED_PROPERTY_KEY, ONLY_UNACKNOWLEDGED_PROPERTY_DEFAULT));
        List heatMapElements = this.m_alarmDao.getHeatMapItemsForEntity("node.nodelabel", "node.nodeid", processAcknowledged, "service.servicename", managedService, new String[0]);
        JSONObject jo = new JSONObject(this.transformResults(heatMapElements, null));
        return Response.ok((Object)jo.toString(), (String)"application/json").build();
    }
}

