/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v1;

import java.net.InetAddress;
import java.net.URI;
import java.util.Collection;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.opennms.netmgt.dao.api.IpInterfaceDao;
import org.opennms.netmgt.dao.api.MonitoredServiceDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.ServiceTypeDao;
import org.opennms.netmgt.dao.support.CreateIfNecessaryTemplate;
import org.opennms.netmgt.events.api.EventProxy;
import org.opennms.netmgt.events.api.EventProxyException;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsMonitoredServiceList;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsServiceType;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.model.events.EventUtils;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.web.rest.support.MultivaluedMapImpl;
import org.opennms.web.rest.v1.OnmsRestService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.annotation.Transactional;

@Component(value="onmsMonitoredServiceResource")
@Transactional
public class OnmsMonitoredServiceResource
extends OnmsRestService {
    private static final Logger LOG = LoggerFactory.getLogger(OnmsMonitoredServiceResource.class);
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private IpInterfaceDao m_ipInterfaceDao;
    @Autowired
    private MonitoredServiceDao m_serviceDao;
    @Autowired
    private PlatformTransactionManager m_transactionManager;
    @Autowired
    private ServiceTypeDao m_serviceTypeDao;
    @Autowired
    @Qualifier(value="eventProxy")
    private EventProxy m_eventProxy;

    @GET
    @Produces(value={"application/xml", "application/json"})
    public OnmsMonitoredServiceList getServices(@PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="ipAddress") String ipAddress) {
        OnmsNode node = this.m_nodeDao.get(nodeCriteria);
        return new OnmsMonitoredServiceList((Collection)node.getIpInterfaceByIpAddress(ipAddress).getMonitoredServices());
    }

    @GET
    @Produces(value={"application/xml", "application/json"})
    @Path(value="{service}")
    public OnmsMonitoredService getService(@PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="ipAddress") String ipAddress, @PathParam(value="service") String service) {
        OnmsNode node = this.m_nodeDao.get(nodeCriteria);
        return node.getIpInterfaceByIpAddress(ipAddress).getMonitoredServiceByServiceType(service);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"application/xml"})
    public Response addService(@Context UriInfo uriInfo, @PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="ipAddress") String ipAddress, final OnmsMonitoredService service) {
        this.writeLock();
        try {
            OnmsNode node = this.m_nodeDao.get(nodeCriteria);
            if (node == null) {
                throw OnmsMonitoredServiceResource.getException(Response.Status.BAD_REQUEST, "addService: can't find node " + nodeCriteria, new String[0]);
            }
            OnmsIpInterface intf = node.getIpInterfaceByIpAddress(ipAddress);
            if (intf == null) {
                throw OnmsMonitoredServiceResource.getException(Response.Status.BAD_REQUEST, "addService: can't find interface with ip address " + ipAddress + " for node " + nodeCriteria, new String[0]);
            }
            if (service == null) {
                throw OnmsMonitoredServiceResource.getException(Response.Status.BAD_REQUEST, "addService: service object cannot be null", new String[0]);
            }
            if (service.getServiceName() == null) {
                throw OnmsMonitoredServiceResource.getException(Response.Status.BAD_REQUEST, "addService: service must have a name", new String[0]);
            }
            OnmsServiceType serviceType = (OnmsServiceType)new CreateIfNecessaryTemplate<OnmsServiceType, ServiceTypeDao>(this.m_transactionManager, this.m_serviceTypeDao){

                protected OnmsServiceType query() {
                    return ((ServiceTypeDao)this.m_dao).findByName(service.getServiceName());
                }

                protected OnmsServiceType doInsert() {
                    LOG.info("addService: creating service type {}", (Object)service.getServiceName());
                    OnmsServiceType s = new OnmsServiceType(service.getServiceName());
                    ((ServiceTypeDao)this.m_dao).saveOrUpdate((Object)s);
                    return s;
                }
            }.execute();
            service.setServiceType(serviceType);
            service.setIpInterface(intf);
            LOG.debug("addService: adding service {}", (Object)service);
            this.m_serviceDao.save((Object)service);
            Event e = EventUtils.createNodeGainedServiceEvent((String)this.getClass().getName(), (int)node.getId(), (InetAddress)intf.getIpAddress(), (String)service.getServiceName(), (String)node.getLabel(), (OnmsNode.NodeLabelSource)node.getLabelSource(), (String)node.getSysName(), (String)node.getSysDescription());
            try {
                this.m_eventProxy.send(e);
            }
            catch (EventProxyException ex) {
                throw OnmsMonitoredServiceResource.getException(Response.Status.BAD_REQUEST, ex.getMessage(), new String[0]);
            }
            Response response = Response.seeOther((URI)OnmsMonitoredServiceResource.getRedirectUri(uriInfo, service.getServiceName())).build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="{service}")
    public Response updateService(@Context UriInfo uriInfo, @PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="ipAddress") String ipAddress, @PathParam(value="service") String serviceName, MultivaluedMapImpl params) {
        this.writeLock();
        try {
            OnmsNode node = this.m_nodeDao.get(nodeCriteria);
            if (node == null) {
                throw OnmsMonitoredServiceResource.getException(Response.Status.BAD_REQUEST, "addService: can't find node " + nodeCriteria, new String[0]);
            }
            OnmsIpInterface intf = node.getIpInterfaceByIpAddress(ipAddress);
            if (intf == null) {
                throw OnmsMonitoredServiceResource.getException(Response.Status.BAD_REQUEST, "addService: can't find ip interface on " + nodeCriteria + "@" + ipAddress, new String[0]);
            }
            OnmsMonitoredService service = intf.getMonitoredServiceByServiceType(serviceName);
            if (service == null) {
                throw OnmsMonitoredServiceResource.getException(Response.Status.BAD_REQUEST, "addService: can't find service " + serviceName + " on " + nodeCriteria + "@" + ipAddress, new String[0]);
            }
            LOG.debug("updateService: updating service {}", (Object)service);
            BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)service);
            for (String key : params.keySet()) {
                if (!wrapper.isWritableProperty(key)) continue;
                String stringValue = (String)params.getFirst(key);
                Object value = wrapper.convertIfNecessary((Object)stringValue, wrapper.getPropertyType(key));
                if (key.equals("status")) {
                    if ("S".equals(value) || "A".equals(service.getStatus()) && "F".equals(value)) {
                        LOG.debug("updateService: suspending polling for service {} on node with IP {}", (Object)service.getServiceName(), (Object)service.getIpAddress().getHostAddress());
                        value = "F";
                        this.sendEvent("uei.opennms.org/internal/poller/suspendPollingService", service);
                    }
                    if ("R".equals(value) || "F".equals(service.getStatus()) && "A".equals(value)) {
                        LOG.debug("updateService: resuming polling for service {} on node with IP {}", (Object)service.getServiceName(), (Object)service.getIpAddress().getHostAddress());
                        value = "A";
                        this.sendEvent("uei.opennms.org/internal/poller/resumePollingService", service);
                    }
                }
                wrapper.setPropertyValue(key, value);
            }
            LOG.debug("updateSservice: service {} updated", (Object)service);
            this.m_serviceDao.saveOrUpdate((Object)service);
            Response response = Response.seeOther((URI)OnmsMonitoredServiceResource.getRedirectUri(uriInfo, new Object[0])).build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="{service}")
    public Response deleteService(@PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="ipAddress") String ipAddress, @PathParam(value="service") String serviceName) {
        this.writeLock();
        try {
            OnmsNode node = this.m_nodeDao.get(nodeCriteria);
            if (node == null) {
                throw OnmsMonitoredServiceResource.getException(Response.Status.BAD_REQUEST, "deleteService: can't find node " + nodeCriteria, new String[0]);
            }
            OnmsIpInterface intf = node.getIpInterfaceByIpAddress(ipAddress);
            if (intf == null) {
                throw OnmsMonitoredServiceResource.getException(Response.Status.BAD_REQUEST, "deleteService: can't find interface with ip address " + ipAddress + " for node " + nodeCriteria, new String[0]);
            }
            OnmsMonitoredService service = intf.getMonitoredServiceByServiceType(serviceName);
            if (service == null) {
                throw OnmsMonitoredServiceResource.getException(Response.Status.CONFLICT, "deleteService: service " + serviceName + " not found on interface " + intf, new String[0]);
            }
            LOG.debug("deleteService: deleting service {} from node {}", (Object)serviceName, (Object)nodeCriteria);
            intf.getMonitoredServices().remove(service);
            this.m_ipInterfaceDao.saveOrUpdate((Object)intf);
            this.sendEvent("uei.opennms.org/nodes/serviceDeleted", service);
            Response response = Response.ok().build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    private void sendEvent(String eventUEI, OnmsMonitoredService dbObj) {
        EventBuilder bldr = new EventBuilder(eventUEI, this.getClass().getName());
        bldr.setNodeid((long)dbObj.getNodeId().intValue());
        bldr.setInterface(dbObj.getIpAddress());
        bldr.setService(dbObj.getServiceName());
        try {
            this.m_eventProxy.send(bldr.getEvent());
        }
        catch (EventProxyException ex) {
            throw OnmsMonitoredServiceResource.getException(Response.Status.BAD_REQUEST, ex.getMessage(), new String[0]);
        }
    }
}

