/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v1;

import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.opennms.netmgt.dao.api.HwEntityAttributeTypeDao;
import org.opennms.netmgt.dao.api.HwEntityDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.model.HwEntityAttributeType;
import org.opennms.netmgt.model.OnmsHwEntity;
import org.opennms.netmgt.model.OnmsHwEntityAttribute;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.web.rest.support.MultivaluedMapImpl;
import org.opennms.web.rest.v1.OnmsRestService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="hardwareInventoryResource")
@Path(value="hardwareInventory")
@Transactional
public class HardwareInventoryResource
extends OnmsRestService {
    private static final Logger LOG = LoggerFactory.getLogger(HardwareInventoryResource.class);
    @Autowired
    private NodeDao m_nodeDao;
    @Autowired
    private HwEntityDao m_hwEntityDao;
    @Autowired
    private HwEntityAttributeTypeDao m_hwEntityAttribTypeDao;

    @GET
    @Produces(value={"application/xml", "application/json"})
    public OnmsHwEntity getHardwareInventory(@PathParam(value="nodeCriteria") String nodeCriteria) {
        OnmsNode node = this.getOnmsNode(nodeCriteria);
        OnmsHwEntity entity = this.m_hwEntityDao.findRootByNodeId(node.getId());
        if (entity == null) {
            throw HardwareInventoryResource.getException(Response.Status.BAD_REQUEST, "getHardwareInventory: Can't find root hardware entity for node " + nodeCriteria, new String[0]);
        }
        return entity;
    }

    @GET
    @Path(value="{entPhysicalIndex}")
    @Produces(value={"application/xml", "application/json"})
    public OnmsHwEntity getHwEntityByIndex(@PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="entPhysicalIndex") Integer entPhysicalIndex) {
        OnmsNode node = this.getOnmsNode(nodeCriteria);
        return this.getHwEntity(node.getId(), entPhysicalIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Consumes(value={"application/xml", "application/json"})
    public Response setHardwareInventory(@Context UriInfo uriInfo, @PathParam(value="nodeCriteria") String nodeCriteria, OnmsHwEntity entity) {
        if (!entity.isRoot()) {
            throw HardwareInventoryResource.getException(Response.Status.BAD_REQUEST, "setHardwareInventory: The OnmsHwEntity is not a root entity " + entity, new String[0]);
        }
        this.writeLock();
        try {
            OnmsNode node = this.getOnmsNode(nodeCriteria);
            this.fixEntity(node, entity);
            OnmsHwEntity existing = this.m_hwEntityDao.findRootByNodeId(node.getId());
            if (existing != null && !entity.equals((Object)existing)) {
                LOG.debug("setHardwareInventory: removing existing hardware inventory from node {} ", (Object)nodeCriteria);
                this.m_hwEntityDao.delete((Object)existing);
                this.m_hwEntityDao.flush();
            }
            this.m_hwEntityDao.save((Object)entity);
            Response response = Response.seeOther((URI)HardwareInventoryResource.getRedirectUri(uriInfo, new Object[0])).build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @POST
    @Path(value="{parentEntPhysicalIndex}")
    @Consumes(value={"application/xml", "application/json"})
    public Response addOrReplaceChild(@Context UriInfo uriInfo, @PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="parentEntPhysicalIndex") Integer parentEntPhysicalIndex, OnmsHwEntity child) {
        this.writeLock();
        try {
            OnmsNode node = this.getOnmsNode(nodeCriteria);
            this.fixEntity(node, child);
            OnmsHwEntity parent = this.getHwEntity(node.getId(), parentEntPhysicalIndex);
            if (parent == null) {
                throw HardwareInventoryResource.getException(Response.Status.BAD_REQUEST, "Can't find entity on node " + nodeCriteria + " with index " + parentEntPhysicalIndex, new String[0]);
            }
            OnmsHwEntity currentChild = parent.getChildByIndex(child.getEntPhysicalIndex());
            if (currentChild != null) {
                LOG.debug("addOrReplaceChild: removing entity {}", (Object)currentChild);
                parent.removeChild(currentChild);
            }
            parent.addChildEntity(child);
            LOG.debug("addOrReplaceChild: updating entity {}", (Object)child);
            this.m_hwEntityDao.save((Object)parent);
            Response response = Response.seeOther((URI)HardwareInventoryResource.getRedirectUri(uriInfo, new Object[0])).build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PUT
    @Path(value="{entPhysicalIndex}")
    @Consumes(value={"application/x-www-form-urlencoded"})
    public Response updateHwEntity(@Context UriInfo uriInfo, @PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="entPhysicalIndex") Integer entPhysicalIndex, MultivaluedMapImpl params) {
        this.writeLock();
        try {
            OnmsNode node = this.getOnmsNode(nodeCriteria);
            OnmsHwEntity entity = this.getHwEntity(node.getId(), entPhysicalIndex);
            BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)entity);
            for (String key : params.keySet()) {
                if (key.startsWith("entPhysical")) {
                    if (!wrapper.isWritableProperty(key)) continue;
                    String stringValue = (String)params.getFirst(key);
                    Object value = wrapper.convertIfNecessary((Object)stringValue, wrapper.getPropertyType(key));
                    wrapper.setPropertyValue(key, value);
                    continue;
                }
                OnmsHwEntityAttribute attr = entity.getAttribute(key);
                if (attr == null) continue;
                attr.setValue((String)params.getFirst(key));
            }
            this.m_hwEntityDao.save((Object)entity);
            Response response = Response.seeOther((URI)HardwareInventoryResource.getRedirectUri(uriInfo, new Object[0])).build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DELETE
    @Path(value="{entPhysicalIndex}")
    public Response deleteHwEntity(@Context UriInfo uriInfo, @PathParam(value="nodeCriteria") String nodeCriteria, @PathParam(value="entPhysicalIndex") Integer entPhysicalIndex) {
        this.writeLock();
        try {
            OnmsNode node = this.getOnmsNode(nodeCriteria);
            OnmsHwEntity entity = this.getHwEntity(node.getId(), entPhysicalIndex);
            this.m_hwEntityDao.delete((Object)entity);
            Response response = Response.seeOther((URI)HardwareInventoryResource.getRedirectUri(uriInfo, new Object[0])).build();
            return response;
        }
        finally {
            this.writeUnlock();
        }
    }

    private OnmsNode getOnmsNode(String nodeCriteria) {
        OnmsNode node = this.m_nodeDao.get(nodeCriteria);
        if (node == null) {
            throw HardwareInventoryResource.getException(Response.Status.BAD_REQUEST, "Can't find node " + nodeCriteria, new String[0]);
        }
        return node;
    }

    private OnmsHwEntity getHwEntity(Integer nodeId, Integer entPhysicalIndex) {
        OnmsHwEntity entity = this.m_hwEntityDao.findEntityByIndex(nodeId, entPhysicalIndex);
        if (entity == null) {
            throw HardwareInventoryResource.getException(Response.Status.BAD_REQUEST, "Can't find entity on node " + nodeId + " with index " + entPhysicalIndex, new String[0]);
        }
        return entity;
    }

    private void fixEntity(OnmsNode node, OnmsHwEntity entity) {
        entity.setNode(node);
        entity.fixRelationships();
        HashMap<String, HwEntityAttributeType> typesMap = new HashMap<String, HwEntityAttributeType>();
        this.updateTypes(typesMap, entity);
        this.m_hwEntityAttribTypeDao.flush();
    }

    private void updateTypes(Map<String, HwEntityAttributeType> typesMap, OnmsHwEntity entity) {
        for (OnmsHwEntityAttribute a : entity.getHwEntityAttributes()) {
            String typeName = a.getTypeName();
            if (!typesMap.containsKey(typeName)) {
                HwEntityAttributeType t = this.m_hwEntityAttribTypeDao.findTypeByName(typeName);
                if (t == null) {
                    t = a.getType();
                    this.m_hwEntityAttribTypeDao.save((Object)t);
                }
                typesMap.put(t.getName(), t);
            }
            a.setType(typesMap.get(typeName));
        }
        for (OnmsHwEntity child : entity.getChildren()) {
            this.updateTypes(typesMap, child);
        }
    }
}

