/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.support;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import javax.ws.rs.ext.Providers;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.core.xml.JaxbUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;

@Provider
@Consumes(value={"application/xml", "application/*+xml", "text/xml"})
public class ValidatingMessageBodyReader<T>
implements MessageBodyReader<T> {
    private static final Logger LOG = LoggerFactory.getLogger(ValidatingMessageBodyReader.class);
    @Context
    protected Providers providers;

    public boolean isReadable(Class<?> clazz, Type type, Annotation[] annotations, MediaType mediaType) {
        return clazz.getAnnotation(XmlRootElement.class) != null;
    }

    public T readFrom(Class<T> clazz, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> parameters, InputStream stream) throws IOException, WebApplicationException {
        LOG.debug("readFrom: {}/{}/{}", new Object[]{clazz.getSimpleName(), type, mediaType});
        JAXBContext jaxbContext = null;
        ContextResolver resolver = this.providers.getContextResolver(JAXBContext.class, mediaType);
        try {
            if (resolver != null) {
                jaxbContext = (JAXBContext)resolver.getContext(clazz);
            }
            if (jaxbContext == null) {
                jaxbContext = JAXBContext.newInstance((Class[])new Class[]{clazz});
            }
            return (T)JaxbUtils.unmarshal(clazz, (InputSource)new InputSource(stream), (JAXBContext)jaxbContext);
        }
        catch (JAXBException e) {
            LOG.warn("An error occurred while unmarshaling a {} object", (Object)clazz.getSimpleName(), (Object)e);
            throw new WebApplicationException(Response.Status.INTERNAL_SERVER_ERROR);
        }
    }
}

