/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v1.config;

import javax.annotation.Resource;
import javax.ws.rs.GET;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.opennms.core.config.api.ConfigurationResourceException;
import org.opennms.core.xml.AbstractJaxbConfigDao;
import org.opennms.netmgt.config.api.DataCollectionConfigDao;
import org.opennms.netmgt.config.datacollection.DatacollectionConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;

@Component
public class DataCollectionConfigResource
implements InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(DataCollectionConfigResource.class);
    @Resource(name="dataCollectionConfigDao")
    private DataCollectionConfigDao m_dataCollectionConfigDao;

    public void setDataCollectionConfigDao(DataCollectionConfigDao dao) {
        this.m_dataCollectionConfigDao = dao;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.m_dataCollectionConfigDao, (String)"DataCollectionConfigDao must be set!");
        Assert.isTrue((boolean)(this.m_dataCollectionConfigDao instanceof AbstractJaxbConfigDao));
    }

    @GET
    @Produces(value={"application/xml", "application/json", "application/atom+xml"})
    public Response getDataCollectionConfiguration() throws ConfigurationResourceException {
        LOG.debug("getDatacollectionConfigurationForLocation()");
        AbstractJaxbConfigDao dao = (AbstractJaxbConfigDao)this.m_dataCollectionConfigDao;
        DatacollectionConfig dcc = (DatacollectionConfig)dao.getContainer().getObject();
        if (dcc == null) {
            return Response.status((int)404).build();
        }
        return Response.ok((Object)dcc.toDataCollectionConfig()).build();
    }
}

