/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.rest.v1;

import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.RrdGraphAttribute;
import org.opennms.web.rest.v1.ResourceDTOCollection;

@XmlRootElement(name="resource")
@XmlAccessorType(value=XmlAccessType.NONE)
public class ResourceDTO {
    @XmlAttribute(name="id")
    private final String m_id;
    @XmlAttribute(name="label")
    private final String m_label;
    @XmlAttribute(name="name")
    private final String m_name;
    @XmlAttribute(name="link")
    private final String m_link;
    @XmlAttribute(name="typeLabel")
    private final String m_typeLabel;
    @XmlAttribute(name="parentId")
    private final String m_parentId;
    @XmlElement(name="children")
    private final ResourceDTOCollection m_children;
    @XmlElementWrapper(name="stringPropertyAttributes")
    private final Map<String, String> m_stringPropertyAttributes;
    @XmlElementWrapper(name="externalValueAttributes")
    private final Map<String, String> m_externalValueAttributes;
    @XmlElementWrapper(name="rrdGraphAttributes")
    private final Map<String, RrdGraphAttribute> m_rrdGraphAttributes;
    @XmlElementWrapper(name="graphNames")
    @XmlElement(name="graphName")
    private List<String> m_graphNames;

    protected ResourceDTO() {
        throw new UnsupportedOperationException("No-arg constructor for JAXB.");
    }

    public ResourceDTO(OnmsResource resource) {
        this(resource, -1);
    }

    public ResourceDTO(OnmsResource resource, int depth) {
        this.m_id = resource.getId();
        this.m_label = resource.getLabel();
        this.m_name = resource.getName();
        this.m_link = resource.getLink();
        this.m_typeLabel = resource.getResourceType().getLabel();
        this.m_parentId = resource.getParent() == null ? null : resource.getParent().getId();
        this.m_stringPropertyAttributes = resource.getStringPropertyAttributes();
        this.m_externalValueAttributes = resource.getExternalValueAttributes();
        this.m_rrdGraphAttributes = resource.getRrdGraphAttributes();
        if (depth == 0) {
            this.m_children = null;
        } else {
            LinkedList children = Lists.newLinkedList();
            for (OnmsResource child : resource.getChildResources()) {
                children.add(new ResourceDTO(child, depth - 1));
            }
            this.m_children = new ResourceDTOCollection(children);
        }
    }

    public String getId() {
        return this.m_id;
    }

    public String getLabel() {
        return this.m_label;
    }

    public String getName() {
        return this.m_name;
    }

    public String getLink() {
        return this.m_link;
    }

    public String getTypeLabel() {
        return this.m_typeLabel;
    }

    public String getParentId() {
        return this.m_parentId;
    }

    public ResourceDTOCollection getChildren() {
        return this.m_children;
    }

    public Map<String, String> getStringPropertyAttributes() {
        return this.m_stringPropertyAttributes;
    }

    public Map<String, String> getExternalValueAttributes() {
        return this.m_externalValueAttributes;
    }

    public Map<String, RrdGraphAttribute> getRrdGraphAttributes() {
        return this.m_rrdGraphAttributes;
    }

    void setGraphNames(List<String> graphNames) {
        this.m_graphNames = graphNames;
    }
}

