/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.utils;

import java.util.Collections;
import java.util.List;

public class Page {
    private Integer offset;
    private Integer limit;

    public Page(Integer offset, Integer limit) {
        if (offset != null && offset < 0) {
            throw new IllegalArgumentException("Offset must be > 0");
        }
        if (limit != null && limit <= 0) {
            throw new IllegalArgumentException("limit must be > 0");
        }
        this.offset = offset;
        this.limit = limit;
    }

    public <T> List<T> apply(List<T> list) {
        if (this.offset != null && this.offset > list.size()) {
            return Collections.emptyList();
        }
        if (this.offset != null && this.limit != null) {
            return Page.sublist(list, this.offset, this.limit);
        }
        if (this.offset != null) {
            return list.subList(this.offset, list.size());
        }
        if (this.limit != null) {
            Page.sublist(list, 0, this.limit);
        }
        return list;
    }

    private static <T> List<T> sublist(List<T> list, int start, int limit) {
        if (start + limit > list.size()) {
            limit = list.size() - start;
        }
        return list.subList(start, start + limit);
    }
}

