/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer.support;

import java.io.InputStream;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.opennms.netmgt.dao.api.GraphDao;
import org.opennms.netmgt.dao.api.ResourceDao;
import org.opennms.netmgt.dao.api.RrdDao;
import org.opennms.netmgt.model.AdhocGraphType;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.PrefabGraph;
import org.opennms.netmgt.model.PrefabGraphType;
import org.opennms.netmgt.model.ResourceId;
import org.opennms.netmgt.model.RrdGraphAttribute;
import org.opennms.netmgt.rrd.RrdFileConstants;
import org.opennms.web.svclayer.RrdGraphService;
import org.opennms.web.svclayer.model.Graph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.ObjectRetrievalFailureException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public class DefaultRrdGraphService
implements RrdGraphService,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultRrdGraphService.class);
    private static final String s_rrdError = "/images/rrd/error.png";
    private GraphDao m_graphDao;
    private ResourceDao m_resourceDao;
    private RrdDao m_rrdDao;

    @Override
    public InputStream getAdhocGraph(ResourceId resourceId, String title, String[] dataSources, String[] aggregateFunctions, String[] colors, String[] dataSourceTitles, String[] styles, long start, long end) {
        Assert.notNull((Object)resourceId, (String)"resourceId argument cannot be null");
        Assert.notNull((Object)title, (String)"title argument cannot be null");
        Assert.notNull((Object)dataSources, (String)"dataSources argument cannot be null");
        Assert.notNull((Object)aggregateFunctions, (String)"aggregateFunctions argument cannot be null");
        Assert.notNull((Object)colors, (String)"colors argument cannot be null");
        Assert.notNull((Object)dataSourceTitles, (String)"dataSourceTitles argument cannot be null");
        Assert.notNull((Object)styles, (String)"styles argument cannot be null");
        Assert.isTrue((end > start ? 1 : 0) != 0, (String)"end time must be after start time");
        AdhocGraphType t = this.m_graphDao.findAdhocGraphTypeByName("performance");
        OnmsResource r = this.m_resourceDao.getResourceById(resourceId);
        Assert.notNull((Object)r, (String)("resource \"" + resourceId + "\" could not be located"));
        String command = this.createAdHocCommand(t, r, start, end, title, dataSources, aggregateFunctions, colors, dataSourceTitles, styles);
        return this.getInputStreamForCommand(command);
    }

    private InputStream getInputStreamForCommand(String command) {
        boolean debug = true;
        InputStream tempIn = null;
        try {
            LOG.debug("Executing RRD command: {}", (Object)command);
            tempIn = this.m_rrdDao.createGraph(command);
        }
        catch (DataAccessException e) {
            LOG.warn("Exception while creating graph.", (Throwable)e);
            if (debug) {
                throw e;
            }
            return this.returnErrorImage(s_rrdError);
        }
        return tempIn;
    }

    public InputStream returnErrorImage(String file) {
        InputStream is = this.getClass().getResourceAsStream(file);
        if (is == null) {
            throw new ObjectRetrievalFailureException(InputStream.class, (Object)file, "Could not find error image for '" + file + "' or could open", null);
        }
        return is;
    }

    @Override
    public InputStream getPrefabGraph(ResourceId resourceId, String report, long start, long end, Integer width, Integer height) {
        Assert.notNull((Object)resourceId, (String)"resourceId argument cannot be null");
        Assert.notNull((Object)report, (String)"report argument cannot be null");
        Assert.isTrue((end > start ? 1 : 0) != 0, (String)("end time " + end + " must be after start time" + start));
        PrefabGraphType t = this.m_graphDao.findPrefabGraphTypeByName("performance");
        if (t == null) {
            throw new IllegalArgumentException("graph type \"performance\" is not valid");
        }
        OnmsResource r = this.m_resourceDao.getResourceById(resourceId);
        Assert.notNull((Object)r, (String)"resource could not be located");
        PrefabGraph prefabGraph = this.m_graphDao.getPrefabGraph(report);
        Graph graph = new Graph(prefabGraph, r, new Date(start), new Date(end));
        String command = this.createPrefabCommand(graph, t.getCommandPrefix(), report, width, height);
        return this.getInputStreamForCommand(command);
    }

    protected String createAdHocCommand(AdhocGraphType adhocType, OnmsResource resource, long start, long end, String graphtitle, String[] dsNames, String[] dsAggregFxns, String[] colors, String[] dsTitles, String[] dsStyles) {
        String commandPrefix = adhocType.getCommandPrefix();
        String title = adhocType.getTitleTemplate();
        String ds = adhocType.getDataSourceTemplate();
        String graphline = adhocType.getGraphLineTemplate();
        String starttime = Long.toString(start / 1000L);
        String endtime = Long.toString(end / 1000L);
        StringBuilder buf = new StringBuilder();
        buf.append(commandPrefix);
        buf.append(" ");
        buf.append(title);
        String[] rrdFiles = DefaultRrdGraphService.getRrdNames(resource, dsNames);
        ArrayList<String> defs = new ArrayList<String>(dsNames.length);
        ArrayList<String> lines = new ArrayList<String>(dsNames.length);
        for (int i = 0; i < dsNames.length; ++i) {
            String dsAbbrev = "ds" + Integer.toString(i);
            String dsName = dsNames[i];
            String rrd = rrdFiles[i];
            String dsAggregFxn = dsAggregFxns[i];
            String color = colors[i];
            String dsTitle = dsTitles[i];
            String dsStyle = dsStyles[i];
            defs.add(MessageFormat.format(ds, rrd, starttime, endtime, graphtitle, dsAbbrev, dsName, dsAggregFxn, dsStyle, color, dsTitle));
            lines.add(MessageFormat.format(graphline, rrd, starttime, endtime, graphtitle, dsAbbrev, dsName, dsAggregFxn, dsStyle, color, dsTitle));
        }
        for (String def : defs) {
            buf.append(" ");
            buf.append(def);
        }
        for (String line : lines) {
            buf.append(" ");
            buf.append(line);
        }
        LOG.debug("formatting: {}, bogus-rrd, {}, {}, {}", new Object[]{buf, starttime, endtime, graphtitle});
        return MessageFormat.format(buf.toString(), "bogus-rrd", starttime, endtime, graphtitle);
    }

    private static String[] getRrdNames(OnmsResource resource, String[] dsNames) {
        String[] rrds = new String[dsNames.length];
        Map attributes = resource.getRrdGraphAttributes();
        for (int i = 0; i < dsNames.length; ++i) {
            RrdGraphAttribute attribute = (RrdGraphAttribute)attributes.get(dsNames[i]);
            if (attribute == null) {
                throw new IllegalArgumentException("RRD attribute '" + dsNames[i] + "' is not available on resource '" + resource.getId() + "'.  Available RRD attributes: " + StringUtils.collectionToDelimitedString(attributes.keySet(), (String)", "));
            }
            rrds[i] = RrdFileConstants.escapeForGraphing((String)attribute.getRrdRelativePath());
        }
        return rrds;
    }

    private static Map<String, String> getTranslationsForAttributes(Map<String, String> attributes, String[] requiredAttributes, String type) {
        if (requiredAttributes == null) {
            return new HashMap<String, String>(0);
        }
        HashMap<String, String> translations = new HashMap<String, String>(requiredAttributes.length);
        for (String requiredAttribute : requiredAttributes) {
            String attributeValue = attributes.get(requiredAttribute);
            if (attributeValue == null) {
                throw new IllegalArgumentException(type + " '" + requiredAttribute + "' is not available in the list of provided attributes.  Available " + type + "s: " + StringUtils.collectionToDelimitedString(attributes.keySet(), (String)", "));
            }
            String replacedValue = attributeValue.replace("\\", "\\\\");
            translations.put("{" + requiredAttribute + "}", replacedValue);
        }
        return translations;
    }

    protected String createPrefabCommand(Graph graph, String commandPrefix, String reportName, Integer width, Integer height) {
        Matcher matcher;
        Pattern re;
        PrefabGraph prefabGraph = graph.getPrefabGraph();
        String[] rrds = DefaultRrdGraphService.getRrdNames(graph.getResource(), graph.getPrefabGraph().getColumns());
        StringBuilder buf = new StringBuilder();
        buf.append(commandPrefix);
        buf.append(" ");
        buf.append(prefabGraph.getCommand());
        String command = buf.toString();
        long startTime = graph.getStart().getTime();
        long endTime = graph.getEnd().getTime();
        long diffTime = endTime - startTime;
        String startTimeString = Long.toString(startTime / 1000L);
        String endTimeString = Long.toString(endTime / 1000L);
        String diffTimeString = Long.toString(diffTime / 1000L);
        HashMap<String, String> translationMap = new HashMap<String, String>();
        for (int i = 0; i < rrds.length; ++i) {
            String key = "{rrd" + (i + 1) + "}";
            translationMap.put(key, rrds[i]);
        }
        translationMap.put("{startTime}", startTimeString);
        translationMap.put("{endTime}", endTimeString);
        translationMap.put("{diffTime}", diffTimeString);
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
        translationMap.put("{startTimeDate}", fmt.format(new Date(startTime)).replace(":", "\\:"));
        translationMap.put("{endTimeDate}", fmt.format(new Date(endTime)).replace(":", "\\:"));
        Matcher stm = Pattern.compile("\\{startTime:(.+?)\\}").matcher(command);
        boolean matchFail = false;
        while (stm.find() && !matchFail) {
            String sdfPattern = stm.group(0);
            if (sdfPattern == null) {
                matchFail = true;
                continue;
            }
            try {
                fmt = new SimpleDateFormat(sdfPattern);
                translationMap.put("{startTime:" + sdfPattern + "}", fmt.format(new Date(startTime)).replace(":", "\\:"));
            }
            catch (IllegalArgumentException e) {
                LOG.error("Cannot parse date format '{}' for graph {}.", (Object)sdfPattern, (Object)reportName);
            }
        }
        Matcher etm = Pattern.compile("\\{endTime:(.+?)\\}").matcher(command);
        matchFail = false;
        while (etm.find() && !matchFail) {
            String sdfPattern = etm.group(0);
            if (sdfPattern == null) {
                matchFail = true;
                continue;
            }
            try {
                fmt = new SimpleDateFormat(sdfPattern);
                translationMap.put("{endTime:" + sdfPattern + "}", fmt.format(new Date(endTime)).replace(":", "\\:"));
            }
            catch (IllegalArgumentException e) {
                LOG.error("Cannot parse date format '{}' for graph {}.", (Object)sdfPattern, (Object)reportName);
            }
        }
        try {
            translationMap.putAll(DefaultRrdGraphService.getTranslationsForAttributes(graph.getResource().getExternalValueAttributes(), prefabGraph.getExternalValues(), "external value attribute"));
            translationMap.putAll(DefaultRrdGraphService.getTranslationsForAttributes(graph.getResource().getStringPropertyAttributes(), prefabGraph.getPropertiesValues(), "string property attribute"));
        }
        catch (RuntimeException e) {
            LOG.error("Invalid attributes were found on resource '{}'", (Object)graph.getResource().getId());
            throw e;
        }
        try {
            for (Map.Entry translation : translationMap.entrySet()) {
                Matcher matcher2 = Pattern.compile((String)translation.getKey(), 16).matcher(command);
                command = matcher2.replaceAll(Matcher.quoteReplacement((String)translation.getValue()));
            }
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("Invalid regular expression syntax, check rrd-properties file", e);
        }
        if (width != null) {
            re = Pattern.compile("(--width|-w)(\\w+|=)(\\d+)");
            matcher = re.matcher(command);
            if (matcher.matches()) {
                matcher.replaceFirst("--width " + width);
            } else {
                command = command + " --width " + width;
            }
        }
        if (height != null) {
            re = Pattern.compile("(--height|-h)(\\w+|=)(\\d+)");
            matcher = re.matcher(command);
            if (matcher.matches()) {
                matcher.replaceFirst("--height " + height);
            } else {
                command = command + " --height " + height;
            }
        }
        return command;
    }

    public void afterPropertiesSet() {
        Assert.state((this.m_resourceDao != null ? 1 : 0) != 0, (String)"resourceDao property has not been set");
        Assert.state((this.m_graphDao != null ? 1 : 0) != 0, (String)"graphDao property has not been set");
        Assert.state((this.m_rrdDao != null ? 1 : 0) != 0, (String)"rrdDao property has not been set");
    }

    public ResourceDao getResourceDao() {
        return this.m_resourceDao;
    }

    public void setResourceDao(ResourceDao resourceDao) {
        this.m_resourceDao = resourceDao;
    }

    public GraphDao getGraphDao() {
        return this.m_graphDao;
    }

    public void setGraphDao(GraphDao graphDao) {
        this.m_graphDao = graphDao;
    }

    public RrdDao getRrdDao() {
        return this.m_rrdDao;
    }

    public void setRrdDao(RrdDao rrdDao) {
        this.m_rrdDao = rrdDao;
    }
}

