/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer.support;

import java.io.Serializable;
import java.net.InetAddress;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.MatchMode;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.type.StringType;
import org.hibernate.type.Type;
import org.opennms.core.utils.ByteArrayComparator;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.netmgt.config.siteStatusViews.Category;
import org.opennms.netmgt.config.siteStatusViews.RowDef;
import org.opennms.netmgt.config.siteStatusViews.View;
import org.opennms.netmgt.dao.api.CategoryDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.SiteStatusViewConfigDao;
import org.opennms.netmgt.model.OnmsCriteria;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.OnmsRestrictions;
import org.opennms.netmgt.model.OnmsSnmpInterface;
import org.opennms.web.svclayer.NodeListService;
import org.opennms.web.svclayer.model.AggregateStatus;
import org.opennms.web.svclayer.model.NodeListCommand;
import org.opennms.web.svclayer.model.NodeListModel;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.util.Assert;

public class DefaultNodeListService
implements NodeListService,
InitializingBean {
    private static final Comparator<OnmsIpInterface> IP_INTERFACE_COMPARATOR = new IpInterfaceComparator();
    private static final Comparator<OnmsSnmpInterface> SNMP_INTERFACE_COMPARATOR = new SnmpInterfaceComparator();
    private NodeDao m_nodeDao;
    private CategoryDao m_categoryDao;
    private SiteStatusViewConfigDao m_siteStatusViewConfigDao;

    @Override
    public NodeListModel createNodeList(NodeListCommand command) {
        return this.createNodeList(command, true);
    }

    @Override
    public NodeListModel createNodeList(NodeListCommand command, boolean sanitizeLabels) {
        List<OnmsNode> onmsNodes = null;
        OnmsCriteria criteria = new OnmsCriteria(OnmsNode.class, "node");
        criteria.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        criteria.add((Criterion)Restrictions.ne((String)"node.type", (Object)"D"));
        this.addCriteriaForCommand(criteria, command);
        criteria.addOrder(Order.asc((String)"node.label"));
        onmsNodes = this.m_nodeDao.findMatching(criteria);
        if (command.getNodesWithDownAggregateStatus()) {
            AggregateStatus as = new AggregateStatus((Collection<OnmsNode>)onmsNodes);
            onmsNodes = as.getDownNodes();
        }
        if (sanitizeLabels) {
            for (OnmsNode node : onmsNodes) {
                node.setLabel(WebSecurityUtils.sanitizeString((String)node.getLabel()));
            }
        }
        return DefaultNodeListService.createModelForNodes(command, (Collection<OnmsNode>)onmsNodes);
    }

    private void addCriteriaForCommand(OnmsCriteria criteria, NodeListCommand command) {
        if (command.hasNodename()) {
            DefaultNodeListService.addCriteriaForNodename(criteria, command.getNodename());
        } else if (command.hasNodeId()) {
            DefaultNodeListService.addCriteriaForNodeId(criteria, command.getNodeId());
        } else if (command.hasIplike()) {
            DefaultNodeListService.addCriteriaForIpLike(criteria, command.getIplike());
        } else if (command.hasService()) {
            DefaultNodeListService.addCriteriaForService(criteria, command.getService());
        } else if (command.hasMaclike()) {
            DefaultNodeListService.addCriteriaForMaclike(criteria, command.getMaclike());
        } else if (command.hasMib2Parm() && command.hasMib2ParmValue() && command.hasMib2ParmMatchType()) {
            DefaultNodeListService.addCriteriaForMib2Parm(criteria, command.getMib2Parm(), command.getMib2ParmValue(), command.getMib2ParmMatchType());
        } else if (command.hasSnmpParm() && command.hasSnmpParmValue() && command.hasSnmpParmMatchType()) {
            DefaultNodeListService.addCriteriaForSnmpParm(criteria, command.getSnmpParm(), command.getSnmpParmValue(), command.getSnmpParmMatchType());
        } else if (command.hasCategory1() && command.hasCategory2()) {
            this.addCriteriaForCategories(criteria, command.getCategory1(), command.getCategory2());
        } else if (command.hasCategory1()) {
            this.addCriteriaForCategories(criteria, new String[][]{command.getCategory1()});
        } else if (command.hasStatusViewName() && command.hasStatusSite() && command.hasStatusRowLabel()) {
            this.addCriteriaForSiteStatusView(criteria, command.getStatusViewName(), command.getStatusSite(), command.getStatusRowLabel());
        } else if (command.hasForeignSource()) {
            DefaultNodeListService.addCriteriaForForeignSource(criteria, command.getForeignSource());
        } else if (command.hasMonitoringLocation()) {
            this.addCriteriaForMonitoringLocation(criteria, command.getMonitoringLocation());
        } else if (command.hasFlows()) {
            this.addCriteriaForFlows(criteria, command.getFlows());
        }
        if (command.getNodesWithOutages()) {
            DefaultNodeListService.addCriteriaForCurrentOutages(criteria);
        }
    }

    private void addCriteriaForFlows(OnmsCriteria criteria, Boolean hasFlows) {
        criteria.add((Criterion)Restrictions.eq((String)"node.hasFlows", (Object)hasFlows));
    }

    private void addCriteriaForMonitoringLocation(OnmsCriteria criteria, String monitoringLocation) {
        criteria.add((Criterion)Restrictions.eq((String)"node.location.locationName", (Object)monitoringLocation));
    }

    private static void addCriteriaForMib2Parm(OnmsCriteria criteria, String mib2Parm, String mib2ParmValue, String mib2ParmMatchType) {
        if (mib2ParmMatchType.equals("contains")) {
            criteria.add(Restrictions.ilike((String)"node.".concat(mib2Parm), (String)mib2ParmValue, (MatchMode)MatchMode.ANYWHERE));
        } else if (mib2ParmMatchType.equals("equals")) {
            criteria.add((Criterion)Restrictions.eq((String)"node.".concat(mib2Parm), (Object)mib2ParmValue));
        }
    }

    private static void addCriteriaForSnmpParm(OnmsCriteria criteria, String snmpParm, String snmpParmValue, String snmpParmMatchType) {
        criteria.createAlias("node.ipInterfaces", "ipInterface");
        criteria.add((Criterion)Restrictions.ne((String)"ipInterface.isManaged", (Object)"D"));
        criteria.createAlias("node.snmpInterfaces", "snmpInterface");
        criteria.add((Criterion)Restrictions.ne((String)"snmpInterface.collect", (Object)"D"));
        if (snmpParmMatchType.equals("contains")) {
            criteria.add(Restrictions.ilike((String)"snmpInterface.".concat(snmpParm), (String)snmpParmValue, (MatchMode)MatchMode.ANYWHERE));
        } else if (snmpParmMatchType.equals("equals")) {
            snmpParmValue = snmpParmValue.toLowerCase();
            criteria.add(Restrictions.sqlRestriction((String)("{alias}.nodeid in (select nodeid from snmpinterface where snmpcollect != 'D' and lower(snmp" + snmpParm + ") = '" + snmpParmValue + "')")));
        }
    }

    private static void addCriteriaForCurrentOutages(OnmsCriteria criteria) {
        criteria.add(Restrictions.sqlRestriction((String)"{alias}.nodeId in (select ip.nodeId from outages o, ifservices if, ipinterface ip where if.id = o.ifserviceid and ip.id = if.ipinterfaceid and o.ifregainedservice is null and o.suppresstime is null or o.suppresstime < now())"));
    }

    private static void addCriteriaForNodename(OnmsCriteria criteria, String nodeName) {
        criteria.add(Restrictions.ilike((String)"node.label", (String)nodeName, (MatchMode)MatchMode.ANYWHERE));
    }

    private static void addCriteriaForNodeId(OnmsCriteria criteria, String nodeIdString) {
        int nodeId = DefaultNodeListService.parseNodeId(nodeIdString);
        criteria.add(Restrictions.idEq((Object)nodeId));
    }

    private static int parseNodeId(String nodeIdString) {
        try {
            return Integer.parseInt(nodeIdString);
        }
        catch (NumberFormatException nfe) {
            LoggerFactory.getLogger(DefaultNodeListService.class).warn("{} is not a valid node id, falling back to -1.", (Object)nodeIdString);
            return -1;
        }
    }

    private static void addCriteriaForForeignSource(OnmsCriteria criteria, String foreignSource) {
        criteria.add(Restrictions.ilike((String)"node.foreignSource", (String)foreignSource, (MatchMode)MatchMode.ANYWHERE));
    }

    private static void addCriteriaForIpLike(OnmsCriteria criteria, String iplike) {
        OnmsCriteria ipInterface = criteria.createCriteria("node.ipInterfaces", "ipInterface");
        ipInterface.add((Criterion)Restrictions.ne((String)"isManaged", (Object)"D"));
        ipInterface.add(OnmsRestrictions.ipLike((String)iplike));
    }

    private static void addCriteriaForService(OnmsCriteria criteria, int serviceId) {
        criteria.createAlias("node.ipInterfaces", "ipInterface");
        criteria.add((Criterion)Restrictions.ne((String)"ipInterface.isManaged", (Object)"D"));
        criteria.createAlias("node.ipInterfaces.monitoredServices", "monitoredService");
        criteria.createAlias("node.ipInterfaces.monitoredServices.serviceType", "serviceType");
        criteria.add((Criterion)Restrictions.eq((String)"serviceType.id", (Object)serviceId));
        criteria.add((Criterion)Restrictions.ne((String)"monitoredService.status", (Object)"D"));
    }

    private static void addCriteriaForMaclike(OnmsCriteria criteria, String macLike) {
        String macLikeStripped = macLike.replaceAll("[:-]", "");
        criteria.createAlias("node.snmpInterfaces", "snmpInterface", 1);
        Disjunction physAddrDisjunction = Restrictions.disjunction();
        physAddrDisjunction.add(Restrictions.ilike((String)"snmpInterface.physAddr", (String)macLikeStripped, (MatchMode)MatchMode.ANYWHERE));
        criteria.add((Criterion)physAddrDisjunction);
    }

    private void addCriteriaForCategories(OnmsCriteria criteria, String[] ... categories) {
        Assert.notNull((Object)criteria, (String)"criteria argument must not be null");
        for (Criterion criterion : this.m_categoryDao.getCriterionForCategorySetsUnion(categories)) {
            criteria.add(criterion);
        }
    }

    private void addCriteriaForSiteStatusView(OnmsCriteria criteria, String statusViewName, String statusSite, String rowLabel) {
        View view = this.m_siteStatusViewConfigDao.getView(statusViewName);
        RowDef rowDef = DefaultNodeListService.getRowDef(view, rowLabel);
        Set<String> categoryNames = DefaultNodeListService.getCategoryNamesForRowDef(rowDef);
        this.addCriteriaForCategories(criteria, new String[][]{categoryNames.toArray(new String[categoryNames.size()])});
        String sql = "{alias}.nodeId in (select nodeId from assets where " + view.getColumnName() + " = ?)";
        criteria.add(Restrictions.sqlRestriction((String)sql, (Object)statusSite, (Type)new StringType()));
    }

    private static RowDef getRowDef(View view, String rowLabel) {
        for (RowDef rowDef : view.getRows()) {
            if (!rowDef.getLabel().equals(rowLabel)) continue;
            return rowDef;
        }
        throw new DataRetrievalFailureException("Unable to locate row: " + rowLabel + " for status view: " + view.getName());
    }

    private static Set<String> getCategoryNamesForRowDef(RowDef rowDef) {
        LinkedHashSet<String> categories = new LinkedHashSet<String>();
        List cats = rowDef.getCategories();
        for (Category cat : cats) {
            categories.add(cat.getName());
        }
        return categories;
    }

    private static NodeListModel createModelForNodes(NodeListCommand command, Collection<OnmsNode> onmsNodes) {
        int interfaceCount = 0;
        LinkedList<NodeListModel.NodeModel> displayNodes = new LinkedList<NodeListModel.NodeModel>();
        for (OnmsNode node : onmsNodes) {
            LinkedList<OnmsIpInterface> displayInterfaces = new LinkedList<OnmsIpInterface>();
            LinkedList<OnmsSnmpInterface> displaySnmpInterfaces = new LinkedList<OnmsSnmpInterface>();
            if (command.getListInterfaces()) {
                if (command.hasSnmpParm() && command.getSnmpParmMatchType().equals("contains")) {
                    Iterator parmValueMatchString = ".*" + command.getSnmpParmValue().toLowerCase().replaceAll("([\\W])", "\\\\$0").replaceAll("\\\\%", ".*").replaceAll("_", ".") + ".*";
                    if (command.getSnmpParm().equals("ifAlias")) {
                        for (OnmsSnmpInterface snmpIntf2 : node.getSnmpInterfaces()) {
                            if (snmpIntf2 == null || "D".equals(snmpIntf2.getCollect()) || snmpIntf2.getIfAlias() == null || !snmpIntf2.getIfAlias().toLowerCase().matches((String)((Object)parmValueMatchString))) continue;
                            displaySnmpInterfaces.add(snmpIntf2);
                        }
                    } else if (command.getSnmpParm().equals("ifName")) {
                        for (OnmsSnmpInterface snmpIntf2 : node.getSnmpInterfaces()) {
                            if (snmpIntf2 == null || "D".equals(snmpIntf2.getCollect()) || snmpIntf2.getIfName() == null || !snmpIntf2.getIfName().toLowerCase().matches((String)((Object)parmValueMatchString))) continue;
                            displaySnmpInterfaces.add(snmpIntf2);
                        }
                    } else if (command.getSnmpParm().equals("ifDescr")) {
                        for (OnmsSnmpInterface snmpIntf2 : node.getSnmpInterfaces()) {
                            if (snmpIntf2 == null || "D".equals(snmpIntf2.getCollect()) || snmpIntf2.getIfDescr() == null || !snmpIntf2.getIfDescr().toLowerCase().matches((String)((Object)parmValueMatchString))) continue;
                            displaySnmpInterfaces.add(snmpIntf2);
                        }
                    }
                } else if (command.hasSnmpParm() && command.getSnmpParmMatchType().equals("equals")) {
                    if (command.getSnmpParm().equals("ifAlias")) {
                        for (OnmsSnmpInterface snmpIntf : node.getSnmpInterfaces()) {
                            if (snmpIntf == null || "D".equals(snmpIntf.getCollect()) || snmpIntf.getIfAlias() == null || !snmpIntf.getIfAlias().equalsIgnoreCase(command.getSnmpParmValue())) continue;
                            displaySnmpInterfaces.add(snmpIntf);
                        }
                    } else if (command.getSnmpParm().equals("ifName")) {
                        for (OnmsSnmpInterface snmpIntf : node.getSnmpInterfaces()) {
                            if (snmpIntf == null || "D".equals(snmpIntf.getCollect()) || snmpIntf.getIfName() == null || !snmpIntf.getIfName().equalsIgnoreCase(command.getSnmpParmValue())) continue;
                            displaySnmpInterfaces.add(snmpIntf);
                        }
                    } else if (command.getSnmpParm().equals("ifDescr")) {
                        for (OnmsSnmpInterface snmpIntf : node.getSnmpInterfaces()) {
                            if (snmpIntf == null || "D".equals(snmpIntf.getCollect()) || snmpIntf.getIfDescr() == null || !snmpIntf.getIfDescr().equalsIgnoreCase(command.getSnmpParmValue())) continue;
                            displaySnmpInterfaces.add(snmpIntf);
                        }
                    }
                } else if (command.hasMaclike()) {
                    OnmsSnmpInterface snmpIntf;
                    String macLikeStripped = command.getMaclike().toLowerCase().replaceAll("[:-]", "");
                    snmpIntf = node.getSnmpInterfaces().iterator();
                    while (snmpIntf.hasNext()) {
                        OnmsSnmpInterface snmpIntf2;
                        snmpIntf2 = (OnmsSnmpInterface)snmpIntf.next();
                        if (snmpIntf2.getPhysAddr() == null || "D".equals(snmpIntf2.getCollect()) || !snmpIntf2.getPhysAddr().toLowerCase().contains(macLikeStripped)) continue;
                        displaySnmpInterfaces.add(snmpIntf2);
                    }
                } else {
                    for (OnmsIpInterface intf : node.getIpInterfaces()) {
                        if ("D".equals(intf.getIsManaged()) || "0.0.0.0".equals(InetAddressUtils.str((InetAddress)intf.getIpAddress()))) continue;
                        displayInterfaces.add(intf);
                    }
                }
            }
            Collections.sort(displayInterfaces, IP_INTERFACE_COMPARATOR);
            Collections.sort(displaySnmpInterfaces, SNMP_INTERFACE_COMPARATOR);
            displayNodes.add(new NodeListModel.NodeModel(node, displayInterfaces, displaySnmpInterfaces));
            interfaceCount += displayInterfaces.size();
            interfaceCount += displaySnmpInterfaces.size();
        }
        return new NodeListModel(displayNodes, interfaceCount);
    }

    public CategoryDao getCategoryDao() {
        return this.m_categoryDao;
    }

    public void setCategoryDao(CategoryDao categoryDao) {
        this.m_categoryDao = categoryDao;
    }

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    public SiteStatusViewConfigDao getSiteStatusViewConfigDao() {
        return this.m_siteStatusViewConfigDao;
    }

    public void setSiteStatusViewConfigDao(SiteStatusViewConfigDao siteStatusViewConfigDao) {
        this.m_siteStatusViewConfigDao = siteStatusViewConfigDao;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.m_nodeDao != null ? 1 : 0) != 0, (String)"nodeDao property cannot be null");
        Assert.state((this.m_categoryDao != null ? 1 : 0) != 0, (String)"categoryDao property cannot be null");
        Assert.state((this.m_siteStatusViewConfigDao != null ? 1 : 0) != 0, (String)"siteStatusViewConfigDao property cannot be null");
    }

    public static class SnmpInterfaceComparator
    implements Comparator<OnmsSnmpInterface>,
    Serializable {
        private static final long serialVersionUID = 3751865611949289845L;

        @Override
        public int compare(OnmsSnmpInterface o1, OnmsSnmpInterface o2) {
            int diff;
            if (o1.getIfName() == null || o2.getIfName() == null) {
                if (o1.getIfName() != null) {
                    return -1;
                }
                if (o2.getIfName() != null) {
                    return 1;
                }
            } else {
                diff = o1.getIfName().compareTo(o2.getIfName());
                if (diff != 0) {
                    return diff;
                }
            }
            if (o1.getIfDescr() == null || o2.getIfDescr() == null) {
                if (o1.getIfDescr() != null) {
                    return -1;
                }
                if (o2.getIfDescr() != null) {
                    return 1;
                }
            } else {
                diff = o1.getIfDescr().compareTo(o2.getIfDescr());
                if (diff != 0) {
                    return diff;
                }
            }
            if ((diff = o1.getIfIndex().compareTo(o2.getIfIndex())) != 0) {
                return diff;
            }
            return o1.getId().compareTo(o2.getId());
        }
    }

    public static class IpInterfaceComparator
    implements Comparator<OnmsIpInterface>,
    Serializable {
        private static final long serialVersionUID = 1538654897829381114L;

        @Override
        public int compare(OnmsIpInterface o1, OnmsIpInterface o2) {
            int diff;
            String o1ip = InetAddressUtils.str((InetAddress)o1.getIpAddress());
            String o2ip = InetAddressUtils.str((InetAddress)o2.getIpAddress());
            if (!"0.0.0.0".equals(o1ip) && !"0.0.0.0".equals(o2ip)) {
                return new ByteArrayComparator().compare(InetAddressUtils.toIpAddrBytes((String)o1ip), InetAddressUtils.toIpAddrBytes((String)o2ip));
            }
            if (!"0.0.0.0".equals(o1ip)) {
                return -1;
            }
            if (!"0.0.0.0".equals(o2ip)) {
                return 1;
            }
            if (o1.getSnmpInterface() == null || o2.getSnmpInterface() == null) {
                if (o1.getSnmpInterface() != null) {
                    return -1;
                }
                return o1.getId().compareTo(o2.getId());
            }
            if (o1.getSnmpInterface().getIfName() == null || o2.getSnmpInterface().getIfName() == null) {
                if (o1.getSnmpInterface().getIfName() != null) {
                    return -1;
                }
                if (o2.getSnmpInterface().getIfName() != null) {
                    return 1;
                }
            } else {
                diff = o1.getSnmpInterface().getIfName().compareTo(o2.getSnmpInterface().getIfName());
                if (diff != 0) {
                    return diff;
                }
            }
            if (o1.getSnmpInterface().getIfDescr() == null || o2.getSnmpInterface().getIfDescr() == null) {
                if (o1.getSnmpInterface().getIfDescr() != null) {
                    return -1;
                }
                if (o2.getSnmpInterface().getIfDescr() != null) {
                    return 1;
                }
            } else {
                diff = o1.getSnmpInterface().getIfDescr().compareTo(o2.getSnmpInterface().getIfDescr());
                if (diff != 0) {
                    return diff;
                }
            }
            if ((diff = o1.getSnmpInterface().getIfIndex().compareTo(o2.getSnmpInterface().getIfIndex())) != 0) {
                return diff;
            }
            return o1.getId().compareTo(o2.getId());
        }
    }
}

