/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer.support;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.opennms.netmgt.config.surveillanceViews.Category;
import org.opennms.netmgt.config.surveillanceViews.ColumnDef;
import org.opennms.netmgt.config.surveillanceViews.RowDef;
import org.opennms.netmgt.config.surveillanceViews.View;
import org.opennms.netmgt.dao.api.CategoryDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.SurveillanceViewConfigDao;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.SurveillanceStatus;
import org.opennms.web.api.Util;
import org.opennms.web.svclayer.SurveillanceService;
import org.opennms.web.svclayer.model.AggregateStatus;
import org.opennms.web.svclayer.model.ProgressMonitor;
import org.opennms.web.svclayer.model.SimpleWebTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.orm.ObjectRetrievalFailureException;
import org.springframework.util.StringUtils;

public class DefaultSurveillanceService
implements SurveillanceService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSurveillanceService.class);
    private NodeDao m_nodeDao;
    private CategoryDao m_categoryDao;
    private SurveillanceViewConfigDao m_surveillanceConfigDao;

    public SimpleWebTable createSurveillanceTable() {
        return this.createSurveillanceTable("default", new ProgressMonitor());
    }

    @Override
    public SimpleWebTable createSurveillanceTable(String surveillanceViewName, ProgressMonitor progressMonitor) {
        CellStatusStrategy strategy = this.getCellStatusStrategy();
        String name = surveillanceViewName == null ? this.m_surveillanceConfigDao.getDefaultView().getName() : surveillanceViewName;
        View view = this.m_surveillanceConfigDao.getView(name);
        SurveillanceView sView = new SurveillanceView(name, this.m_surveillanceConfigDao, this.m_categoryDao);
        progressMonitor.setPhaseCount(strategy.getPhaseCount(sView) + 1);
        SimpleWebTable webTable = new SimpleWebTable();
        webTable.setTitle(view.getName());
        webTable.addColumn("Nodes Down", "simpleWebTableHeader");
        for (int colIndex = 0; colIndex < sView.getColumnCount(); ++colIndex) {
            webTable.addColumn(sView.getColumnLabel(colIndex), "simpleWebTableHeader").setLink(this.computeReportCategoryLink(sView.getColumnReportCategory(colIndex).orElse(null)));
        }
        SurveillanceStatus[][] cellStatus = strategy.calculateCellStatus(sView, progressMonitor);
        progressMonitor.beginNextPhase("Calculating Status Values");
        for (int rowIndex = 0; rowIndex < sView.getRowCount(); ++rowIndex) {
            webTable.newRow();
            webTable.addCell(sView.getRowLabel(rowIndex), "simpleWebTableRowLabel").setLink(this.computeReportCategoryLink(sView.getRowReportCategory(rowIndex).orElse(null)));
            for (int colIndex = 0; colIndex < sView.getColumnCount(); ++colIndex) {
                SurveillanceStatus survStatus = cellStatus[rowIndex][colIndex];
                String text = survStatus.getDownEntityCount() + " of " + survStatus.getTotalEntityCount();
                LOG.debug("Text: {}, Style {}", (Object)text, (Object)survStatus.getStatus());
                SimpleWebTable.Cell cell = webTable.addCell(text, survStatus.getStatus());
                if (survStatus.getDownEntityCount() <= 0) continue;
                cell.setLink(this.createNodePageUrl(sView, colIndex, rowIndex));
            }
        }
        progressMonitor.finished(webTable);
        return webTable;
    }

    private CellStatusStrategy getCellStatusStrategy() {
        return new VeryLowMemCellStatusStrategy();
    }

    private String computeReportCategoryLink(String reportCategory) {
        String link = null;
        if (reportCategory != null) {
            link = "rtc/category.jsp?category=" + Util.encode(reportCategory);
        }
        return link;
    }

    private String createNodePageUrl(SurveillanceView view, int colIndex, int rowIndex) {
        Set<Object> columns = Collections.emptySet();
        Set<Object> rows = Collections.emptySet();
        try {
            columns = view.getCategoriesForColumn(colIndex);
        }
        catch (ObjectRetrievalFailureException e) {
            LOG.warn("An error occurred while getting categories for view {}, column {}", (Object)view, (Object)colIndex);
        }
        try {
            rows = view.getCategoriesForRow(rowIndex);
        }
        catch (ObjectRetrievalFailureException e) {
            LOG.warn("An error occurred while getting categories for view {}, row {}", (Object)view, (Object)rowIndex);
        }
        ArrayList<String> params = new ArrayList<String>(columns.size() + rows.size());
        for (OnmsCategory onmsCategory : columns) {
            params.add("category1=" + Util.encode(onmsCategory.getName()));
        }
        for (OnmsCategory onmsCategory : rows) {
            params.add("category2=" + Util.encode(onmsCategory.getName()));
        }
        params.add("nodesWithDownAggregateStatus=true");
        return "element/nodeList.htm?" + StringUtils.collectionToDelimitedString(params, (String)"&");
    }

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    public CategoryDao getCategoryDao() {
        return this.m_categoryDao;
    }

    public void setCategoryDao(CategoryDao categoryDao) {
        this.m_categoryDao = categoryDao;
    }

    public SurveillanceViewConfigDao getSurveillanceConfigDao() {
        return this.m_surveillanceConfigDao;
    }

    public void setSurveillanceConfigDao(SurveillanceViewConfigDao surveillanceConfigDao) {
        this.m_surveillanceConfigDao = surveillanceConfigDao;
    }

    @Override
    public Integer getHeaderRefreshSeconds(String viewName) {
        return this.m_surveillanceConfigDao.getView(viewName == null ? this.m_surveillanceConfigDao.getDefaultView().getName() : viewName).getRefreshSeconds();
    }

    @Override
    public boolean isViewName(String viewName) {
        View view = viewName == null ? this.m_surveillanceConfigDao.getDefaultView() : this.m_surveillanceConfigDao.getView(viewName);
        return view != null;
    }

    @Override
    public List<String> getViewNames() {
        ArrayList<String> viewNames = new ArrayList<String>(this.m_surveillanceConfigDao.getViews().size());
        for (View view : this.m_surveillanceConfigDao.getViews()) {
            viewNames.add(view.getName());
        }
        Collections.sort(viewNames);
        return viewNames;
    }

    public static class SurveillanceView {
        private final SurveillanceViewConfigDao m_surveillanceConfigDao;
        private final CategoryDao m_categoryDao;
        private final View m_view;

        public SurveillanceView(String viewName, SurveillanceViewConfigDao surveillanceConfigDao, CategoryDao categoryDao) {
            this.m_surveillanceConfigDao = surveillanceConfigDao;
            this.m_categoryDao = categoryDao;
            this.m_view = this.m_surveillanceConfigDao.getView(viewName);
        }

        public int getRowCount() {
            return this.m_view.getRows().size();
        }

        public int getColumnCount() {
            return this.m_view.getColumns().size();
        }

        public Set<OnmsCategory> getCategoriesForRow(int rowIndex) {
            return this.getOnmsCategoriesFromViewCategories(this.getRowDef(rowIndex).getCategories());
        }

        private RowDef getRowDef(int rowIndex) {
            return (RowDef)this.m_view.getRows().get(rowIndex);
        }

        public Set<OnmsCategory> getCategoriesForColumn(int colIndex) {
            return this.getOnmsCategoriesFromViewCategories(this.getColumnDef(colIndex).getCategories());
        }

        private ColumnDef getColumnDef(int colIndex) {
            return (ColumnDef)this.m_view.getColumns().get(colIndex);
        }

        private Set<OnmsCategory> getOnmsCategoriesFromViewCategories(Collection<Category> viewCats) {
            HashSet<OnmsCategory> categories = new HashSet<OnmsCategory>();
            for (Category viewCat : viewCats) {
                OnmsCategory category = this.m_categoryDao.findByName(viewCat.getName());
                if (category == null) {
                    throw new ObjectRetrievalFailureException(OnmsCategory.class, (Object)viewCat.getName(), "Unable to locate OnmsCategory named: " + viewCat.getName() + " as specified in the surveillance view configuration file", null);
                }
                categories.add(category);
            }
            return categories;
        }

        public String getRowLabel(int rowIndex) {
            return this.getRowDef(rowIndex).getLabel();
        }

        public String getColumnLabel(int colIndex) {
            return this.getColumnDef(colIndex).getLabel();
        }

        public Optional<String> getColumnReportCategory(int colIndex) {
            return this.getColumnDef(colIndex).getReportCategory();
        }

        public Optional<String> getRowReportCategory(int rowIndex) {
            return this.getRowDef(rowIndex).getReportCategory();
        }
    }

    class VeryLowMemCellStatusStrategy
    implements CellStatusStrategy {
        VeryLowMemCellStatusStrategy() {
        }

        private String toString(Collection<OnmsCategory> categories) {
            StringBuilder buf = new StringBuilder();
            buf.append("{");
            for (OnmsCategory cat : categories) {
                if (buf.length() != 0) {
                    buf.append(", ");
                }
                buf.append(cat.getName());
            }
            buf.append("}");
            return buf.toString();
        }

        @Override
        public SurveillanceStatus[][] calculateCellStatus(SurveillanceView sView, ProgressMonitor progressMonitor) {
            SurveillanceStatus[][] cellStatus = new SurveillanceStatus[sView.getRowCount()][sView.getColumnCount()];
            for (int rowIndex = 0; rowIndex < sView.getRowCount(); ++rowIndex) {
                for (int colIndex = 0; colIndex < sView.getColumnCount(); ++colIndex) {
                    SurveillanceStatus status;
                    Set<OnmsCategory> rowCategories = sView.getCategoriesForRow(rowIndex);
                    Set<OnmsCategory> columnCategories = sView.getCategoriesForColumn(colIndex);
                    progressMonitor.beginNextPhase(String.format("Finding status for nodes in %s intersect %s", this.toString(rowCategories), this.toString(columnCategories)));
                    cellStatus[rowIndex][colIndex] = status = DefaultSurveillanceService.this.m_nodeDao.findSurveillanceStatusByCategoryLists(rowCategories, columnCategories);
                }
            }
            return cellStatus;
        }

        @Override
        public int getPhaseCount(SurveillanceView sView) {
            return sView.getRowCount() * sView.getColumnCount();
        }
    }

    class LowMemCellStatusStrategy
    implements CellStatusStrategy {
        LowMemCellStatusStrategy() {
        }

        private String toString(Collection<OnmsCategory> categories) {
            StringBuilder buf = new StringBuilder();
            buf.append("{");
            for (OnmsCategory cat : categories) {
                if (buf.length() != 0) {
                    buf.append(", ");
                }
                buf.append(cat.getName());
            }
            buf.append("}");
            return buf.toString();
        }

        @Override
        public SurveillanceStatus[][] calculateCellStatus(SurveillanceView sView, ProgressMonitor progressMonitor) {
            SurveillanceStatus[][] cellStatus = new SurveillanceStatus[sView.getRowCount()][sView.getColumnCount()];
            for (int rowIndex = 0; rowIndex < sView.getRowCount(); ++rowIndex) {
                for (int colIndex = 0; colIndex < sView.getColumnCount(); ++colIndex) {
                    Set<OnmsCategory> rowCategories = sView.getCategoriesForRow(rowIndex);
                    Set<OnmsCategory> columnCategories = sView.getCategoriesForColumn(colIndex);
                    progressMonitor.beginNextPhase(String.format("Finding nodes in %s intersect %s", this.toString(rowCategories), this.toString(columnCategories)));
                    List cellNodes = DefaultSurveillanceService.this.m_nodeDao.findAllByCategoryLists(rowCategories, columnCategories);
                    cellStatus[rowIndex][colIndex] = new AggregateStatus(cellNodes);
                }
            }
            return cellStatus;
        }

        @Override
        public int getPhaseCount(SurveillanceView sView) {
            return sView.getRowCount() * sView.getColumnCount();
        }
    }

    class DefaultCellStatusStrategy
    implements CellStatusStrategy {
        DefaultCellStatusStrategy() {
        }

        private Collection<OnmsNode> getNodesInCategories(Set<OnmsCategory> categories) {
            return DefaultSurveillanceService.this.m_nodeDao.findAllByCategoryList(categories);
        }

        @Override
        public SurveillanceStatus[][] calculateCellStatus(SurveillanceView sView, ProgressMonitor progressMonitor) {
            ArrayList<Collection<OnmsNode>> nodesByRowIndex = new ArrayList<Collection<OnmsNode>>();
            ArrayList<Collection<OnmsNode>> nodesByColIndex = new ArrayList<Collection<OnmsNode>>();
            for (int rowIndex = 0; rowIndex < sView.getRowCount(); ++rowIndex) {
                progressMonitor.beginNextPhase("Loading nodes for row '" + sView.getRowLabel(rowIndex) + "'");
                Collection<OnmsNode> nodesForRow = this.getNodesInCategories(sView.getCategoriesForRow(rowIndex));
                nodesByRowIndex.add(rowIndex, nodesForRow);
            }
            for (int colIndex = 0; colIndex < sView.getColumnCount(); ++colIndex) {
                progressMonitor.beginNextPhase("Loading nodes for column '" + sView.getColumnLabel(colIndex) + "'");
                Collection<OnmsNode> nodesForCol = this.getNodesInCategories(sView.getCategoriesForColumn(colIndex));
                nodesByColIndex.add(colIndex, nodesForCol);
            }
            SurveillanceStatus[][] cellStatus = new SurveillanceStatus[sView.getRowCount()][sView.getColumnCount()];
            progressMonitor.beginNextPhase("Intersecting rows and columns");
            for (int rowIndex = 0; rowIndex < sView.getRowCount(); ++rowIndex) {
                Collection nodesForRow = (Collection)nodesByRowIndex.get(rowIndex);
                for (int colIndex = 0; colIndex < sView.getColumnCount(); ++colIndex) {
                    Collection nodesForCol = (Collection)nodesByColIndex.get(colIndex);
                    HashSet<OnmsNode> cellNodes = new HashSet<OnmsNode>(nodesForRow);
                    cellNodes.retainAll(nodesForCol);
                    cellStatus[rowIndex][colIndex] = new AggregateStatus(cellNodes);
                }
            }
            return cellStatus;
        }

        @Override
        public int getPhaseCount(SurveillanceView sView) {
            return sView.getRowCount() + sView.getColumnCount() + 1;
        }
    }

    static interface CellStatusStrategy {
        public SurveillanceStatus[][] calculateCellStatus(SurveillanceView var1, ProgressMonitor var2);

        public int getPhaseCount(SurveillanceView var1);
    }
}

