/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer.support;

import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.opennms.api.reporting.ReportMode;
import org.opennms.api.reporting.parameter.ReportParameters;
import org.opennms.reporting.core.DeliveryOptions;
import org.opennms.reporting.core.svclayer.ReportServiceLocatorException;
import org.opennms.reporting.core.svclayer.ReportWrapperService;
import org.opennms.web.svclayer.SchedulerService;
import org.opennms.web.svclayer.model.TriggerDescription;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.quartz.impl.matchers.GroupMatcher;
import org.quartz.impl.triggers.CronTriggerImpl;
import org.quartz.impl.triggers.SimpleTriggerImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.binding.message.MessageBuilder;
import org.springframework.webflow.execution.RequestContext;

public class DefaultSchedulerService
implements InitializingBean,
SchedulerService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultSchedulerService.class);
    private static final String SUCCESS = "success";
    private static final String ERROR = "error";
    private static final String PARAMETER_ERROR = "Report parameters did not match the definition for the report please contact your OpenNMS administrator";
    private static final String SCHEDULER_ERROR = "An exception occurred when scheduling the report";
    private static final String TRIGGER_PARSE_ERROR = "An error occurred parsing the cron expression. It was not possible to schedule the report";
    private static final String REPORTID_ERROR = "An error occurred locating the report service bean";
    private Scheduler m_scheduler;
    private JobDetail m_jobDetail;
    private String m_triggerGroup;
    private ReportWrapperService m_reportWrapperService;

    public void afterPropertiesSet() throws Exception {
        LOG.debug("Adding job {} to scheduler", (Object)this.m_jobDetail.getKey().getName());
        this.m_scheduler.addJob(this.m_jobDetail, true);
    }

    @Override
    public List<TriggerDescription> getTriggerDescriptions() {
        ArrayList<TriggerDescription> triggerDescriptions = new ArrayList<TriggerDescription>();
        try {
            Set triggerKeys = this.m_scheduler.getTriggerKeys(GroupMatcher.groupEquals((String)this.m_triggerGroup));
            for (TriggerKey triggerKey : triggerKeys) {
                TriggerDescription description = new TriggerDescription();
                Trigger trigger = this.m_scheduler.getTrigger(triggerKey);
                description.setNextFireTime(trigger.getNextFireTime());
                description.setTriggerName(triggerKey.getName());
                description.setReportId((String)trigger.getJobDataMap().get((Object)"reportId"));
                description.setDeliveryOptions((DeliveryOptions)trigger.getJobDataMap().get((Object)"deliveryOptions"));
                description.setReportParameters(((ReportParameters)trigger.getJobDataMap().get((Object)"criteria")).getReportParms());
                triggerDescriptions.add(description);
            }
        }
        catch (SchedulerException e) {
            LOG.error("exception lretrieving trigger descriptions", (Throwable)e);
        }
        return triggerDescriptions;
    }

    @Override
    public Boolean exists(String triggerName) {
        Boolean found = false;
        try {
            Trigger trigger = this.m_scheduler.getTrigger(new TriggerKey(triggerName, this.m_triggerGroup));
            if (trigger != null) {
                found = true;
            }
        }
        catch (SchedulerException e) {
            LOG.error("exception looking up trigger name: {}", (Object)triggerName);
            LOG.error(e.getMessage());
        }
        return found;
    }

    @Override
    public void removeTrigger(String triggerName) {
        try {
            this.m_scheduler.unscheduleJob(new TriggerKey(triggerName, this.m_triggerGroup));
        }
        catch (SchedulerException e) {
            LOG.error("exception when attempting to remove trigger {}", (Object)triggerName, (Object)e);
        }
    }

    @Override
    public void removeTriggers(String[] triggerNames) {
        for (String triggerName : triggerNames) {
            this.removeTrigger(triggerName);
        }
    }

    @Override
    public String addCronTrigger(String id, ReportParameters criteria, DeliveryOptions deliveryOptions, String cronExpression, RequestContext context) {
        CronTriggerImpl cronTrigger = null;
        try {
            if (!this.m_reportWrapperService.validate(criteria, id)) {
                LOG.error(PARAMETER_ERROR);
                context.getMessageContext().addMessage(new MessageBuilder().error().defaultText(PARAMETER_ERROR).build());
                return ERROR;
            }
            try {
                cronTrigger = new CronTriggerImpl();
                cronTrigger.setGroup(this.m_triggerGroup);
                cronTrigger.setName(deliveryOptions.getInstanceId());
                cronTrigger.setJobName(this.m_jobDetail.getKey().getName());
                cronTrigger.setCronExpression(cronExpression);
            }
            catch (ParseException e) {
                LOG.error(TRIGGER_PARSE_ERROR, (Throwable)e);
                context.getMessageContext().addMessage(new MessageBuilder().error().defaultText(TRIGGER_PARSE_ERROR).build());
                context.getMessageContext().addMessage(new MessageBuilder().error().defaultText(e.getMessage()).build());
                return ERROR;
            }
            cronTrigger.setJobName(this.m_jobDetail.getKey().getName());
            cronTrigger.getJobDataMap().put("criteria", (Object)criteria);
            cronTrigger.getJobDataMap().put("reportId", id);
            cronTrigger.getJobDataMap().put("mode", (Object)ReportMode.SCHEDULED);
            cronTrigger.getJobDataMap().put("deliveryOptions", (Object)deliveryOptions);
            try {
                this.m_scheduler.scheduleJob((Trigger)cronTrigger);
            }
            catch (SchedulerException e) {
                LOG.error(SCHEDULER_ERROR, (Throwable)e);
                context.getMessageContext().addMessage(new MessageBuilder().error().defaultText(SCHEDULER_ERROR).build());
                return ERROR;
            }
            return SUCCESS;
        }
        catch (ReportServiceLocatorException e) {
            LOG.error(REPORTID_ERROR);
            context.getMessageContext().addMessage(new MessageBuilder().error().defaultText(REPORTID_ERROR).build());
            return ERROR;
        }
    }

    @Override
    public String execute(String id, ReportParameters criteria, DeliveryOptions deliveryOptions, RequestContext context) {
        try {
            if (!this.m_reportWrapperService.validate(criteria, id)) {
                context.getMessageContext().addMessage(new MessageBuilder().error().defaultText(PARAMETER_ERROR).build());
                return ERROR;
            }
            SimpleTriggerImpl trigger = new SimpleTriggerImpl(deliveryOptions.getInstanceId(), this.m_triggerGroup, new Date(), null, 0, 0L);
            trigger.setJobName(this.m_jobDetail.getKey().getName());
            trigger.getJobDataMap().put("criteria", (Object)criteria);
            trigger.getJobDataMap().put("reportId", id);
            trigger.getJobDataMap().put("mode", (Object)ReportMode.IMMEDIATE);
            trigger.getJobDataMap().put("deliveryOptions", (Object)deliveryOptions);
            try {
                this.m_scheduler.scheduleJob((Trigger)trigger);
            }
            catch (SchedulerException e) {
                LOG.warn(SCHEDULER_ERROR, (Throwable)e);
                context.getMessageContext().addMessage(new MessageBuilder().error().defaultText(SCHEDULER_ERROR).build());
                return ERROR;
            }
            return SUCCESS;
        }
        catch (ReportServiceLocatorException e) {
            LOG.error(REPORTID_ERROR, (Throwable)e);
            context.getMessageContext().addMessage(new MessageBuilder().error().defaultText(REPORTID_ERROR).build());
            return ERROR;
        }
    }

    public void setScheduler(Scheduler scheduler) {
        this.m_scheduler = scheduler;
    }

    public void setJobDetail(JobDetail reportJob) {
        this.m_jobDetail = reportJob;
    }

    public void setTriggerGroup(String triggerGroup) {
        this.m_triggerGroup = triggerGroup;
    }

    public void setReportWrapperService(ReportWrapperService reportWrapperService) {
        this.m_reportWrapperService = reportWrapperService;
    }
}

