/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.charts;

import org.jfree.chart.axis.ExtendedCategoryAxis;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeveritySubLabels
extends ExtendedCategoryAxis {
    private static final Logger LOG = LoggerFactory.getLogger(SeveritySubLabels.class);
    private static final long serialVersionUID = 4985544589299368239L;

    public SeveritySubLabels() {
        super(null);
    }

    public SeveritySubLabels(String label) {
        super(label);
    }

    public void addSubLabel(Comparable category, String label) {
        super.addSubLabel(category, SeveritySubLabels.convertLabel(label));
    }

    private static String convertLabel(String severity) {
        int sev = 0;
        String converted = "Unk";
        try {
            sev = Integer.parseInt(severity);
        }
        catch (NumberFormatException e) {
            LOG.warn("Problem converting severity: {} to an int value.", (Object)severity);
        }
        switch (sev) {
            case 0: {
                converted = "Unk";
                break;
            }
            case 1: {
                converted = "Ind";
                break;
            }
            case 2: {
                converted = "Cleared";
                break;
            }
            case 3: {
                converted = "Normal";
                break;
            }
            case 4: {
                converted = "Warn";
                break;
            }
            case 5: {
                converted = "Minor";
                break;
            }
            case 6: {
                converted = "Major";
                break;
            }
            case 7: {
                converted = "Critical";
            }
        }
        return converted;
    }
}

