/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer.support;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.netmgt.dao.api.CategoryDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.events.api.EventProxy;
import org.opennms.netmgt.events.api.EventProxyException;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.model.events.EventUtils;
import org.opennms.netmgt.xml.event.Event;
import org.opennms.web.svclayer.AdminCategoryService;
import org.springframework.jdbc.datasource.lookup.DataSourceLookupFailureException;

public class DefaultAdminCategoryService
implements AdminCategoryService {
    private CategoryDao m_categoryDao;
    private NodeDao m_nodeDao;
    private EventProxy m_eventProxy;

    public CategoryDao getCategoryDao() {
        return this.m_categoryDao;
    }

    public void setCategoryDao(CategoryDao dao) {
        this.m_categoryDao = dao;
    }

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    public void setEventProxy(EventProxy eventProxy) {
        this.m_eventProxy = eventProxy;
    }

    @Override
    public CategoryAndMemberNodes getCategory(String categoryIdString) {
        if (categoryIdString == null) {
            throw new IllegalArgumentException("categoryIdString must not be null");
        }
        OnmsCategory category = this.findCategory(categoryIdString);
        ArrayList<OnmsNode> memberNodes = new ArrayList<OnmsNode>();
        for (OnmsNode node : this.getNodeDao().findByCategory(category)) {
            if (OnmsNode.NodeType.DELETED.equals((Object)node.getType())) continue;
            memberNodes.add(node);
        }
        Collections.sort(memberNodes);
        return new CategoryAndMemberNodes(category, memberNodes);
    }

    private OnmsCategory findCategory(String name) {
        int categoryId = -1;
        try {
            categoryId = WebSecurityUtils.safeParseInt((String)name);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("parameter 'categoryid' with value '" + name + "' could not be parsed as an integer");
        }
        OnmsCategory category = (OnmsCategory)this.m_categoryDao.get((Serializable)Integer.valueOf(categoryId));
        if (category == null) {
            throw new IllegalArgumentException("Could not find category with category ID " + categoryId);
        }
        return category;
    }

    @Override
    public List<OnmsNode> findAllNodes() {
        ArrayList<OnmsNode> list = new ArrayList<OnmsNode>();
        for (OnmsNode node : this.getNodeDao().findAll()) {
            if (OnmsNode.NodeType.DELETED.equals((Object)node.getType())) continue;
            list.add(node);
        }
        Collections.sort(list);
        return list;
    }

    @Override
    public EditModel findCategoryAndAllNodes(String categoryIdString) {
        CategoryAndMemberNodes cat = this.getCategory(categoryIdString);
        List<OnmsNode> monitoredNodes = this.findAllNodes();
        return new EditModel(cat.getCategory(), monitoredNodes, cat.getMemberNodes());
    }

    @Override
    public void performEdit(String categoryIdString, String editAction, String[] toAdd, String[] toDelete) {
        if (categoryIdString == null) {
            throw new IllegalArgumentException("categoryIdString cannot be null");
        }
        if (editAction == null) {
            throw new IllegalArgumentException("editAction cannot be null");
        }
        OnmsCategory category = this.findCategory(categoryIdString);
        if (editAction.contains("Add")) {
            if (toAdd == null) {
                return;
            }
            for (String idString : toAdd) {
                Integer id;
                try {
                    id = WebSecurityUtils.safeParseInt((String)idString);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("toAdd element '" + idString + "' is not an integer");
                }
                OnmsNode node = (OnmsNode)this.getNodeDao().get((Serializable)id);
                if (node == null) {
                    throw new IllegalArgumentException("node with id of " + id + "could not be found");
                }
                if (node.getCategories().contains(category)) {
                    throw new IllegalArgumentException("node with id of " + id + "is already a member of category " + category.getName());
                }
                node.addCategory(category);
                this.getNodeDao().save((Object)node);
            }
        } else if (editAction.contains("Remove")) {
            if (toDelete == null) {
                return;
            }
            for (String idString : toDelete) {
                Integer id;
                try {
                    id = WebSecurityUtils.safeParseInt((String)idString);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("toDelete element '" + idString + "' is not an integer");
                }
                OnmsNode node = (OnmsNode)this.getNodeDao().get((Serializable)id);
                if (node == null) {
                    throw new IllegalArgumentException("node with id of " + id + "could not be found");
                }
                if (!node.getCategories().contains(category)) {
                    throw new IllegalArgumentException("Node with id of " + id + "is not a member of category " + category.getName());
                }
                node.removeCategory(category);
                this.getNodeDao().save((Object)node);
            }
        } else {
            throw new IllegalArgumentException("editAction of '" + editAction + "' is not allowed");
        }
    }

    @Override
    public OnmsCategory addNewCategory(String name) {
        OnmsCategory category = new OnmsCategory();
        category.setName(name);
        this.m_categoryDao.save((Object)category);
        return category;
    }

    @Override
    public OnmsCategory getCategoryWithName(String name) {
        return this.m_categoryDao.findByName(name);
    }

    @Override
    public List<OnmsCategory> findAllCategories() {
        List categories = this.m_categoryDao.findAll();
        ArrayList<OnmsCategory> sortedCategories = new ArrayList<OnmsCategory>(categories);
        Collections.sort(sortedCategories, new Comparator<OnmsCategory>(){

            @Override
            public int compare(OnmsCategory o1, OnmsCategory o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        return sortedCategories;
    }

    @Override
    public void removeCategory(String categoryIdString) {
        OnmsCategory category = this.findCategory(categoryIdString);
        CategoryAndMemberNodes cat = this.getCategory(categoryIdString);
        for (OnmsNode adriftNode : cat.getMemberNodes()) {
            this.notifyCategoryChange(adriftNode, new String[0], new String[]{category.getName()});
        }
        this.m_categoryDao.delete((Object)category);
    }

    @Override
    public List<OnmsCategory> findByNode(int nodeId) {
        OnmsNode node = (OnmsNode)this.getNodeDao().get((Serializable)Integer.valueOf(nodeId));
        if (node == null) {
            throw new IllegalArgumentException("node with id of " + nodeId + "could not be found");
        }
        ArrayList<OnmsCategory> categories = new ArrayList<OnmsCategory>(node.getCategories());
        Collections.sort(categories);
        return categories;
    }

    @Override
    public NodeEditModel findNodeCategories(String nodeIdString) {
        if (nodeIdString == null) {
            throw new IllegalArgumentException("nodeIdString must not be null");
        }
        OnmsNode node = this.findNode(nodeIdString);
        List<OnmsCategory> categories = this.findAllCategories();
        return new NodeEditModel(node, categories);
    }

    @Override
    public void performNodeEdit(String nodeIdString, String editAction, String[] toAdd, String[] toDelete) {
        if (nodeIdString == null) {
            throw new IllegalArgumentException("nodeIdString cannot be null");
        }
        if (editAction == null) {
            throw new IllegalArgumentException("editAction cannot be null");
        }
        OnmsNode node = this.findNode(nodeIdString);
        if (node == null) {
            throw new IllegalArgumentException("No 'node' with id '" + nodeIdString + "' could be found");
        }
        if (editAction.contains("Add")) {
            if (toAdd == null) {
                return;
            }
            for (String idString : toAdd) {
                Integer id;
                try {
                    id = WebSecurityUtils.safeParseInt((String)idString);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("toAdd element '" + idString + "' is not an integer");
                }
                OnmsCategory category = (OnmsCategory)this.m_categoryDao.get((Serializable)id);
                if (category == null) {
                    throw new IllegalArgumentException("Category with id of " + id + " could not be found");
                }
                if (node.getCategories().contains(category)) {
                    throw new IllegalArgumentException("Category with id of " + id + "is already on node " + node.getLabel());
                }
                node.getCategories().add(category);
            }
            this.getNodeDao().save((Object)node);
            this.notifyCategoryChange(node, toAdd, new String[0]);
        } else if (editAction.contains("Remove")) {
            if (toDelete == null) {
                return;
            }
            for (String idString : toDelete) {
                Integer id;
                try {
                    id = WebSecurityUtils.safeParseInt((String)idString);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException("toDelete element '" + idString + "' is not an integer");
                }
                OnmsCategory category = (OnmsCategory)this.m_categoryDao.get((Serializable)id);
                if (category == null) {
                    throw new IllegalArgumentException("Category with id of " + id + " could not be found");
                }
                if (!node.getCategories().contains(category)) {
                    throw new IllegalArgumentException("Category with id of " + id + "is not on node " + node.getLabel());
                }
                node.getCategories().remove(category);
            }
            this.getNodeDao().save((Object)node);
            this.notifyCategoryChange(node, new String[0], toDelete);
        } else {
            throw new IllegalArgumentException("editAction of '" + editAction + "' is not allowed");
        }
    }

    private OnmsNode findNode(String nodeIdString) {
        int nodeId;
        try {
            nodeId = WebSecurityUtils.safeParseInt((String)nodeIdString);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("parameter 'node' with value '" + nodeIdString + "' could not be parsed as an integer");
        }
        return (OnmsNode)this.getNodeDao().get((Serializable)Integer.valueOf(nodeId));
    }

    private void notifyCategoryChange(OnmsNode node, String[] categoriesAdded, String[] categoriesDeleted) {
        this.send(EventUtils.createNodeCategoryMembershipChangedEvent((String)"CategoryUI", (Integer)node.getId(), (String)node.getLabel(), (String[])categoriesAdded, (String[])categoriesDeleted));
    }

    private void send(Event e) {
        try {
            this.m_eventProxy.send(e);
        }
        catch (EventProxyException e1) {
            throw new DataSourceLookupFailureException("Unable to send event to eventd", (Throwable)e1);
        }
    }

    public static class NodeEditModel {
        private OnmsNode m_node;
        private List<OnmsCategory> m_categories;
        private List<OnmsCategory> m_sortedCategories;

        public NodeEditModel(OnmsNode node, List<OnmsCategory> categories) {
            this.m_node = node;
            this.m_categories = categories;
            for (OnmsCategory category : this.m_node.getCategories()) {
                this.m_categories.remove(category);
            }
            this.m_sortedCategories = new ArrayList<OnmsCategory>(this.m_node.getCategories());
            Collections.sort(this.m_sortedCategories);
        }

        public OnmsNode getNode() {
            return this.m_node;
        }

        public List<OnmsCategory> getCategories() {
            return this.m_categories;
        }

        public List<OnmsCategory> getSortedCategories() {
            return this.m_sortedCategories;
        }
    }

    public static class EditModel {
        private OnmsCategory m_category;
        private List<OnmsNode> m_nodes;
        private List<OnmsNode> m_sortedMemberNodes;

        public EditModel(OnmsCategory category, List<OnmsNode> nodes, Collection<OnmsNode> memberNodes) {
            this.m_category = category;
            this.m_nodes = nodes;
            for (OnmsNode node : memberNodes) {
                this.m_nodes.remove(node);
            }
            this.m_sortedMemberNodes = new ArrayList<OnmsNode>(memberNodes);
            Collections.sort(this.m_sortedMemberNodes);
        }

        public OnmsCategory getCategory() {
            return this.m_category;
        }

        public List<OnmsNode> getNodes() {
            return this.m_nodes;
        }

        public List<OnmsNode> getSortedMemberNodes() {
            return this.m_sortedMemberNodes;
        }
    }

    public static class CategoryAndMemberNodes {
        private OnmsCategory m_category;
        private Collection<OnmsNode> m_memberNodes;

        public CategoryAndMemberNodes(OnmsCategory category, Collection<OnmsNode> memberNodes) {
            this.m_category = category;
            this.m_memberNodes = memberNodes;
        }

        public OnmsCategory getCategory() {
            return this.m_category;
        }

        public Collection<OnmsNode> getMemberNodes() {
            return this.m_memberNodes;
        }
    }
}

