/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.category;

import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import org.opennms.core.db.DataSourceFactory;
import org.opennms.core.utils.DBUtils;
import org.opennms.netmgt.config.CategoryFactory;
import org.opennms.netmgt.config.api.CatFactory;
import org.opennms.web.category.Category;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CategoryModel {
    private static final Logger LOG = LoggerFactory.getLogger(CategoryModel.class);
    public static final String OVERALL_AVAILABILITY_CATEGORY = "Overall Service Availability";
    private static CategoryModel m_instance;
    private Map<String, Category> m_categoryMap = new HashMap<String, Category>();
    private CatFactory m_factory = null;

    public static synchronized CategoryModel getInstance() throws IOException {
        if (m_instance == null) {
            m_instance = new CategoryModel();
        }
        return m_instance;
    }

    private CategoryModel() throws IOException {
        CategoryFactory.init();
        this.m_factory = CategoryFactory.getInstance();
        LOG.debug("The CategoryModel object was created");
    }

    public Category getCategory(String categoryName) {
        if (categoryName == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        return this.m_categoryMap.get(categoryName);
    }

    public Map<String, Category> getCategoryMap() {
        return Collections.unmodifiableMap(new HashMap<String, Category>(this.m_categoryMap));
    }

    public double getCategoryNormalThreshold(String categoryName) {
        if (categoryName == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        return this.m_factory.getNormal(categoryName);
    }

    public double getCategoryWarningThreshold(String categoryName) {
        if (categoryName == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        return this.m_factory.getWarning(categoryName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCategoryComment(String categoryName) {
        if (categoryName == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        String comment = null;
        this.m_factory.getReadLock().lock();
        try {
            org.opennms.netmgt.config.categories.Category category = this.m_factory.getCategory(categoryName);
            if (category != null) {
                comment = category.getComment();
            }
        }
        finally {
            this.m_factory.getReadLock().unlock();
        }
        return comment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCategory(org.opennms.netmgt.xml.rtc.Category rtcCategory) {
        if (rtcCategory == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        String categoryName = rtcCategory.getCatlabel();
        this.m_factory.getWriteLock().lock();
        try {
            org.opennms.netmgt.config.categories.Category categoryDef = this.m_factory.getCategory(categoryName);
            Category category = new Category(categoryDef, rtcCategory, new Date());
            Map<String, Category> map = this.m_categoryMap;
            synchronized (map) {
                this.m_categoryMap.put(categoryName, category);
            }
        }
        finally {
            this.m_factory.getWriteLock().unlock();
        }
        LOG.debug("{} was updated", (Object)categoryName);
    }

    public static double getNodeAvailability(int nodeId) throws SQLException {
        GregorianCalendar cal = new GregorianCalendar();
        Date now = cal.getTime();
        ((Calendar)cal).add(5, -1);
        Date yesterday = cal.getTime();
        return CategoryModel.getNodeAvailability(nodeId, yesterday, now);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static double getNodeAvailability(int nodeId, Date start, Date end) throws SQLException {
        if (start == null || end == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        if (end.before(start)) {
            throw new IllegalArgumentException("Cannot have an end time before the start time.");
        }
        if (end.equals(start)) {
            throw new IllegalArgumentException("Cannot have an end time equal to the start time.");
        }
        double avail = -1.0;
        DBUtils d = new DBUtils(CategoryModel.class);
        try {
            Connection conn = DataSourceFactory.getInstance().getConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("select getManagePercentAvailNodeWindow(?, ?, ?) as avail");
            d.watch((Object)stmt);
            stmt.setInt(1, nodeId);
            stmt.setTimestamp(2, new Timestamp(end.getTime()));
            stmt.setTimestamp(3, new Timestamp(start.getTime()));
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            if (rs.next()) {
                avail = rs.getDouble("avail");
            }
        }
        catch (SQLException e) {
            LOG.warn("Failed to get node availability for nodeId {}", (Object)nodeId, (Object)e);
        }
        finally {
            d.cleanUp();
        }
        return avail;
    }

    public static double getInterfaceAvailability(int nodeId, String ipAddr) throws SQLException {
        if (ipAddr == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        GregorianCalendar cal = new GregorianCalendar();
        Date now = cal.getTime();
        ((Calendar)cal).add(5, -1);
        Date yesterday = cal.getTime();
        return CategoryModel.getInterfaceAvailability(nodeId, ipAddr, yesterday, now);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static double getInterfaceAvailability(int nodeId, String ipAddr, Date start, Date end) throws SQLException {
        if (ipAddr == null || start == null || end == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        if (end.before(start)) {
            throw new IllegalArgumentException("Cannot have an end time before the start time.");
        }
        if (end.equals(start)) {
            throw new IllegalArgumentException("Cannot have an end time equal to the start time.");
        }
        double avail = -1.0;
        DBUtils d = new DBUtils(CategoryModel.class);
        try {
            Connection conn = DataSourceFactory.getInstance().getConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("select getManagePercentAvailIntfWindow(?, ?, ?, ?) as avail");
            d.watch((Object)stmt);
            stmt.setInt(1, nodeId);
            stmt.setString(2, ipAddr);
            stmt.setTimestamp(3, new Timestamp(end.getTime()));
            stmt.setTimestamp(4, new Timestamp(start.getTime()));
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            if (rs.next()) {
                avail = rs.getDouble("avail");
            }
        }
        catch (SQLException e) {
            LOG.warn("Failed to get interface availability for nodeId {}, interface {}", new Object[]{nodeId, ipAddr, e});
        }
        finally {
            d.cleanUp();
        }
        return avail;
    }

    public static double getServiceAvailability(int nodeId, String ipAddr, int serviceId) throws SQLException {
        if (ipAddr == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        GregorianCalendar cal = new GregorianCalendar();
        Date now = cal.getTime();
        ((Calendar)cal).add(5, -1);
        Date yesterday = cal.getTime();
        return CategoryModel.getServiceAvailability(nodeId, ipAddr, serviceId, yesterday, now);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static double getServiceAvailability(int nodeId, String ipAddr, int serviceId, Date start, Date end) throws SQLException {
        if (ipAddr == null || start == null || end == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        if (end.before(start)) {
            throw new IllegalArgumentException("Cannot have an end time before the start time.");
        }
        if (end.equals(start)) {
            throw new IllegalArgumentException("Cannot have an end time equal to the start time.");
        }
        DBUtils d = new DBUtils(CategoryModel.class);
        try {
            Connection conn = DataSourceFactory.getInstance().getConnection();
            d.watch((Object)conn);
            PreparedStatement stmt = conn.prepareStatement("select getPercentAvailabilityInWindow(ifservices.id, ?, ?) as avail from ifservices, ipinterface, node where ifservices.ipInterfaceId = ipinterface.id and ipInterface.nodeid = node.nodeid and ifservices.status='A' and ipinterface.ismanaged='M' and node.nodetype='A' and node.nodeid=? and ipInterface.ipaddr=? and ifServices.serviceid=?");
            d.watch((Object)stmt);
            stmt.setTimestamp(1, new Timestamp(end.getTime()));
            stmt.setTimestamp(2, new Timestamp(start.getTime()));
            stmt.setInt(3, nodeId);
            stmt.setString(4, ipAddr);
            stmt.setInt(5, serviceId);
            ResultSet rs = stmt.executeQuery();
            d.watch((Object)rs);
            if (rs.next()) {
                double d2 = rs.getDouble("avail");
                return d2;
            }
        }
        catch (SQLException e) {
            LOG.warn("Failed to get service availability for nodeId {}, interface {}, serviceId {}", new Object[]{nodeId, ipAddr, serviceId, e});
        }
        finally {
            d.cleanUp();
        }
        return -1.0;
    }
}

