/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.api;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import org.opennms.core.utils.BundleLists;
import org.opennms.core.utils.ConfigFileConstants;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Authentication {
    private static final Logger LOG = LoggerFactory.getLogger(Authentication.class);
    public static final String ROLE_CONFIGURATION_FILE = "security-roles.properties";
    public static final String ROLE_USER = "ROLE_USER";
    public static final String ROLE_ADMIN = "ROLE_ADMIN";
    public static final String ROLE_READONLY = "ROLE_READONLY";
    public static final String ROLE_DASHBOARD = "ROLE_DASHBOARD";
    public static final String ROLE_RTC = "ROLE_RTC";
    public static final String ROLE_PROVISION = "ROLE_PROVISION";
    public static final String ROLE_REMOTING = "ROLE_REMOTING";
    public static final String ROLE_REST = "ROLE_REST";
    public static final String ROLE_ASSET_EDITOR = "ROLE_ASSET_EDITOR";
    public static final String ROLE_MOBILE = "ROLE_MOBILE";
    public static final String ROLE_JMX = "ROLE_JMX";
    public static final String ROLE_MINION = "ROLE_MINION";
    private static List<String> s_availableRoles = new ArrayList<String>();
    private static long lastModified = 0L;

    private Authentication() {
    }

    public static List<String> getAvailableRoles() {
        Authentication.loadRoles();
        return Collections.unmodifiableList(s_availableRoles);
    }

    public static boolean isValidRole(String role) {
        Authentication.loadRoles();
        return s_availableRoles.contains(role);
    }

    private static void loadRoles() {
        File configFile = new File(ConfigFileConstants.getHome(), "etc" + File.separator + ROLE_CONFIGURATION_FILE);
        if (configFile.exists() && configFile.lastModified() > lastModified) {
            lastModified = configFile.lastModified();
            Properties p = new Properties();
            try {
                LOG.info("Loading security roles from {}", (Object)configFile);
                p.load(new FileInputStream(configFile));
                String roleList = p.getProperty("roles");
                if (roleList != null) {
                    for (String role : BundleLists.parseBundleList((String)roleList)) {
                        String securityRole = "ROLE_" + role.toUpperCase();
                        if (s_availableRoles.contains(securityRole)) continue;
                        LOG.info("Adding role {}", (Object)securityRole);
                        s_availableRoles.add(securityRole);
                    }
                }
            }
            catch (Exception e) {
                LOG.warn("Can't load security roles from {}, because: {}", (Object)configFile, (Object)e.getMessage());
            }
        }
    }

    static {
        s_availableRoles.add(ROLE_USER);
        s_availableRoles.add(ROLE_ADMIN);
        s_availableRoles.add(ROLE_READONLY);
        s_availableRoles.add(ROLE_DASHBOARD);
        s_availableRoles.add(ROLE_RTC);
        s_availableRoles.add(ROLE_PROVISION);
        s_availableRoles.add(ROLE_REMOTING);
        s_availableRoles.add(ROLE_REST);
        s_availableRoles.add(ROLE_ASSET_EDITOR);
        s_availableRoles.add(ROLE_MOBILE);
        s_availableRoles.add(ROLE_JMX);
        s_availableRoles.add(ROLE_MINION);
    }
}

