/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.api;

import java.beans.PropertyEditor;
import java.net.InetAddress;
import java.util.Date;
import javax.ws.rs.core.MultivaluedMap;
import javax.xml.datatype.XMLGregorianCalendar;
import org.opennms.netmgt.model.InetAddressTypeEditor;
import org.opennms.netmgt.model.OnmsSeverity;
import org.opennms.netmgt.model.OnmsSeverityEditor;
import org.opennms.netmgt.model.PrimaryType;
import org.opennms.netmgt.model.PrimaryTypeEditor;
import org.opennms.netmgt.provision.persist.StringXmlCalendarPropertyEditor;
import org.opennms.web.api.ISO8601DateEditor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.PropertyAccessorFactory;

public abstract class RestUtils {
    private static final Logger LOG = LoggerFactory.getLogger(RestUtils.class);

    public static void setBeanProperties(Object bean, MultivaluedMap<String, String> properties) {
        BeanWrapper wrapper = PropertyAccessorFactory.forBeanPropertyAccess((Object)bean);
        wrapper.registerCustomEditor(XMLGregorianCalendar.class, (PropertyEditor)new StringXmlCalendarPropertyEditor());
        wrapper.registerCustomEditor(Date.class, (PropertyEditor)new ISO8601DateEditor());
        wrapper.registerCustomEditor(InetAddress.class, (PropertyEditor)new InetAddressTypeEditor());
        wrapper.registerCustomEditor(OnmsSeverity.class, (PropertyEditor)new OnmsSeverityEditor());
        wrapper.registerCustomEditor(PrimaryType.class, (PropertyEditor)new PrimaryTypeEditor());
        for (String key : properties.keySet()) {
            String propertyName = RestUtils.convertNameToPropertyName(key);
            if (!wrapper.isWritableProperty(propertyName)) continue;
            String stringValue = (String)properties.getFirst((Object)key);
            Object value = RestUtils.convertIfNecessary(wrapper, propertyName, stringValue);
            wrapper.setPropertyValue(propertyName, value);
        }
    }

    private static Object convertIfNecessary(BeanWrapper wrapper, String propertyName, String stringValue) {
        LOG.debug("convertIfNecessary({}, {})", (Object)propertyName, (Object)stringValue);
        return wrapper.convertIfNecessary((Object)stringValue, wrapper.getPropertyType(propertyName));
    }

    public static String convertNameToPropertyName(String name) {
        StringBuffer result = new StringBuffer();
        boolean nextIsUpper = false;
        if (name != null && name.length() > 0) {
            if (name.length() > 1 && (name.substring(1, 2).equals("_") || name.substring(1, 2).equals("-"))) {
                result.append(name.substring(0, 1).toUpperCase());
            } else {
                result.append(name.substring(0, 1).toLowerCase());
            }
            for (int i = 1; i < name.length(); ++i) {
                String s = name.substring(i, i + 1);
                if (s.equals("_") || s.equals("-")) {
                    nextIsUpper = true;
                    continue;
                }
                if (nextIsUpper) {
                    result.append(s.toUpperCase());
                    nextIsUpper = false;
                    continue;
                }
                result.append(s.toLowerCase());
            }
        }
        return result.toString();
    }
}

