/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer.dao.support;

import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.opennms.core.xml.CastorUtils;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.opennms.web.svclayer.dao.ManualProvisioningDao;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.dao.NonTransientDataAccessResourceException;
import org.springframework.dao.OptimisticLockingFailureException;
import org.springframework.dao.PermissionDeniedDataAccessException;
import org.springframework.util.Assert;

public class DefaultManualProvisioningDao
implements ManualProvisioningDao {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultManualProvisioningDao.class);
    private static final Pattern XML_FILE_PATTERN = Pattern.compile("^(.*)\\.xml$");
    private File m_importFileDir;

    public void setImportFileDirectory(File importFileDir) {
        this.m_importFileDir = importFileDir;
        if (!this.m_importFileDir.exists() && !this.m_importFileDir.mkdirs()) {
            throw new NonTransientDataAccessResourceException("import file directory (" + this.m_importFileDir.getPath() + ") does not exist");
        }
    }

    @Override
    public Requisition get(String name) {
        this.checkGroupName(name);
        File importFile = this.getImportFile(name);
        if (!importFile.exists()) {
            return null;
        }
        if (!importFile.canRead()) {
            throw new PermissionDeniedDataAccessException("Unable to read file " + importFile, null);
        }
        return (Requisition)CastorUtils.unmarshalWithTranslatedExceptions(Requisition.class, (Resource)new FileSystemResource(importFile));
    }

    private void checkGroupName(String name) {
        Assert.hasLength((String)name, (String)"Group name must not be null or the empty string");
    }

    @Override
    public Collection<String> getProvisioningGroupNames() {
        String[] importFiles = this.m_importFileDir.list(this.getImportFilenameFilter());
        String[] groupNames = new String[importFiles.length];
        for (int i = 0; i < importFiles.length; ++i) {
            groupNames[i] = this.getGroupNameForImportFileName(importFiles[i]);
        }
        return Arrays.asList(groupNames);
    }

    @Override
    public void save(String groupName, Requisition group) {
        FileWriter writer;
        Requisition currentData;
        this.checkGroupName(groupName);
        File importFile = this.getImportFile(groupName);
        if (importFile.exists() && (currentData = this.get(groupName)).getDateStamp().compare(group.getDateStamp()) > 0) {
            throw new OptimisticLockingFailureException("Data in file " + importFile + " is newer than data to be saved!");
        }
        try {
            writer = new FileWriter(importFile);
        }
        catch (IOException e) {
            throw new PermissionDeniedDataAccessException("Unable to write file " + importFile, (Throwable)e);
        }
        CastorUtils.marshalWithTranslatedExceptions((Object)group, (Writer)writer);
    }

    private File getImportFile(String groupName) {
        this.checkGroupName(groupName);
        return new File(this.m_importFileDir, groupName + ".xml");
    }

    public FilenameFilter getImportFilenameFilter() {
        return new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                Matcher matcher = XML_FILE_PATTERN.matcher(name);
                return matcher.matches();
            }
        };
    }

    private String getGroupNameForImportFileName(String filename) {
        Matcher matcher = XML_FILE_PATTERN.matcher(filename);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid import gorup file name " + filename + ", doesn't match form *.xml");
        }
        return matcher.group(1);
    }

    @Override
    public String getUrlForGroup(String groupName) {
        this.checkGroupName(groupName);
        return this.getImportFile(groupName).toURI().toString();
    }

    @Override
    public void delete(String groupName) {
        if (!this.getImportFile(groupName).delete()) {
            LOG.warn("Could not delete file: {}", (Object)this.getImportFile(groupName).getPath());
        }
    }
}

