/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.api;

import java.io.UnsupportedEncodingException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.opennms.core.resource.Vault;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.core.utils.WebSecurityUtils;
import org.opennms.netmgt.events.api.EventProxy;
import org.opennms.netmgt.events.api.support.TcpEventProxy;

public abstract class Util {
    private static final String[] EMPTY_STRING_ARRAY = new String[0];
    private static final Map<String, Object> EMPTY_MAP = Collections.emptyMap();
    protected static final char[] substKeywords = new char[]{'s', 'h', 'p', 'x', 'c'};
    protected static final String[] hostHeaders = new String[]{"X-Forwarded-Host", "X-Host", "Host"};

    public static String calculateUrlBase(HttpServletRequest request) {
        String retval;
        if (request == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        String tmpl = Vault.getProperty((String)"opennms.web.base-url");
        if (tmpl == null) {
            tmpl = "%s://%x%c/";
        }
        if ((retval = Util.substituteUrl(request, tmpl)).endsWith("/")) {
            return retval;
        }
        return retval + "/";
    }

    public static String calculateUrlBase(HttpServletRequest request, String path) {
        if (request == null || path == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        String tmpl = Vault.getProperty((String)"opennms.web.base-url");
        if (tmpl == null) {
            tmpl = "%s://%x%c";
        }
        return Util.substituteUrl(request, tmpl).replaceAll("/+$", "") + "/" + path.replaceAll("^/+", "");
    }

    protected static String substituteUrl(HttpServletRequest request, String tmpl) {
        String[] replacements = new String[]{request.getScheme(), request.getServerName(), Integer.toString(request.getServerPort()), Util.getHostHeader(request), request.getContextPath()};
        StringBuffer out = new StringBuffer(48);
        int i = 0;
        block0: while (i < tmpl.length()) {
            char c;
            if ((c = tmpl.charAt(i++)) == '%' && i < tmpl.length()) {
                char d = tmpl.charAt(i++);
                for (int key = 0; key < substKeywords.length; ++key) {
                    if (d != substKeywords[key]) continue;
                    out.append(replacements[key]);
                    continue block0;
                }
                continue;
            }
            out.append(c);
        }
        return out.toString();
    }

    public static String getHostHeader(HttpServletRequest request) {
        for (int i = 0; i < hostHeaders.length; ++i) {
            String[] values;
            String header = request.getHeader(hostHeaders[i]);
            if (header == null || (values = header.split(", *")).length < 1) continue;
            return values[0];
        }
        return request.getServerName() + ":" + Integer.toString(request.getServerPort());
    }

    public static String encode(String string) {
        try {
            return URLEncoder.encode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    public static String decode(String string) {
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    public static String makeHiddenTags(HttpServletRequest request) {
        return Util.makeHiddenTags(request, EMPTY_MAP, EMPTY_STRING_ARRAY);
    }

    public static String makeHiddenTags(HttpServletRequest request, Map<String, Object> additions) {
        return Util.makeHiddenTags(request, additions, EMPTY_STRING_ARRAY);
    }

    public static String makeHiddenTags(HttpServletRequest request, String[] ignores) {
        return Util.makeHiddenTags(request, EMPTY_MAP, ignores);
    }

    public static String makeHiddenTags(HttpServletRequest request, Map<String, Object> additions, String[] ignores) {
        return Util.makeHiddenTags(request, additions, ignores, IgnoreType.BOTH);
    }

    public static String makeHiddenTags(HttpServletRequest request, Map<String, Object> additions, String[] ignores, IgnoreType ignoreType) {
        if (request == null || additions == null || ignores == null || ignoreType == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        StringBuffer buffer = new StringBuffer();
        List<String> ignoreList = Arrays.asList(ignores);
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String[] values = request.getParameterValues(name);
            if (ignoreType != IgnoreType.ADDITIONS_ONLY && ignoreList.contains(name) || values == null) continue;
            for (String value : values) {
                buffer.append("<input type=\"hidden\" name=\"");
                buffer.append(WebSecurityUtils.sanitizeString((String)name));
                buffer.append("\" value=\"");
                buffer.append(WebSecurityUtils.sanitizeString((String)value));
                buffer.append("\" />");
                buffer.append("\n");
            }
        }
        for (Map.Entry<String, Object> entry : additions.entrySet()) {
            String[] stringArray;
            String name = entry.getKey();
            Object tmp = entry.getValue();
            if (tmp instanceof String[]) {
                stringArray = (String[])tmp;
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = (String)tmp;
            }
            String[] values = stringArray;
            if (ignoreType != IgnoreType.REQUEST_ONLY && ignoreList.contains(name) || values == null) continue;
            for (String value : values) {
                buffer.append("<input type=\"hidden\" name=\"");
                buffer.append(WebSecurityUtils.sanitizeString((String)name));
                buffer.append("\" value=\"");
                buffer.append(WebSecurityUtils.sanitizeString((String)value));
                buffer.append("\" />");
                buffer.append("\n");
            }
        }
        return buffer.toString();
    }

    public static String makeQueryString(HttpServletRequest request) {
        return Util.makeQueryString(request, EMPTY_MAP, EMPTY_STRING_ARRAY);
    }

    public static String makeQueryString(HttpServletRequest request, Map<String, Object> additions) {
        return Util.makeQueryString(request, additions, EMPTY_STRING_ARRAY);
    }

    public static String makeQueryString(HttpServletRequest request, String[] ignores) {
        return Util.makeQueryString(request, EMPTY_MAP, ignores);
    }

    public static String makeQueryString(HttpServletRequest request, Map<String, Object> additions, String[] ignores) {
        return Util.makeQueryString(request, additions, ignores, IgnoreType.BOTH);
    }

    public static String makeQueryString(HttpServletRequest request, Map<String, Object> additions, String[] ignores, IgnoreType ignoreType) {
        if (request == null || additions == null || ignores == null || ignoreType == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        StringBuffer buffer = new StringBuffer();
        List<String> ignoreList = Arrays.asList(ignores);
        Enumeration names = request.getParameterNames();
        while (names.hasMoreElements()) {
            String name = (String)names.nextElement();
            String[] values = request.getParameterValues(name);
            if (ignoreType != IgnoreType.ADDITIONS_ONLY && ignoreList.contains(name) || values == null) continue;
            for (int i = 0; i < values.length; ++i) {
                buffer.append("&");
                buffer.append(name);
                buffer.append("=");
                buffer.append(Util.encode(values[i]));
            }
        }
        for (Map.Entry<String, Object> entry : additions.entrySet()) {
            String[] values;
            String name = entry.getKey();
            Object tmp = entry.getValue();
            if (tmp instanceof String[]) {
                values = (String[])tmp;
            } else if (tmp instanceof String) {
                values = new String[]{(String)tmp};
            } else {
                throw new IllegalArgumentException("addition \"" + name + "\" is not of type String or String[], but is of type: " + tmp.getClass().getName());
            }
            if (ignoreType != IgnoreType.REQUEST_ONLY && ignoreList.contains(name) || values == null) continue;
            for (int i = 0; i < values.length; ++i) {
                buffer.append("&");
                buffer.append(name);
                buffer.append("=");
                buffer.append(Util.encode(values[i]));
            }
        }
        if (buffer.length() > 0 && buffer.charAt(0) == '&') {
            buffer.deleteCharAt(0);
        }
        return buffer.toString();
    }

    public static String htmlify(String input) {
        return input == null ? null : input.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
    }

    public static EventProxy createEventProxy() {
        String vaultHost = Vault.getProperty((String)"opennms.rtc.event.proxy.host");
        String vaultPort = Vault.getProperty((String)"opennms.rtc.event.proxy.port");
        String vaultTimeout = Vault.getProperty((String)"opennms.rtc.event.proxy.timeout");
        String proxyHostName = vaultHost == null ? "127.0.0.1" : vaultHost;
        String proxyHostPort = vaultPort == null ? Integer.toString(5817) : vaultPort;
        String proxyHostTimeout = vaultTimeout == null ? Integer.toString(2000) : vaultTimeout;
        InetAddress proxyAddr = null;
        TcpEventProxy proxy = null;
        proxyAddr = InetAddressUtils.addr((String)proxyHostName);
        if (proxyAddr == null) {
            try {
                proxy = new TcpEventProxy();
            }
            catch (UnknownHostException e) {
                throw new UndeclaredThrowableException(e);
            }
        } else {
            proxy = new TcpEventProxy(new InetSocketAddress(proxyAddr, Integer.parseInt(proxyHostPort)), Integer.parseInt(proxyHostTimeout));
        }
        return proxy;
    }

    public static final String formatDateToUIString(Date date) {
        if (date != null) {
            return DateFormat.getDateTimeInstance(3, 2).format(date);
        }
        return "";
    }

    public static String convertToJsSafeString(String str) {
        return str.replace("\\", "\\\\").replace("\"", "\\\"").replace("\t", "\\t").replace("\r", "\\r").replace("\n", "\\n").replace("\b", "\\b");
    }

    public static enum IgnoreType {
        REQUEST_ONLY,
        ADDITIONS_ONLY,
        BOTH;

    }
}

