/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer.support;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.opennms.netmgt.config.siteStatusViews.Category;
import org.opennms.netmgt.config.siteStatusViews.RowDef;
import org.opennms.netmgt.config.siteStatusViews.View;
import org.opennms.netmgt.dao.api.CategoryDao;
import org.opennms.netmgt.dao.api.NodeDao;
import org.opennms.netmgt.dao.api.SiteStatusViewConfigDao;
import org.opennms.netmgt.model.AggregateStatusDefinition;
import org.opennms.netmgt.model.AggregateStatusView;
import org.opennms.netmgt.model.OnmsCategory;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.web.api.Util;
import org.opennms.web.svclayer.SiteStatusViewService;
import org.opennms.web.svclayer.model.AggregateStatus;
import org.springframework.dao.DataRetrievalFailureException;
import org.springframework.orm.ObjectRetrievalFailureException;

public class DefaultSiteStatusViewService
implements SiteStatusViewService {
    private NodeDao m_nodeDao;
    private CategoryDao m_categoryDao;
    private SiteStatusViewConfigDao m_siteStatusViewConfigDao;

    @Override
    public AggregateStatusView createAggregateStatusView(String statusViewName) {
        AggregateStatusView statusView = new AggregateStatusView();
        statusViewName = statusViewName == null ? this.m_siteStatusViewConfigDao.getDefaultView().getName() : statusViewName;
        View view = this.m_siteStatusViewConfigDao.getView(statusViewName);
        statusView.setName(statusViewName);
        statusView.setColumnName(view.getColumnName());
        statusView.setColumnValue((String)view.getColumnValue().orElse(null));
        statusView.setTableName(view.getTableName());
        Set<AggregateStatusDefinition> statusDefs = this.getAggregateStatusDefinitionsForView(view);
        statusView.setStatusDefinitions(statusDefs);
        return statusView;
    }

    private Set<AggregateStatusDefinition> getAggregateStatusDefinitionsForView(View view) {
        LinkedHashSet<AggregateStatusDefinition> statusDefs = new LinkedHashSet<AggregateStatusDefinition>();
        for (RowDef rowDef : view.getRows()) {
            AggregateStatusDefinition def = new AggregateStatusDefinition();
            def.setName(rowDef.getLabel());
            def.setReportCategory(rowDef.getReportCategory());
            Set<OnmsCategory> categories = this.getCategoriesForRowDef(rowDef);
            def.setCategories(categories);
            statusDefs.add(def);
        }
        return statusDefs;
    }

    private Set<OnmsCategory> getCategoriesForRowDef(RowDef rowDef) {
        LinkedHashSet<OnmsCategory> categories = new LinkedHashSet<OnmsCategory>();
        List cats = rowDef.getCategories();
        for (Category cat : cats) {
            OnmsCategory category = this.m_categoryDao.findByName(cat.getName());
            if (category == null) {
                throw new ObjectRetrievalFailureException(OnmsCategory.class, (Object)cat.getName(), "Unable to locate OnmsCategory named: " + cat.getName() + " as specified in the site status view configuration file", null);
            }
            categories.add(category);
        }
        return categories;
    }

    @Override
    public Collection<AggregateStatus> createAggregateStatusesUsingNodeId(int nodeId, String viewName) {
        OnmsNode node = (OnmsNode)this.m_nodeDao.load((Serializable)Integer.valueOf(nodeId));
        return this.createAggregateStatuses(this.createAggregateStatusView(viewName), node.getAssetRecord().getBuilding());
    }

    @Override
    public Collection<AggregateStatus> createAggregateStatuses(AggregateStatusView statusView, String statusSite) {
        if (statusView == null) {
            throw new IllegalArgumentException("statusView argument cannot be null");
        }
        statusView.setColumnValue(statusSite);
        return this.createAggregateStatusUsingAssetColumn(statusView);
    }

    public Collection<AggregateStatus> createAggregateStatusUsingAssetColumn(AggregateStatusView statusView) {
        if (statusView == null) {
            throw new IllegalArgumentException("statusView argument cannot be null");
        }
        ArrayList<AggregateStatus> stati = new ArrayList<AggregateStatus>();
        for (AggregateStatusDefinition statusDef : statusView.getStatusDefinitions()) {
            List nodes = this.m_nodeDao.findAllByVarCharAssetColumnCategoryList(statusView.getColumnName(), statusView.getColumnValue(), (Collection)statusDef.getCategories());
            AggregateStatus status = new AggregateStatus(new HashSet<OnmsNode>(nodes));
            status.setLabel(statusDef.getName());
            status.setLink(this.createNodePageUrl(statusView, status));
            stati.add(status);
        }
        return stati;
    }

    private String createNodePageUrl(AggregateStatusView statusView, AggregateStatus status) {
        if (status.getDownEntityCount() == 0) {
            StringBuffer buf = new StringBuffer("element/nodeList.htm?");
            buf.append("statusViewName=");
            buf.append(Util.encode(statusView.getName()));
            buf.append('&');
            buf.append("statusSite=");
            buf.append(Util.encode(statusView.getColumnValue()));
            buf.append('&');
            buf.append("statusRowLabel=");
            buf.append(Util.encode(status.getLabel()));
            return buf.toString();
        }
        if (status.getDownEntityCount() == 1) {
            OnmsNode node = status.getDownNodes().iterator().next();
            StringBuffer buf = new StringBuffer("element/node.jsp?");
            buf.append("node=");
            buf.append(node.getId());
            return buf.toString();
        }
        StringBuffer buf = new StringBuffer("element/nodeList.htm?");
        buf.append("statusViewName=");
        buf.append(Util.encode(statusView.getName()));
        buf.append('&');
        buf.append("statusSite=");
        buf.append(Util.encode(statusView.getColumnValue()));
        buf.append('&');
        buf.append("statusRowLabel=");
        buf.append(Util.encode(status.getLabel()));
        buf.append('&');
        buf.append("nodesWithDownAggregateStatus=true");
        return buf.toString();
    }

    public NodeDao getNodeDao() {
        return this.m_nodeDao;
    }

    public void setNodeDao(NodeDao nodeDao) {
        this.m_nodeDao = nodeDao;
    }

    public void setCategoryDao(CategoryDao dao) {
        this.m_categoryDao = dao;
    }

    public void setSiteStatusViewConfigDao(SiteStatusViewConfigDao dao) {
        this.m_siteStatusViewConfigDao = dao;
    }

    @Override
    public Collection<AggregateStatus> createAggregateStatuses(AggregateStatusView statusView) {
        if (!"assets".equalsIgnoreCase("assets")) {
            throw new IllegalArgumentException("statusView only currently supports asset table columns");
        }
        return this.createAggregateStatusUsingAssetColumn(statusView);
    }

    @Override
    public AggregateStatus getAggregateStatus(String statusViewName, String statusSite, String rowLabel) {
        AggregateStatusView statusView = this.createAggregateStatusView(statusViewName);
        Collection<AggregateStatus> stati = this.createAggregateStatuses(statusView, statusSite);
        for (AggregateStatus status : stati) {
            if (!status.getLabel().equals(rowLabel)) continue;
            return status;
        }
        throw new DataRetrievalFailureException("Unable to locate row: " + rowLabel + " for status view: " + statusViewName);
    }

    @Override
    public Collection<OnmsNode> getNodes(String statusViewName, String statusSite, String rowLabel) {
        if (statusViewName == null) {
            statusViewName = this.m_siteStatusViewConfigDao.getDefaultView().getName();
        }
        View view = this.m_siteStatusViewConfigDao.getView(statusViewName);
        RowDef rowDef = this.getRowDef(view, rowLabel);
        Set<OnmsCategory> categories = this.getCategoriesForRowDef(rowDef);
        return this.m_nodeDao.findAllByVarCharAssetColumnCategoryList(view.getColumnName(), statusSite, categories);
    }

    private RowDef getRowDef(View view, String rowLabel) {
        for (RowDef rowDef : view.getRows()) {
            if (!rowDef.getLabel().equals(rowLabel)) continue;
            return rowDef;
        }
        throw new DataRetrievalFailureException("Unable to locate row: " + rowLabel + " for status view: " + view.getName());
    }
}

