/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer.support;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.opennms.netmgt.config.KSC_PerformanceReportFactory;
import org.opennms.netmgt.config.kscReports.Graph;
import org.opennms.netmgt.config.kscReports.Report;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.PrefabGraph;
import org.opennms.web.svclayer.api.KscReportService;
import org.opennms.web.svclayer.api.ResourceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;

public class DefaultKscReportService
implements KscReportService,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultKscReportService.class);
    private ResourceService m_resourceService;
    private KSC_PerformanceReportFactory m_kscReportFactory;
    private static final Map<String, String> s_timeSpans = new LinkedHashMap<String, String>();
    private static final Map<String, String> s_timeSpansWithNone = new LinkedHashMap<String, String>();

    @Override
    public Report buildDomainReport(String domain) {
        String resourceId = OnmsResource.createResourceId((String[])new String[]{"domain", domain});
        OnmsResource res = this.getResourceService().getResourceById(resourceId);
        return DefaultKscReportService.buildResourceReport(this.getResourceService(), res, "Domain Report for Domain " + domain);
    }

    @Override
    public Report buildNodeReport(int node_id) {
        String resourceId = OnmsResource.createResourceId((String[])new String[]{"node", Integer.toString(node_id)});
        OnmsResource node = this.getResourceService().getResourceById(resourceId);
        return DefaultKscReportService.buildResourceReport(this.getResourceService(), node, "Node Report for Node Number " + node_id);
    }

    @Override
    public Report buildNodeSourceReport(String nodeSource) {
        String resourceId = OnmsResource.createResourceId((String[])new String[]{"nodeSource", nodeSource});
        OnmsResource res = this.getResourceService().getResourceById(resourceId);
        return DefaultKscReportService.buildResourceReport(this.getResourceService(), res, "Node Report for Foreign Source:Id " + nodeSource);
    }

    private static Report buildResourceReport(ResourceService service, OnmsResource parentResource, String title) {
        Report report = new Report();
        report.setTitle(title);
        report.setShowTimespanButton(Boolean.valueOf(true));
        report.setShowGraphtypeButton(Boolean.valueOf(true));
        List<OnmsResource> resources = service.findChildResources(parentResource, "interfaceSnmp");
        for (OnmsResource resource : resources) {
            PrefabGraph[] graphs = service.findPrefabGraphsForResource(resource);
            if (graphs.length == 0) continue;
            Graph graph = new Graph();
            graph.setTitle("");
            graph.setResourceId(resource.getId());
            graph.setTimespan("7_day");
            graph.setGraphtype(graphs[0].getName());
            report.addGraph(graph);
        }
        return report;
    }

    private static String getResourceIdForGraph(Graph graph) {
        String resourceId;
        Assert.notNull((Object)graph, (String)"graph argument cannot be null");
        if (graph.getResourceId().isPresent()) {
            resourceId = (String)graph.getResourceId().get();
        } else {
            String resourceName;
            String resourceTypeName;
            String parentResourceName;
            String parentResourceTypeName;
            if (graph.getNodeId().isPresent() && !((String)graph.getNodeId().get()).equals("null")) {
                parentResourceTypeName = "node";
                parentResourceName = (String)graph.getNodeId().get();
            } else if (graph.getNodeSource().isPresent() && !((String)graph.getNodeSource().get()).equals("null")) {
                parentResourceTypeName = "nodeSource";
                parentResourceName = (String)graph.getNodeSource().get();
            } else if (graph.getDomain().isPresent() && !((String)graph.getDomain().get()).equals("null")) {
                parentResourceTypeName = "domain";
                parentResourceName = (String)graph.getDomain().get();
            } else {
                throw new IllegalArgumentException("Graph does not have a resourceId, nodeId, or domain.");
            }
            String intf = graph.getInterfaceId().orElse(null);
            if (intf == null || "".equals(intf)) {
                resourceTypeName = "nodeSnmp";
                resourceName = "";
            } else {
                resourceTypeName = "interfaceSnmp";
                resourceName = intf;
            }
            resourceId = OnmsResource.createResourceId((String[])new String[]{parentResourceTypeName, parentResourceName, resourceTypeName, resourceName});
        }
        return resourceId;
    }

    @Override
    public OnmsResource getResourceFromGraph(Graph graph) {
        return this.getResourceService().getResourceById(DefaultKscReportService.getResourceIdForGraph(graph));
    }

    private void initTimeSpans() {
        for (String timeSpan : KSC_PerformanceReportFactory.TIMESPAN_OPTIONS) {
            s_timeSpans.put(timeSpan, timeSpan);
        }
        s_timeSpansWithNone.put("none", "none");
        s_timeSpansWithNone.putAll(s_timeSpans);
    }

    @Override
    public Map<String, String> getTimeSpans(boolean includeNone) {
        if (includeNone) {
            return s_timeSpansWithNone;
        }
        return s_timeSpans;
    }

    @Override
    public Map<Integer, String> getReportList() {
        return this.m_kscReportFactory.getReportList();
    }

    public ResourceService getResourceService() {
        return this.m_resourceService;
    }

    public void setResourceService(ResourceService resourceService) {
        this.m_resourceService = resourceService;
    }

    public KSC_PerformanceReportFactory getKscReportFactory() {
        return this.m_kscReportFactory;
    }

    public void setKscReportFactory(KSC_PerformanceReportFactory kscReportFactory) {
        this.m_kscReportFactory = kscReportFactory;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.m_resourceService != null ? 1 : 0) != 0, (String)"resourceService property has not been set");
        Assert.state((this.m_kscReportFactory != null ? 1 : 0) != 0, (String)"kscReportFactory property has not been set");
        this.initTimeSpans();
    }

    @Override
    public Map<Integer, Report> getReportMap() {
        return this.m_kscReportFactory.getReportMap();
    }
}

