/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer.model;

import java.net.InetAddress;
import java.net.UnknownHostException;
import javax.xml.bind.annotation.XmlRootElement;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.SnmpEventInfo;
import org.opennms.netmgt.snmp.SnmpAgentConfig;

@XmlRootElement(name="snmp-info")
public class SnmpInfo {
    private String m_readCommunity;
    private String m_version;
    private Integer m_port;
    private Integer m_retries;
    private Integer m_timeout;
    private Integer m_maxVarsPerPdu;
    private Integer m_maxRepetitions;
    private String m_securityName;
    private Integer m_securityLevel;
    private String m_authPassPhrase;
    private String m_authProtocol;
    private String m_privPassPhrase;
    private String m_privProtocol;
    private String m_engineId;
    private String m_contextEngineId;
    private String m_contextName;
    private String m_enterpriseId;
    private Integer m_maxRequestSize;
    private String m_writeCommunity;
    private String m_proxyHost;

    public SnmpInfo() {
    }

    public SnmpInfo(SnmpAgentConfig config) {
        if (config == null) {
            return;
        }
        this.m_version = config.getVersionAsString();
        if (config.getPort() >= 1) {
            this.m_port = config.getPort();
        }
        if (config.getTimeout() >= 1) {
            this.m_timeout = config.getTimeout();
        }
        if (config.getRetries() >= 1) {
            this.m_retries = config.getRetries();
        }
        if (config.getMaxRepetitions() >= 1) {
            this.m_maxRepetitions = config.getMaxRepetitions();
        }
        if (config.getMaxVarsPerPdu() >= 1) {
            this.m_maxVarsPerPdu = config.getMaxVarsPerPdu();
        }
        if (config.getMaxRequestSize() >= 1) {
            this.m_maxRequestSize = config.getMaxRequestSize();
        }
        if (config.getProxyFor() != null) {
            this.m_proxyHost = InetAddressUtils.str((InetAddress)config.getAddress());
        }
        if (config.isVersion3()) {
            this.m_securityName = config.getSecurityName();
            this.m_securityLevel = config.getSecurityLevel();
            this.m_authPassPhrase = config.getAuthPassPhrase();
            this.m_authProtocol = config.getAuthProtocol();
            this.m_privPassPhrase = config.getPrivPassPhrase();
            this.m_privProtocol = config.getPrivProtocol();
            this.m_engineId = config.getEngineId();
            this.m_contextEngineId = config.getContextEngineId();
            this.m_contextName = config.getContextName();
            this.m_enterpriseId = config.getEnterpriseId();
        } else {
            this.m_readCommunity = config.getReadCommunity();
            this.m_writeCommunity = config.getWriteCommunity();
        }
    }

    @Deprecated
    public String getCommunity() {
        return this.getReadCommunity();
    }

    @Deprecated
    public void setCommunity(String community) {
        this.setReadCommunity(community);
    }

    public String getVersion() {
        return this.m_version;
    }

    public void setVersion(String version) {
        this.m_version = version;
    }

    public Integer getPort() {
        return this.m_port;
    }

    public void setPort(Integer port) {
        this.m_port = port;
    }

    public Integer getRetries() {
        return this.m_retries;
    }

    public void setRetries(Integer retries) {
        this.m_retries = retries;
    }

    public Integer getTimeout() {
        return this.m_timeout;
    }

    public void setTimeout(Integer timeout) {
        this.m_timeout = timeout;
    }

    public String getSecurityName() {
        return this.m_securityName;
    }

    public void setSecurityName(String securityName) {
        this.m_securityName = securityName;
    }

    public boolean hasSecurityLevel() {
        return this.m_securityLevel != null;
    }

    public boolean hasTimeout() {
        return this.m_timeout != null;
    }

    public boolean hasMaxRequestSize() {
        return this.m_maxRequestSize != null;
    }

    public boolean hasMaxRepetitions() {
        return this.m_maxRepetitions != null;
    }

    public boolean hasMaxVarsPerPdu() {
        return this.m_maxVarsPerPdu != null;
    }

    public Integer getSecurityLevel() {
        return this.m_securityLevel;
    }

    public void setSecurityLevel(Integer securityLevel) {
        this.m_securityLevel = securityLevel;
    }

    public String getAuthPassPhrase() {
        return this.m_authPassPhrase;
    }

    public void setAuthPassPhrase(String authPassPhrase) {
        this.m_authPassPhrase = authPassPhrase;
    }

    public String getAuthProtocol() {
        return this.m_authProtocol;
    }

    public void setAuthProtocol(String authProtocol) {
        this.m_authProtocol = authProtocol;
    }

    public String getPrivPassPhrase() {
        return this.m_privPassPhrase;
    }

    public void setPrivPassPhrase(String privPassPhrase) {
        this.m_privPassPhrase = privPassPhrase;
    }

    public String getPrivProtocol() {
        return this.m_privProtocol;
    }

    public void setPrivProtocol(String privProtocol) {
        this.m_privProtocol = privProtocol;
    }

    public Integer getMaxVarsPerPdu() {
        return this.m_maxVarsPerPdu;
    }

    public void setMaxVarsPerPdu(Integer maxVarsPerPdu) {
        this.m_maxVarsPerPdu = maxVarsPerPdu;
    }

    public Integer getMaxRepetitions() {
        return this.m_maxRepetitions;
    }

    public void setMaxRepetitions(Integer maxRepetitions) {
        this.m_maxRepetitions = maxRepetitions;
    }

    public String getEngineId() {
        return this.m_engineId;
    }

    public void setEngineId(String engineId) {
        this.m_engineId = engineId;
    }

    public void setContextEngineId(String contextEngineId) {
        this.m_contextEngineId = contextEngineId;
    }

    public String getContextEngineId() {
        return this.m_contextEngineId;
    }

    public void setContextName(String contextName) {
        this.m_contextName = contextName;
    }

    public String getContextName() {
        return this.m_contextName;
    }

    public void setEnterpriseId(String enterpriseId) {
        this.m_enterpriseId = enterpriseId;
    }

    public String getEnterpriseId() {
        return this.m_enterpriseId;
    }

    public String getReadCommunity() {
        return this.m_readCommunity;
    }

    public void setReadCommunity(String readCommunity) {
        this.m_readCommunity = readCommunity;
    }

    public String getWriteCommunity() {
        return this.m_writeCommunity;
    }

    public void setWriteCommunity(String writeCommunity) {
        this.m_writeCommunity = writeCommunity;
    }

    public Integer getMaxRequestSize() {
        return this.m_maxRequestSize;
    }

    public void setMaxRequestSize(Integer maxRequestSize) {
        this.m_maxRequestSize = maxRequestSize;
    }

    public String getProxyHost() {
        return this.m_proxyHost;
    }

    public void setProxyHost(String proxyHost) {
        this.m_proxyHost = proxyHost;
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public SnmpEventInfo createEventInfo(String firstIpAddress, String lastIpAddress) throws UnknownHostException {
        SnmpEventInfo eventInfo = new SnmpEventInfo();
        eventInfo.setVersion(this.m_version);
        eventInfo.setAuthPassPhrase(this.m_authPassPhrase);
        eventInfo.setAuthProtocol(this.m_authProtocol);
        eventInfo.setReadCommunityString(this.m_readCommunity);
        eventInfo.setWriteCommunityString(this.m_writeCommunity);
        eventInfo.setContextEngineId(this.m_contextEngineId);
        eventInfo.setContextName(this.m_contextName);
        eventInfo.setEngineId(this.m_engineId);
        eventInfo.setEnterpriseId(this.m_enterpriseId);
        eventInfo.setFirstIPAddress(firstIpAddress);
        eventInfo.setLastIPAddress(lastIpAddress);
        eventInfo.setPrivPassPhrase(this.m_privPassPhrase);
        eventInfo.setPrivProtocol(this.m_privProtocol);
        eventInfo.setSecurityName(this.m_securityName);
        eventInfo.setProxyHost(this.m_proxyHost);
        if (this.m_port != null) {
            eventInfo.setPort(this.m_port.intValue());
        }
        if (this.m_retries != null) {
            eventInfo.setRetryCount(this.m_retries.intValue());
        }
        if (this.m_timeout != null) {
            eventInfo.setTimeout(this.m_timeout.intValue());
        }
        if (this.m_maxRepetitions != null) {
            eventInfo.setMaxRepetitions(this.m_maxRepetitions.intValue());
        }
        if (this.m_maxVarsPerPdu != null) {
            eventInfo.setMaxVarsPerPdu(this.m_maxVarsPerPdu.intValue());
        }
        if (this.m_maxRequestSize != null) {
            eventInfo.setMaxRequestSize(this.m_maxRequestSize.intValue());
        }
        if (this.m_securityLevel != null) {
            eventInfo.setSecurityLevel(this.m_securityLevel.intValue());
        }
        if (this.m_maxRequestSize != null) {
            eventInfo.setMaxRequestSize(this.m_maxRequestSize.intValue());
        }
        return eventInfo;
    }

    public SnmpEventInfo createEventInfo(String ipAddr) throws UnknownHostException {
        return this.createEventInfo(ipAddr, null);
    }
}

