/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.servlet;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Properties;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import org.opennms.core.logging.Logging;
import org.opennms.core.resource.Vault;

public abstract class ServletInitializer {
    private ServletInitializer() {
    }

    public static synchronized void init(ServletContext context) throws ServletException {
        if (context == null) {
            throw new IllegalArgumentException("Cannot take null parameters.");
        }
        Logging.putPrefix((String)"web");
        Properties properties = new Properties(System.getProperties());
        if (properties.getProperty("opennms.home") == null) {
            throw new ServletException("The opennms.home context parameter must be set.");
        }
        String homeDir = properties.getProperty("opennms.home");
        Properties opennmsProperties = new Properties();
        try {
            ServletInitializer.loadPropertiesFromFile(opennmsProperties, homeDir + File.separator + "etc" + File.separator + "opennms.properties");
        }
        catch (IOException e) {
            throw new ServletException("Could not load opennms.properties", (Throwable)e);
        }
        try {
            ServletInitializer.loadPropertiesFromContextResource(context, opennmsProperties, "/WEB-INF/version.properties");
        }
        catch (IOException e) {
            throw new ServletException("Could not load version.properties", (Throwable)e);
        }
        for (Object key : opennmsProperties.keySet()) {
            if (properties.containsKey(key)) continue;
            properties.put(key, opennmsProperties.get(key));
        }
        for (String name : Collections.list(context.getInitParameterNames())) {
            properties.put(name, context.getInitParameter(name));
        }
        Vault.setProperties((Properties)properties);
    }

    private static void loadPropertiesFromFile(Properties opennmsProperties, String propertiesFile) throws FileNotFoundException, ServletException, IOException {
        FileInputStream configurationStream = new FileInputStream(propertiesFile);
        opennmsProperties.load(configurationStream);
        ((InputStream)configurationStream).close();
    }

    private static void loadPropertiesFromContextResource(ServletContext context, Properties properties, String propertiesResource) throws ServletException, IOException {
        InputStream configurationStream = context.getResourceAsStream(propertiesResource);
        if (configurationStream == null) {
            throw new ServletException("Could not load properties from resource '" + propertiesResource + "'");
        }
        properties.load(configurationStream);
        configurationStream.close();
    }
}

