/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.api;

import java.beans.PropertyEditorSupport;
import java.util.Date;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.ISODateTimeFormat;

public class ISO8601DateEditor
extends PropertyEditorSupport {
    static final DateTimeFormatter m_formatter = ISODateTimeFormat.dateTime().withZone(DateTimeZone.UTC);

    @Override
    public String getAsText() {
        Date date = (Date)super.getValue();
        return m_formatter.print(date.getTime());
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        Date date;
        try {
            long epoch = Long.parseLong(text);
            date = new Date(epoch);
        }
        catch (NumberFormatException e) {
            date = new Date(m_formatter.parseMillis(text));
        }
        super.setValue(date);
    }

    @Override
    public boolean isPaintable() {
        return false;
    }
}

