/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer.support;

import java.io.Serializable;
import java.net.InetAddress;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.opennms.core.utils.InetAddressUtils;
import org.opennms.netmgt.config.monitoringLocations.LocationDef;
import org.opennms.netmgt.dao.api.ApplicationDao;
import org.opennms.netmgt.dao.api.GraphDao;
import org.opennms.netmgt.dao.api.LocationMonitorDao;
import org.opennms.netmgt.dao.api.MonitoredServiceDao;
import org.opennms.netmgt.dao.api.MonitoringLocationDao;
import org.opennms.netmgt.dao.api.ResourceDao;
import org.opennms.netmgt.model.OnmsApplication;
import org.opennms.netmgt.model.OnmsLocationMonitor;
import org.opennms.netmgt.model.OnmsLocationSpecificStatus;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.PrefabGraph;
import org.opennms.netmgt.poller.PollStatus;
import org.opennms.web.api.Util;
import org.opennms.web.svclayer.DistributedStatusService;
import org.opennms.web.svclayer.model.DistributedStatusDetailsCommand;
import org.opennms.web.svclayer.model.DistributedStatusHistoryModel;
import org.opennms.web.svclayer.model.RelativeTimePeriod;
import org.opennms.web.svclayer.model.SimpleWebTable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.orm.ObjectRetrievalFailureException;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;
import org.springframework.validation.Errors;

public class DefaultDistributedStatusService
implements DistributedStatusService,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultDistributedStatusService.class);
    private MonitoredServiceDao m_monitoredServiceDao;
    private MonitoringLocationDao m_monitoringLocationDao;
    private LocationMonitorDao m_locationMonitorDao;
    private ApplicationDao m_applicationDao;
    private ResourceDao m_resourceDao;
    private GraphDao m_graphDao;
    private boolean m_layoutApplicationsVertically = false;
    private static final MonitoredServiceComparator MONITORED_SERVICE_COMPARATOR = new MonitoredServiceComparator();
    private static final ServiceGraphComparator SERVICE_GRAPH_COMPARATOR = new ServiceGraphComparator();
    private static final LocationStatusComparator LOCATION_STATUS_COMPARATOR = new LocationStatusComparator();
    private static final PollStatus NO_RECORDED_STATUS = PollStatus.unknown((String)"No status recorded for this service from this location");

    @Override
    public int getApplicationCount() {
        return this.m_applicationDao.countAll();
    }

    @Override
    public SimpleWebTable createStatusTable(DistributedStatusDetailsCommand command, Errors errors) {
        SimpleWebTable table = new SimpleWebTable();
        table.setErrors(errors);
        if (table.getErrors().hasErrors()) {
            return table;
        }
        table.setTitle("Distributed status view for " + command.getApplication() + " from " + command.getLocation() + " location");
        List<OnmsLocationSpecificStatus> status = this.findLocationSpecificStatus(command, table.getErrors());
        if (status == null) {
            return table;
        }
        table.addColumn("Node", "");
        table.addColumn("Monitor", "");
        table.addColumn("Service", "");
        table.addColumn("Status", "");
        table.addColumn("Response", "");
        table.addColumn("Last Status Change", "");
        table.addColumn("Last Update", "");
        TreeSet<OnmsLocationSpecificStatus> sortedStatus = new TreeSet<OnmsLocationSpecificStatus>(LOCATION_STATUS_COMPARATOR);
        sortedStatus.addAll(status);
        for (OnmsLocationSpecificStatus s : sortedStatus) {
            table.newRow();
            table.addCell(s.getMonitoredService().getIpInterface().getNode().getLabel(), this.getStyleForPollResult(s.getPollResult()), "element/node.jsp?node=" + s.getMonitoredService().getIpInterface().getNode().getId());
            table.addCell(s.getLocationMonitor().getLocation() + "-" + s.getLocationMonitor().getId(), "", "distributed/locationMonitorDetails.htm?monitorId=" + s.getLocationMonitor().getId());
            table.addCell(s.getMonitoredService().getServiceName(), "", "element/service.jsp?ifserviceid=" + s.getMonitoredService().getId());
            table.addCell(s.getPollResult().getStatusName(), "bright");
            table.addCell(this.getResponseText(s.getPollResult()), "");
            table.addCell(this.reDateify(s.getPollResult().getTimestamp()), "");
            table.addCell(this.reDateify(s.getLocationMonitor().getLastUpdated()), "");
        }
        return table;
    }

    private String getStyleForPollResult(PollStatus status) {
        if (status.isAvailable()) {
            return "Normal";
        }
        if (status.isUnresponsive()) {
            return "Warning";
        }
        if (status.isUnknown()) {
            return "Indeterminate";
        }
        return "Critical";
    }

    private String getResponseText(PollStatus status) {
        if (status.isAvailable()) {
            Double responseTime = status.getResponseTime();
            if (responseTime != null && responseTime >= 0.0) {
                return responseTime + "ms";
            }
            return "";
        }
        return status.getReason();
    }

    private Date reDateify(Date date) {
        if (date == null) {
            return null;
        }
        return new Date(date.getTime());
    }

    protected List<OnmsLocationSpecificStatus> findLocationSpecificStatus(DistributedStatusDetailsCommand command, Errors errors) throws IllegalArgumentException {
        String locationName = command.getLocation();
        String applicationName = command.getApplication();
        Assert.notNull((Object)locationName, (String)"location cannot be null");
        Assert.notNull((Object)applicationName, (String)"application cannot be null");
        LocationDef location = (LocationDef)this.m_monitoringLocationDao.get((Serializable)((Object)locationName));
        if (location == null) {
            throw new IllegalArgumentException("Could not find location for location name \"" + locationName + "\"");
        }
        OnmsApplication application = this.m_applicationDao.findByName(applicationName);
        if (application == null) {
            throw new IllegalArgumentException("Could not find application for application name \"" + applicationName + "\"");
        }
        Collection locationMonitors = this.m_locationMonitorDao.findByLocationDefinition(location);
        if (locationMonitors.size() == 0) {
            errors.reject("location.no-monitors", new Object[]{applicationName, locationName}, "No remote pollers have registered for this application and location");
            return null;
        }
        ArrayList sortedLocationMonitors = new ArrayList(locationMonitors);
        Collections.sort(sortedLocationMonitors);
        Set services = this.m_monitoredServiceDao.findByApplication(application);
        ArrayList sortedServices = new ArrayList(services);
        Collections.sort(sortedServices);
        LinkedList<OnmsLocationSpecificStatus> status = new LinkedList<OnmsLocationSpecificStatus>();
        for (OnmsMonitoredService service : sortedServices) {
            for (OnmsLocationMonitor locationMonitor : sortedLocationMonitors) {
                OnmsLocationSpecificStatus currentStatus = this.m_locationMonitorDao.getMostRecentStatusChange(locationMonitor, service);
                if (currentStatus == null) {
                    status.add(new OnmsLocationSpecificStatus(locationMonitor, service, NO_RECORDED_STATUS));
                    continue;
                }
                status.add(currentStatus);
            }
        }
        return status;
    }

    @Override
    public SimpleWebTable createFacilityStatusTable(Date start, Date end) {
        Assert.notNull((Object)start, (String)"argument start cannot be null");
        Assert.notNull((Object)end, (String)"argument end cannot be null");
        if (!start.before(end)) {
            throw new IllegalArgumentException("start date (" + start + ") must be older than end date (" + end + ")");
        }
        SimpleWebTable table = new SimpleWebTable();
        List locationDefinitions = this.m_monitoringLocationDao.findAll();
        List applications = this.m_applicationDao.findAll();
        if (applications.size() == 0) {
            throw new IllegalArgumentException("there are no applications");
        }
        ArrayList sortedApplications = new ArrayList(applications);
        Collections.sort(sortedApplications);
        Collection mostRecentStatuses = this.m_locationMonitorDao.getAllMostRecentStatusChanges();
        HashSet<OnmsLocationSpecificStatus> statusesPeriod = new HashSet<OnmsLocationSpecificStatus>();
        statusesPeriod.addAll(this.m_locationMonitorDao.getAllStatusChangesAt(start));
        statusesPeriod.addAll(this.m_locationMonitorDao.getStatusChangesBetween(start, end));
        table.setTitle("Distributed Status Summary");
        table.addColumn("Area", "");
        table.addColumn("Location", "");
        for (OnmsApplication application : sortedApplications) {
            table.addColumn(application.getName(), "");
        }
        for (LocationDef locationDefinition : locationDefinitions) {
            Collection monitors = this.m_locationMonitorDao.findByLocationDefinition(locationDefinition);
            table.newRow();
            table.addCell(locationDefinition.getMonitoringArea(), "");
            table.addCell(locationDefinition.getLocationName(), "");
            for (OnmsApplication application : sortedApplications) {
                Set memberServices = this.m_monitoredServiceDao.findByApplication(application);
                Severity status = this.calculateCurrentStatus(monitors, (Collection<OnmsMonitoredService>)memberServices, (Collection<OnmsLocationSpecificStatus>)mostRecentStatuses);
                Set<OnmsLocationSpecificStatus> selectedStatuses = this.filterStatus(statusesPeriod, monitors, memberServices);
                if (selectedStatuses.size() > 0) {
                    String percentage = this.calculatePercentageUptime(memberServices, selectedStatuses, start, end);
                    table.addCell(percentage, status.getStyle(), this.createHistoryPageUrl(locationDefinition, application));
                    continue;
                }
                table.addCell("No data", status.getStyle());
            }
        }
        if (this.isLayoutApplicationsVertically()) {
            SimpleWebTable newTable = new SimpleWebTable();
            newTable.setErrors(table.getErrors());
            newTable.setTitle(table.getTitle());
            newTable.addColumn("Application");
            for (List<SimpleWebTable.Cell> row : table.getRows()) {
                newTable.addColumn(row.get(1).getContent(), row.get(1).getStyleClass());
            }
            for (SimpleWebTable.Cell columnHeader : table.getColumnHeaders().subList(2, table.getColumnHeaders().size())) {
                int rowColumnIndex = newTable.getRows().size() + 2;
                newTable.newRow();
                newTable.addCell(columnHeader.getContent(), columnHeader.getStyleClass());
                for (List<SimpleWebTable.Cell> row : table.getRows()) {
                    newTable.addCell(row.get(rowColumnIndex).getContent(), row.get(rowColumnIndex).getStyleClass(), row.get(rowColumnIndex).getLink());
                }
            }
            return newTable;
        }
        return table;
    }

    private Set<OnmsLocationSpecificStatus> filterStatus(Collection<OnmsLocationSpecificStatus> statuses, Collection<OnmsLocationMonitor> monitors, Collection<OnmsMonitoredService> services) {
        HashSet<OnmsLocationSpecificStatus> filteredStatuses = new HashSet<OnmsLocationSpecificStatus>();
        for (OnmsLocationSpecificStatus status : statuses) {
            if (!monitors.contains(status.getLocationMonitor()) || !services.contains(status.getMonitoredService())) continue;
            filteredStatuses.add(status);
        }
        return filteredStatuses;
    }

    public Severity calculateCurrentStatus(Collection<OnmsLocationMonitor> monitors, Collection<OnmsMonitoredService> applicationServices, Collection<OnmsLocationSpecificStatus> statuses) {
        int goodMonitors = 0;
        int badMonitors = 0;
        for (OnmsLocationMonitor monitor : monitors) {
            if (monitor == null || monitor.getStatus() != OnmsLocationMonitor.MonitorStatus.STARTED) continue;
            Severity status = this.calculateCurrentStatus(monitor, applicationServices, statuses);
            if (status == Severity.NORMAL) {
                ++goodMonitors;
                continue;
            }
            if (status == Severity.INDETERMINATE) continue;
            ++badMonitors;
        }
        if (goodMonitors == 0 && badMonitors == 0) {
            return Severity.INDETERMINATE;
        }
        if (goodMonitors != 0 && badMonitors == 0) {
            return Severity.NORMAL;
        }
        if (goodMonitors == 0 && badMonitors != 0) {
            return Severity.CRITICAL;
        }
        if (goodMonitors != 0 && badMonitors != 0) {
            return Severity.WARNING;
        }
        throw new IllegalStateException("Shouldn't have gotten here. good monitors = " + goodMonitors + ", bad monitors = " + badMonitors);
    }

    public Severity calculateCurrentStatus(OnmsLocationMonitor monitor, Collection<OnmsMonitoredService> applicationServices, Collection<OnmsLocationSpecificStatus> statuses) {
        HashSet<PollStatus> pollStatuses = new HashSet<PollStatus>();
        for (OnmsMonitoredService service : applicationServices) {
            boolean foundIt = false;
            for (OnmsLocationSpecificStatus status : statuses) {
                if (!status.getMonitoredService().equals(service) || !status.getLocationMonitor().equals(monitor)) continue;
                pollStatuses.add(status.getPollResult());
                foundIt = true;
                break;
            }
            if (foundIt) continue;
            pollStatuses.add(PollStatus.unknown((String)"No status found for this service"));
            LOG.debug("Did not find status for service {} in application.  Setting status for it to unknown.", (Object)service);
        }
        return this.calculateStatus(pollStatuses);
    }

    public Severity calculateStatus(Collection<PollStatus> pollStatuses) {
        int goodStatuses = 0;
        int badStatuses = 0;
        for (PollStatus pollStatus : pollStatuses) {
            if (pollStatus.isAvailable()) {
                ++goodStatuses;
                continue;
            }
            if (pollStatus.isUnknown()) continue;
            ++badStatuses;
        }
        if (goodStatuses == 0 && badStatuses == 0) {
            return Severity.INDETERMINATE;
        }
        if (goodStatuses > 0 && badStatuses == 0) {
            return Severity.NORMAL;
        }
        return Severity.CRITICAL;
    }

    public String calculatePercentageUptime(Collection<OnmsMonitoredService> applicationServices, Collection<OnmsLocationSpecificStatus> statuses, Date startDate, Date endDate) {
        OnmsLocationSpecificStatus status;
        Date currentDate;
        LinkedList<OnmsLocationSpecificStatus> sortedStatuses = new LinkedList<OnmsLocationSpecificStatus>(statuses);
        Collections.sort(sortedStatuses, new Comparator<OnmsLocationSpecificStatus>(){

            @Override
            public int compare(OnmsLocationSpecificStatus o1, OnmsLocationSpecificStatus o2) {
                return o1.getPollResult().getTimestamp().compareTo(o2.getPollResult().getTimestamp());
            }
        });
        HashMap<OnmsMonitoredService, PollStatus> serviceStatus = new HashMap<OnmsMonitoredService, PollStatus>();
        for (OnmsMonitoredService service : applicationServices) {
            serviceStatus.put(service, PollStatus.unknown((String)"No history for this service from this location"));
        }
        float normalMilliseconds = 0.0f;
        Date lastDate = startDate;
        Severity lastStatus = Severity.CRITICAL;
        Iterator iterator = sortedStatuses.iterator();
        while (iterator.hasNext() && (currentDate = (status = (OnmsLocationSpecificStatus)iterator.next()).getPollResult().getTimestamp()).before(endDate)) {
            serviceStatus.put(status.getMonitoredService(), status.getPollResult());
            Severity currentStatus = this.calculateStatus(serviceStatus.values());
            if (currentDate.before(startDate)) {
                lastStatus = currentStatus;
                continue;
            }
            if (lastStatus == Severity.NORMAL) {
                long milliseconds = currentDate.getTime() - lastDate.getTime();
                normalMilliseconds += (float)milliseconds;
            }
            lastDate = currentDate;
            lastStatus = currentStatus;
        }
        if (lastStatus == Severity.NORMAL) {
            long milliseconds = endDate.getTime() - lastDate.getTime();
            normalMilliseconds += (float)milliseconds;
        }
        float percentage = normalMilliseconds / (float)(endDate.getTime() - startDate.getTime()) * 100.0f;
        return new DecimalFormat("0.000").format(percentage) + "%";
    }

    private String createHistoryPageUrl(LocationDef locationDefinition, OnmsApplication application) {
        ArrayList<String> params = new ArrayList<String>(2);
        params.add("location=" + Util.encode(locationDefinition.getLocationName()));
        params.add("application=" + Util.encode(application.getName()));
        return "distributedStatusHistory.htm?" + StringUtils.collectionToDelimitedString(params, (String)"&");
    }

    @Override
    public DistributedStatusHistoryModel createHistoryModel(String locationName, String monitorId, String applicationName, String timeSpan, String previousLocationName) {
        LinkedList<String> errors = new LinkedList<String>();
        List locationDefinitions = this.m_monitoringLocationDao.findAll();
        List<RelativeTimePeriod> periods = Arrays.asList(RelativeTimePeriod.getDefaultPeriods());
        List applications = this.m_applicationDao.findAll();
        ArrayList<OnmsApplication> sortedApplications = new ArrayList<OnmsApplication>(applications);
        Collections.sort(sortedApplications);
        LocationDef location = new LocationDef();
        if (locationName == null) {
            if (!locationDefinitions.isEmpty()) {
                location = (LocationDef)locationDefinitions.get(0);
            }
        } else {
            location = (LocationDef)this.m_monitoringLocationDao.get((Serializable)((Object)locationName));
            if (location == null) {
                errors.add("Could not find location definition '" + locationName + "'");
                if (!locationDefinitions.isEmpty()) {
                    location = (LocationDef)locationDefinitions.get(0);
                }
            }
        }
        OnmsApplication application = new OnmsApplication();
        if (applicationName == null) {
            if (!sortedApplications.isEmpty()) {
                application = (OnmsApplication)sortedApplications.get(0);
            }
        } else {
            application = this.m_applicationDao.findByName(applicationName);
            if (application == null) {
                errors.add("Could not find application '" + applicationName + "'");
                if (!sortedApplications.isEmpty()) {
                    application = (OnmsApplication)sortedApplications.get(0);
                }
            }
        }
        Collection monitors = this.m_locationMonitorDao.findByLocationDefinition(location);
        LinkedList<OnmsLocationMonitor> sortedMonitors = new LinkedList<OnmsLocationMonitor>(monitors);
        Collections.sort(sortedMonitors);
        OnmsLocationMonitor monitor = null;
        if (monitorId != null && !"".equals(monitorId.trim()) && location.getLocationName().equals(previousLocationName)) {
            for (OnmsLocationMonitor m : sortedMonitors) {
                if (!m.getId().equals(monitorId)) continue;
                monitor = m;
                break;
            }
        }
        if (monitor == null && !sortedMonitors.isEmpty()) {
            monitor = (OnmsLocationMonitor)sortedMonitors.get(0);
        }
        RelativeTimePeriod period = RelativeTimePeriod.getPeriodByIdOrDefault(timeSpan);
        Set memberServices = this.m_monitoredServiceDao.findByApplication(application);
        for (OnmsMonitoredService service : memberServices) {
            this.m_locationMonitorDao.initialize((Object)service.getIpInterface());
            this.m_locationMonitorDao.initialize((Object)service.getIpInterface().getNode());
        }
        Set applicationMemberServices = this.m_monitoredServiceDao.findByApplication(application);
        if (applicationMemberServices.isEmpty()) {
            errors.add("There are no services in the application '" + applicationName + "'");
        }
        DistributedStatusHistoryModel model = new DistributedStatusHistoryModel(locationDefinitions, sortedApplications, sortedMonitors, periods, location, application, applicationMemberServices, monitor, period, errors);
        this.initializeGraphUrls(model);
        return model;
    }

    private void initializeGraphUrls(DistributedStatusHistoryModel model) {
        if (model.getChosenMonitor() != null) {
            Collection<OnmsMonitoredService> services = model.getChosenApplicationMemberServices();
            long[] times = model.getChosenPeriod().getStartAndEndTimes();
            TreeSet<DistributedStatusHistoryModel.ServiceGraph> serviceGraphs = new TreeSet<DistributedStatusHistoryModel.ServiceGraph>(SERVICE_GRAPH_COMPARATOR);
            for (OnmsMonitoredService service : services) {
                serviceGraphs.add(this.getServiceGraphForService(model.getChosenMonitor(), service, times));
            }
            model.setServiceGraphs(serviceGraphs);
        }
    }

    private DistributedStatusHistoryModel.ServiceGraph getServiceGraphForService(OnmsLocationMonitor locMon, OnmsMonitoredService service, long[] times) {
        PrefabGraph[] prefabGraphs;
        OnmsResource resource;
        try {
            resource = this.m_resourceDao.getResourceForIpInterface(service.getIpInterface(), locMon);
        }
        catch (ObjectRetrievalFailureException e) {
            resource = null;
        }
        if (resource == null) {
            return new DistributedStatusHistoryModel.ServiceGraph(service, new String[]{"Resource could not be found.  Has any response time data been collected for this service from this remote poller?"});
        }
        String graphName = service.getServiceName().toLowerCase();
        try {
            this.m_graphDao.getPrefabGraph(graphName);
        }
        catch (ObjectRetrievalFailureException e) {
            return new DistributedStatusHistoryModel.ServiceGraph(service, new String[]{"Graph definition could not be found for '" + graphName + "'.  A graph definition needs to be created for this service."});
        }
        for (PrefabGraph graph : prefabGraphs = this.m_graphDao.getPrefabGraphsForResource(resource)) {
            if (!graph.getName().equals(graphName)) continue;
            String url = "graph/graph.png?report=" + Util.encode(graph.getName()) + "&resourceId=" + Util.encode(resource.getId()) + "&start=" + times[0] + "&end=" + times[1];
            return new DistributedStatusHistoryModel.ServiceGraph(service, url);
        }
        return new DistributedStatusHistoryModel.ServiceGraph(service, new String[]{"Graph could not be found for '" + graphName + "' on this resource.  Has any response time data been collected for this service from this remote poller and is the graph definition correct?"});
    }

    public void afterPropertiesSet() throws Exception {
        Assert.state((this.m_monitoredServiceDao != null ? 1 : 0) != 0, (String)"property monitoredServiceDao cannot be null");
        Assert.state((this.m_locationMonitorDao != null ? 1 : 0) != 0, (String)"property locationMonitorDao cannot be null");
        Assert.state((this.m_applicationDao != null ? 1 : 0) != 0, (String)"property applicationDao cannot be null");
        Assert.state((this.m_resourceDao != null ? 1 : 0) != 0, (String)"property resourceDao cannot be null");
        Assert.state((this.m_graphDao != null ? 1 : 0) != 0, (String)"property graphDao cannot be null");
    }

    public void setMonitoredServiceDao(MonitoredServiceDao monitoredServiceDao) {
        this.m_monitoredServiceDao = monitoredServiceDao;
    }

    public void setMonitoringLocationDao(MonitoringLocationDao monitoringLocationDao) {
        this.m_monitoringLocationDao = monitoringLocationDao;
    }

    public void setLocationMonitorDao(LocationMonitorDao locationMonitorDao) {
        this.m_locationMonitorDao = locationMonitorDao;
    }

    public void setApplicationDao(ApplicationDao applicationDao) {
        this.m_applicationDao = applicationDao;
    }

    public ResourceDao getResourceDao() {
        return this.m_resourceDao;
    }

    public void setResourceDao(ResourceDao resourceDao) {
        this.m_resourceDao = resourceDao;
    }

    public GraphDao getGraphDao() {
        return this.m_graphDao;
    }

    public void setGraphDao(GraphDao graphDao) {
        this.m_graphDao = graphDao;
    }

    public void setLayoutApplicationsVertically(boolean layoutApplicationsVertically) {
        this.m_layoutApplicationsVertically = layoutApplicationsVertically;
    }

    public boolean isLayoutApplicationsVertically() {
        return this.m_layoutApplicationsVertically;
    }

    static {
        NO_RECORDED_STATUS.setTimestamp(null);
    }

    public static class LocationStatusComparator
    implements Comparator<OnmsLocationSpecificStatus>,
    Serializable {
        private static final long serialVersionUID = -5854706886193427256L;

        @Override
        public int compare(OnmsLocationSpecificStatus o1, OnmsLocationSpecificStatus o2) {
            if (o1.getPollResult().isUnknown() && o2.getPollResult().isUnknown() || !o1.getPollResult().isUnknown() && !o2.getPollResult().isUnknown()) {
                return o1.getMonitoredService().compareTo(o2.getMonitoredService());
            }
            if (o1.getPollResult().isUnknown()) {
                return 1;
            }
            return -1;
        }
    }

    public static class ServiceGraphComparator
    implements Comparator<DistributedStatusHistoryModel.ServiceGraph>,
    Serializable {
        private static final long serialVersionUID = -1365958323886041945L;

        @Override
        public int compare(DistributedStatusHistoryModel.ServiceGraph o1, DistributedStatusHistoryModel.ServiceGraph o2) {
            if (o1.getErrors().length == 0 && o2.getErrors().length == 0 || o1.getErrors().length > 0 && o2.getErrors().length > 0) {
                return MONITORED_SERVICE_COMPARATOR.compare(o1.getService(), o2.getService());
            }
            if (o1.getErrors().length > 0) {
                return 1;
            }
            return -1;
        }
    }

    public static class MonitoredServiceComparator
    implements Comparator<OnmsMonitoredService>,
    Serializable {
        private static final long serialVersionUID = 3000643751074224389L;

        @Override
        public int compare(OnmsMonitoredService o1, OnmsMonitoredService o2) {
            int diff = o1.getIpInterface().getNode().getLabel().compareToIgnoreCase(o2.getIpInterface().getNode().getLabel());
            if (diff != 0) {
                return diff;
            }
            diff = InetAddressUtils.toInteger((InetAddress)o1.getIpAddress()).compareTo(InetAddressUtils.toInteger((InetAddress)o2.getIpAddress()));
            if (diff != 0) {
                return diff;
            }
            return o1.getServiceName().compareToIgnoreCase(o2.getServiceName());
        }
    }

    public static enum Severity {
        INDETERMINATE("Indeterminate"),
        NORMAL("Normal"),
        WARNING("Warning"),
        CRITICAL("Critical");

        private final String m_style;

        private Severity(String style) {
            this.m_style = style;
        }

        public String getStyle() {
            return this.m_style;
        }
    }
}

