/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer.support;

import java.io.Serializable;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.opennms.netmgt.config.monitoringLocations.LocationDef;
import org.opennms.netmgt.dao.api.LocationMonitorDao;
import org.opennms.netmgt.dao.api.MonitoringLocationDao;
import org.opennms.netmgt.model.OnmsLocationMonitor;
import org.opennms.web.svclayer.DistributedPollerService;
import org.opennms.web.svclayer.model.LocationMonitorIdCommand;
import org.opennms.web.svclayer.model.LocationMonitorListModel;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.validation.ObjectError;

public class DefaultDistributedPollerService
implements DistributedPollerService {
    private MonitoringLocationDao m_monitoringLocationDao;
    private LocationMonitorDao m_locationMonitorDao;
    private OnmsLocationMonitorAreaNameComparator m_comparator = new OnmsLocationMonitorAreaNameComparator();

    @Override
    public LocationMonitorListModel getLocationMonitorList() {
        List monitors = this.m_locationMonitorDao.findAll();
        Collections.sort(monitors, this.m_comparator);
        LocationMonitorListModel model = new LocationMonitorListModel();
        for (OnmsLocationMonitor monitor : monitors) {
            LocationDef def = (LocationDef)this.m_monitoringLocationDao.get((Serializable)((Object)monitor.getLocation()));
            model.addLocationMonitor(new LocationMonitorListModel.LocationMonitorModel(monitor, def));
        }
        return model;
    }

    public LocationMonitorDao getLocationMonitorDao() {
        return this.m_locationMonitorDao;
    }

    public void setMonitoringLocationDao(MonitoringLocationDao monitoringLocationDao) {
        this.m_monitoringLocationDao = monitoringLocationDao;
    }

    public void setLocationMonitorDao(LocationMonitorDao locationMonitorDao) {
        this.m_locationMonitorDao = locationMonitorDao;
    }

    @Override
    public LocationMonitorListModel getLocationMonitorDetails(LocationMonitorIdCommand cmd, BindingResult errors) {
        LocationMonitorListModel model = new LocationMonitorListModel();
        model.setErrors((Errors)errors);
        if (errors.getErrorCount() > 0) {
            return model;
        }
        OnmsLocationMonitor monitor = (OnmsLocationMonitor)this.m_locationMonitorDao.load((Serializable)((Object)cmd.getMonitorId()));
        LocationDef def = (LocationDef)this.m_monitoringLocationDao.get((Serializable)((Object)monitor.getLocation()));
        model.addLocationMonitor(new LocationMonitorListModel.LocationMonitorModel(monitor, def));
        return model;
    }

    @Override
    public void pauseLocationMonitor(LocationMonitorIdCommand command, BindingResult errors) {
        if (command == null) {
            throw new IllegalStateException("command argument cannot be null");
        }
        if (errors == null) {
            throw new IllegalStateException("errors argument cannot be null");
        }
        if (errors.hasErrors()) {
            return;
        }
        OnmsLocationMonitor monitor = (OnmsLocationMonitor)this.m_locationMonitorDao.load((Serializable)((Object)command.getMonitorId()));
        if (monitor.getStatus() == OnmsLocationMonitor.MonitorStatus.PAUSED) {
            errors.addError(new ObjectError(OnmsLocationMonitor.MonitorStatus.class.getName(), new String[]{"distributed.locationMonitor.alreadyPaused"}, new Object[]{command.getMonitorId()}, "Location monitor " + command.getMonitorId() + " is already paused."));
            return;
        }
        monitor.setStatus(OnmsLocationMonitor.MonitorStatus.PAUSED);
        this.m_locationMonitorDao.update((Object)monitor);
    }

    @Override
    public void resumeLocationMonitor(LocationMonitorIdCommand command, BindingResult errors) {
        if (command == null) {
            throw new IllegalStateException("command argument cannot be null");
        }
        if (errors == null) {
            throw new IllegalStateException("errors argument cannot be null");
        }
        if (errors.hasErrors()) {
            return;
        }
        OnmsLocationMonitor monitor = (OnmsLocationMonitor)this.m_locationMonitorDao.load((Serializable)((Object)command.getMonitorId()));
        if (monitor.getStatus() != OnmsLocationMonitor.MonitorStatus.PAUSED) {
            errors.addError(new ObjectError(OnmsLocationMonitor.MonitorStatus.class.getName(), new String[]{"distributed.locationMonitor.notPaused"}, new Object[]{command.getMonitorId()}, "Location monitor " + command.getMonitorId() + " is not paused."));
            return;
        }
        monitor.setStatus(OnmsLocationMonitor.MonitorStatus.STARTED);
        this.m_locationMonitorDao.update((Object)monitor);
    }

    @Override
    public void deleteLocationMonitor(LocationMonitorIdCommand command, BindingResult errors) {
        if (command == null) {
            throw new IllegalStateException("command argument cannot be null");
        }
        if (errors == null) {
            throw new IllegalStateException("errors argument cannot be null");
        }
        if (errors.hasErrors()) {
            return;
        }
        OnmsLocationMonitor monitor = (OnmsLocationMonitor)this.m_locationMonitorDao.load((Serializable)((Object)command.getMonitorId()));
        this.m_locationMonitorDao.delete((Object)monitor);
    }

    @Override
    public void pauseAllLocationMonitors() {
        this.m_locationMonitorDao.pauseAll();
    }

    @Override
    public void resumeAllLocationMonitors() {
        this.m_locationMonitorDao.resumeAll();
    }

    public class OnmsLocationMonitorAreaNameComparator
    implements Comparator<OnmsLocationMonitor> {
        @Override
        public int compare(OnmsLocationMonitor o1, OnmsLocationMonitor o2) {
            int diff;
            LocationDef def1 = null;
            LocationDef def2 = null;
            if (o1.getLocation() != null) {
                def1 = (LocationDef)DefaultDistributedPollerService.this.m_monitoringLocationDao.get((Serializable)((Object)o1.getLocation()));
            }
            if (o2.getLocation() != null) {
                def2 = (LocationDef)DefaultDistributedPollerService.this.m_monitoringLocationDao.get((Serializable)((Object)o2.getLocation()));
            }
            if ((def1 == null || def1.getMonitoringArea() == null) && def2 != null && def2.getMonitoringArea() != null) {
                return 1;
            }
            if (def1 != null && def1.getMonitoringArea() != null && (def2 == null || def2.getMonitoringArea() == null)) {
                return -1;
            }
            if (def1 != null && def1.getMonitoringArea() != null && def2 != null && def2.getMonitoringArea() != null && (diff = def1.getMonitoringArea().compareToIgnoreCase(def1.getMonitoringArea())) != 0) {
                return diff;
            }
            diff = o1.getLocation().compareToIgnoreCase(o2.getLocation());
            if (diff != 0) {
                return diff;
            }
            return o1.getId().compareTo(o2.getId());
        }
    }
}

