/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer.support;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import javax.ws.rs.core.MultivaluedMap;
import org.opennms.netmgt.events.api.EventProxy;
import org.opennms.netmgt.events.api.EventProxyException;
import org.opennms.netmgt.model.events.EventBuilder;
import org.opennms.netmgt.provision.persist.ForeignSourceRepository;
import org.opennms.netmgt.provision.persist.RequisitionFileUtils;
import org.opennms.netmgt.provision.persist.requisition.Requisition;
import org.opennms.netmgt.provision.persist.requisition.RequisitionAsset;
import org.opennms.netmgt.provision.persist.requisition.RequisitionAssetCollection;
import org.opennms.netmgt.provision.persist.requisition.RequisitionCategory;
import org.opennms.netmgt.provision.persist.requisition.RequisitionCategoryCollection;
import org.opennms.netmgt.provision.persist.requisition.RequisitionCollection;
import org.opennms.netmgt.provision.persist.requisition.RequisitionInterface;
import org.opennms.netmgt.provision.persist.requisition.RequisitionInterfaceCollection;
import org.opennms.netmgt.provision.persist.requisition.RequisitionMonitoredService;
import org.opennms.netmgt.provision.persist.requisition.RequisitionMonitoredServiceCollection;
import org.opennms.netmgt.provision.persist.requisition.RequisitionNode;
import org.opennms.netmgt.provision.persist.requisition.RequisitionNodeCollection;
import org.opennms.web.api.RestUtils;
import org.opennms.web.svclayer.api.RequisitionAccessService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.dao.DataAccessResourceFailureException;

public class DefaultRequisitionAccessService
implements RequisitionAccessService {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultRequisitionAccessService.class);
    @Autowired
    @Qualifier(value="pending")
    private ForeignSourceRepository m_pendingForeignSourceRepository;
    @Autowired
    @Qualifier(value="deployed")
    private ForeignSourceRepository m_deployedForeignSourceRepository;
    @Autowired
    @Qualifier(value="eventProxy")
    private EventProxy m_eventProxy;
    private final ExecutorService m_executor = Executors.newSingleThreadExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "Requisition-Accessor-Thread");
        }
    });
    private final Map<String, RequisitionAccessor> m_accessors = new HashMap<String, RequisitionAccessor>();

    private RequisitionAccessor getAccessor(String foreignSource) {
        RequisitionAccessor accessor = this.m_accessors.get(foreignSource);
        if (accessor == null) {
            accessor = new RequisitionAccessor(foreignSource, this.m_pendingForeignSourceRepository, this.m_deployedForeignSourceRepository);
            this.m_accessors.put(foreignSource, accessor);
        }
        return accessor;
    }

    @Override
    public void flushAll() {
        for (RequisitionAccessor accessor : this.m_accessors.values()) {
            accessor.flush();
        }
    }

    private ForeignSourceRepository getPendingForeignSourceRepository() {
        return this.m_pendingForeignSourceRepository;
    }

    private ForeignSourceRepository getDeployedForeignSourceRepository() {
        return this.m_deployedForeignSourceRepository;
    }

    private EventProxy getEventProxy() {
        return this.m_eventProxy;
    }

    private <T> T submitAndWait(Callable<T> callable) {
        try {
            return this.m_executor.submit(callable).get();
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }

    private Future<?> submitWriteOp(Runnable r) {
        return this.m_executor.submit(r);
    }

    @Override
    public int getDeployedCount() {
        return this.submitAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                DefaultRequisitionAccessService.this.flushAll();
                return DefaultRequisitionAccessService.this.getDeployedForeignSourceRepository().getRequisitions().size();
            }
        });
    }

    @Override
    public RequisitionCollection getDeployedRequisitions() {
        return this.submitAndWait(new Callable<RequisitionCollection>(){

            @Override
            public RequisitionCollection call() throws Exception {
                DefaultRequisitionAccessService.this.flushAll();
                return new RequisitionCollection((Collection)DefaultRequisitionAccessService.this.getDeployedForeignSourceRepository().getRequisitions());
            }
        });
    }

    @Override
    public RequisitionCollection getRequisitions() {
        return this.submitAndWait(new Callable<RequisitionCollection>(){

            @Override
            public RequisitionCollection call() throws Exception {
                DefaultRequisitionAccessService.this.flushAll();
                TreeSet<Requisition> reqs = new TreeSet<Requisition>();
                Set fsNames = DefaultRequisitionAccessService.this.getPendingForeignSourceRepository().getActiveForeignSourceNames();
                fsNames.addAll(DefaultRequisitionAccessService.this.getDeployedForeignSourceRepository().getActiveForeignSourceNames());
                Set activeForeignSourceNames = fsNames;
                for (String fsName : activeForeignSourceNames) {
                    Requisition r = DefaultRequisitionAccessService.this.getAccessor(fsName).getActiveRequisition(false);
                    if (r == null) continue;
                    reqs.add(r);
                }
                return new RequisitionCollection(reqs);
            }
        });
    }

    @Override
    public int getPendingCount() {
        return this.submitAndWait(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                DefaultRequisitionAccessService.this.flushAll();
                return DefaultRequisitionAccessService.this.getPendingForeignSourceRepository().getRequisitions().size();
            }
        });
    }

    @Override
    public Requisition getRequisition(final String foreignSource) {
        return this.submitAndWait(new Callable<Requisition>(){

            @Override
            public Requisition call() throws Exception {
                return DefaultRequisitionAccessService.this.getAccessor(foreignSource).getRequisition();
            }
        });
    }

    @Override
    public RequisitionNodeCollection getNodes(final String foreignSource) {
        return this.submitAndWait(new Callable<RequisitionNodeCollection>(){

            @Override
            public RequisitionNodeCollection call() throws Exception {
                return DefaultRequisitionAccessService.this.getAccessor(foreignSource).getNodes();
            }
        });
    }

    @Override
    public RequisitionNode getNode(final String foreignSource, final String foreignId) {
        return this.submitAndWait(new Callable<RequisitionNode>(){

            @Override
            public RequisitionNode call() throws Exception {
                return DefaultRequisitionAccessService.this.getAccessor(foreignSource).getNode(foreignId);
            }
        });
    }

    @Override
    public RequisitionInterfaceCollection getInterfacesForNode(final String foreignSource, final String foreignId) {
        return this.submitAndWait(new Callable<RequisitionInterfaceCollection>(){

            @Override
            public RequisitionInterfaceCollection call() throws Exception {
                return DefaultRequisitionAccessService.this.getAccessor(foreignSource).getInterfacesForNode(foreignId);
            }
        });
    }

    @Override
    public RequisitionInterface getInterfaceForNode(final String foreignSource, final String foreignId, final String ipAddress) {
        return this.submitAndWait(new Callable<RequisitionInterface>(){

            @Override
            public RequisitionInterface call() throws Exception {
                return DefaultRequisitionAccessService.this.getAccessor(foreignSource).getInterfaceForNode(foreignId, ipAddress);
            }
        });
    }

    @Override
    public RequisitionMonitoredServiceCollection getServicesForInterface(final String foreignSource, final String foreignId, final String ipAddress) {
        return this.submitAndWait(new Callable<RequisitionMonitoredServiceCollection>(){

            @Override
            public RequisitionMonitoredServiceCollection call() throws Exception {
                return DefaultRequisitionAccessService.this.getAccessor(foreignSource).getServicesForInterface(foreignId, ipAddress);
            }
        });
    }

    @Override
    public RequisitionMonitoredService getServiceForInterface(final String foreignSource, final String foreignId, final String ipAddress, final String service) {
        return this.submitAndWait(new Callable<RequisitionMonitoredService>(){

            @Override
            public RequisitionMonitoredService call() throws Exception {
                return DefaultRequisitionAccessService.this.getAccessor(foreignSource).getServiceForInterface(foreignId, ipAddress, service);
            }
        });
    }

    @Override
    public RequisitionCategoryCollection getCategories(final String foreignSource, final String foreignId) {
        return this.submitAndWait(new Callable<RequisitionCategoryCollection>(){

            @Override
            public RequisitionCategoryCollection call() throws Exception {
                return DefaultRequisitionAccessService.this.getAccessor(foreignSource).getCategories(foreignId);
            }
        });
    }

    @Override
    public RequisitionCategory getCategory(final String foreignSource, final String foreignId, final String category) {
        return this.submitAndWait(new Callable<RequisitionCategory>(){

            @Override
            public RequisitionCategory call() throws Exception {
                return DefaultRequisitionAccessService.this.getAccessor(foreignSource).getCategory(foreignId, category);
            }
        });
    }

    @Override
    public RequisitionAssetCollection getAssetParameters(final String foreignSource, final String foreignId) {
        return this.submitAndWait(new Callable<RequisitionAssetCollection>(){

            @Override
            public RequisitionAssetCollection call() throws Exception {
                return DefaultRequisitionAccessService.this.getAccessor(foreignSource).getAssetParameters(foreignId);
            }
        });
    }

    @Override
    public RequisitionAsset getAssetParameter(final String foreignSource, final String foreignId, final String parameter) {
        return this.submitAndWait(new Callable<RequisitionAsset>(){

            @Override
            public RequisitionAsset call() throws Exception {
                return DefaultRequisitionAccessService.this.getAccessor(foreignSource).getAssetParameter(foreignId, parameter);
            }
        });
    }

    @Override
    public void addOrReplaceRequisition(final Requisition requisition) {
        this.submitWriteOp(new Runnable(){

            @Override
            public void run() {
                DefaultRequisitionAccessService.this.getAccessor(requisition.getForeignSource()).addOrReplaceRequisition(requisition);
            }
        });
    }

    @Override
    public void addOrReplaceNode(final String foreignSource, final RequisitionNode node) {
        this.submitWriteOp(new Runnable(){

            @Override
            public void run() {
                DefaultRequisitionAccessService.this.getAccessor(foreignSource).addOrReplaceNode(node);
            }
        });
    }

    @Override
    public void addOrReplaceInterface(final String foreignSource, final String foreignId, final RequisitionInterface iface) {
        this.submitWriteOp(new Runnable(){

            @Override
            public void run() {
                DefaultRequisitionAccessService.this.getAccessor(foreignSource).addOrReplaceInterface(foreignId, iface);
            }
        });
    }

    @Override
    public void addOrReplaceService(final String foreignSource, final String foreignId, final String ipAddress, final RequisitionMonitoredService service) {
        this.submitWriteOp(new Runnable(){

            @Override
            public void run() {
                DefaultRequisitionAccessService.this.getAccessor(foreignSource).addOrReplaceService(foreignId, ipAddress, service);
            }
        });
    }

    @Override
    public void addOrReplaceNodeCategory(final String foreignSource, final String foreignId, final RequisitionCategory category) {
        this.submitWriteOp(new Runnable(){

            @Override
            public void run() {
                DefaultRequisitionAccessService.this.getAccessor(foreignSource).addOrReplaceNodeCategory(foreignId, category);
            }
        });
    }

    @Override
    public void addOrReplaceNodeAssetParameter(final String foreignSource, final String foreignId, final RequisitionAsset asset) {
        this.submitWriteOp(new Runnable(){

            @Override
            public void run() {
                DefaultRequisitionAccessService.this.getAccessor(foreignSource).addOrReplaceNodeAssetParameter(foreignId, asset);
            }
        });
    }

    @Override
    public void importRequisition(String foreignSource, String rescanExisting) {
        URL activeUrl = this.createSnapshot(foreignSource);
        String url = activeUrl.toString();
        LOG.debug("importRequisition: Sending import event with URL {}", (Object)url);
        EventBuilder bldr = new EventBuilder("uei.opennms.org/internal/importer/reloadImport", "Web");
        bldr.addParam("url", url);
        if (rescanExisting != null) {
            bldr.addParam("importRescanExisting", rescanExisting);
        }
        try {
            this.getEventProxy().send(bldr.getEvent());
        }
        catch (EventProxyException e) {
            throw new DataAccessResourceFailureException("Unable to send event to import group " + foreignSource, (Throwable)e);
        }
    }

    private URL createSnapshot(final String foreignSource) {
        return this.submitAndWait(new Callable<URL>(){

            @Override
            public URL call() throws Exception {
                return DefaultRequisitionAccessService.this.getAccessor(foreignSource).createSnapshot();
            }
        });
    }

    @Override
    public void updateRequisition(final String foreignSource, final MultivaluedMap<String, String> params) {
        this.submitWriteOp(new Runnable(){

            @Override
            public void run() {
                DefaultRequisitionAccessService.this.getAccessor(foreignSource).updateRequisition((MultivaluedMap<String, String>)params);
            }
        });
    }

    @Override
    public void updateNode(final String foreignSource, final String foreignId, final MultivaluedMap<String, String> params) {
        this.submitWriteOp(new Runnable(){

            @Override
            public void run() {
                DefaultRequisitionAccessService.this.getAccessor(foreignSource).updateNode(foreignId, (MultivaluedMap<String, String>)params);
            }
        });
    }

    @Override
    public void updateInterface(final String foreignSource, final String foreignId, final String ipAddress, final MultivaluedMap<String, String> params) {
        this.submitWriteOp(new Runnable(){

            @Override
            public void run() {
                DefaultRequisitionAccessService.this.getAccessor(foreignSource).updateInterface(foreignId, ipAddress, (MultivaluedMap<String, String>)params);
            }
        });
    }

    @Override
    public void deletePendingRequisition(final String foreignSource) {
        this.submitWriteOp(new Runnable(){

            @Override
            public void run() {
                DefaultRequisitionAccessService.this.getAccessor(foreignSource).deletePending();
            }
        });
    }

    @Override
    public void deleteDeployedRequisition(final String foreignSource) {
        this.submitWriteOp(new Runnable(){

            @Override
            public void run() {
                DefaultRequisitionAccessService.this.getAccessor(foreignSource).deleteDeployed();
            }
        });
    }

    @Override
    public void deleteNode(final String foreignSource, final String foreignId) {
        this.submitWriteOp(new Runnable(){

            @Override
            public void run() {
                DefaultRequisitionAccessService.this.getAccessor(foreignSource).deleteNode(foreignId);
            }
        });
    }

    @Override
    public void deleteInterface(final String foreignSource, final String foreignId, final String ipAddress) {
        this.submitWriteOp(new Runnable(){

            @Override
            public void run() {
                DefaultRequisitionAccessService.this.getAccessor(foreignSource).deleteInterface(foreignId, ipAddress);
            }
        });
    }

    @Override
    public void deleteInterfaceService(final String foreignSource, final String foreignId, final String ipAddress, final String service) {
        this.submitWriteOp(new Runnable(){

            @Override
            public void run() {
                DefaultRequisitionAccessService.this.getAccessor(foreignSource).deleteInterfaceService(foreignId, ipAddress, service);
            }
        });
    }

    @Override
    public void deleteCategory(final String foreignSource, final String foreignId, final String category) {
        this.submitWriteOp(new Runnable(){

            @Override
            public void run() {
                DefaultRequisitionAccessService.this.getAccessor(foreignSource).deleteCategory(foreignId, category);
            }
        });
    }

    @Override
    public void deleteAssetParameter(final String foreignSource, final String foreignId, final String parameter) {
        this.submitWriteOp(new Runnable(){

            @Override
            public void run() {
                DefaultRequisitionAccessService.this.getAccessor(foreignSource).deleteAssetParameter(foreignId, parameter);
            }
        });
    }

    static class RequisitionAccessor {
        private static final Logger LOG = LoggerFactory.getLogger(RequisitionAccessor.class);
        private final String m_foreignSource;
        private final ForeignSourceRepository m_pendingRepo;
        private final ForeignSourceRepository m_deployedRepo;
        private Requisition m_pending = null;

        public RequisitionAccessor(String foreignSource, ForeignSourceRepository pendingRepo, ForeignSourceRepository deployedRepo) {
            this.m_foreignSource = foreignSource;
            this.m_pendingRepo = pendingRepo;
            this.m_deployedRepo = deployedRepo;
            this.m_pending = null;
        }

        public String getForeignSource() {
            return this.m_foreignSource;
        }

        public ForeignSourceRepository getPendingForeignSourceRepository() {
            return this.m_pendingRepo;
        }

        public ForeignSourceRepository getDeployedForeignSourceRepository() {
            return this.m_deployedRepo;
        }

        public Requisition getActiveRequisition(boolean createIfMissing) {
            if (this.m_pending != null) {
                return this.m_pending;
            }
            Requisition pending = RequisitionFileUtils.getLatestPendingOrSnapshotRequisition((ForeignSourceRepository)this.getPendingForeignSourceRepository(), (String)this.m_foreignSource);
            Requisition deployed = this.getDeployedForeignSourceRepository().getRequisition(this.m_foreignSource);
            if (pending == null && deployed == null && createIfMissing) {
                return new Requisition(this.m_foreignSource);
            }
            if (pending == null) {
                return deployed;
            }
            if (deployed == null) {
                return pending;
            }
            if (deployed.getDate().after(pending.getDate())) {
                return deployed;
            }
            return pending;
        }

        private void save(Requisition requisition) {
            this.m_pending = requisition;
        }

        void addOrReplaceRequisition(Requisition requisition) {
            if (requisition != null) {
                requisition.updateDateStamp();
                this.save(requisition);
            }
        }

        void addOrReplaceNode(RequisitionNode node) {
            Requisition req = this.getActiveRequisition(true);
            if (req != null) {
                req.updateDateStamp();
                req.putNode(node);
                this.save(req);
            }
        }

        void addOrReplaceInterface(String foreignId, RequisitionInterface iface) {
            RequisitionNode node;
            Requisition req = this.getActiveRequisition(true);
            if (req != null && (node = req.getNode(foreignId)) != null) {
                req.updateDateStamp();
                node.putInterface(iface);
                this.save(req);
            }
        }

        void addOrReplaceService(String foreignId, String ipAddress, RequisitionMonitoredService service) {
            RequisitionInterface iface;
            RequisitionNode node;
            Requisition req = this.getActiveRequisition(true);
            if (req != null && (node = req.getNode(foreignId)) != null && (iface = node.getInterface(ipAddress)) != null) {
                req.updateDateStamp();
                iface.putMonitoredService(service);
                this.save(req);
            }
        }

        void addOrReplaceNodeCategory(String foreignId, RequisitionCategory category) {
            RequisitionNode node;
            Requisition req = this.getActiveRequisition(true);
            if (req != null && (node = req.getNode(foreignId)) != null) {
                req.updateDateStamp();
                node.putCategory(category);
                this.save(req);
            }
        }

        void addOrReplaceNodeAssetParameter(String foreignId, RequisitionAsset asset) {
            RequisitionNode node;
            Requisition req = this.getActiveRequisition(true);
            if (req != null && (node = req.getNode(foreignId)) != null) {
                req.updateDateStamp();
                node.putAsset(asset);
                this.save(req);
            }
        }

        void updateRequisition(MultivaluedMap<String, String> params) {
            String foreignSource = this.m_foreignSource;
            LOG.debug("updateRequisition: Updating requisition with foreign source {}", (Object)foreignSource);
            if (params.isEmpty()) {
                return;
            }
            Requisition req = this.getActiveRequisition(false);
            if (req != null) {
                req.updateDateStamp();
                RestUtils.setBeanProperties(req, params);
                this.save(req);
                LOG.debug("updateRequisition: Requisition with foreign source {} updated", (Object)foreignSource);
            }
        }

        void updateNode(String foreignId, MultivaluedMap<String, String> params) {
            RequisitionNode node;
            String foreignSource = this.m_foreignSource;
            LOG.debug("updateNode: Updating node with foreign source {} and foreign id {}", (Object)foreignSource, (Object)foreignId);
            if (params.isEmpty()) {
                return;
            }
            Requisition req = this.getActiveRequisition(false);
            if (req != null && (node = req.getNode(foreignId)) != null) {
                req.updateDateStamp();
                RestUtils.setBeanProperties(node, params);
                this.save(req);
                LOG.debug("updateNode: Node with foreign source {} and foreign id {} updated", (Object)foreignSource, (Object)foreignId);
            }
        }

        void updateInterface(String foreignId, String ipAddress, MultivaluedMap<String, String> params) {
            RequisitionInterface iface;
            RequisitionNode node;
            String foreignSource = this.m_foreignSource;
            LOG.debug("updateInterface: Updating interface {} on node {}/{}", new Object[]{ipAddress, foreignSource, foreignId});
            if (params.isEmpty()) {
                return;
            }
            Requisition req = this.getActiveRequisition(false);
            if (req != null && (node = req.getNode(foreignId)) != null && (iface = node.getInterface(ipAddress)) != null) {
                req.updateDateStamp();
                RestUtils.setBeanProperties(iface, params);
                this.save(req);
                LOG.debug("updateInterface: Interface {} on node {}/{} updated", new Object[]{ipAddress, foreignSource, foreignId});
            }
        }

        void deletePending() {
            LOG.debug("deletePendingRequisition: deleting pending requisition with foreign source {}", (Object)this.getForeignSource());
            Requisition req = this.getActiveRequisition(false);
            this.getPendingForeignSourceRepository().delete(req);
        }

        void deleteDeployed() {
            LOG.debug("deleteDeployedRequisition: deleting pending requisition with foreign source {}", (Object)this.getForeignSource());
            Requisition req = this.getActiveRequisition(false);
            this.getDeployedForeignSourceRepository().delete(req);
        }

        void deleteNode(String foreignId) {
            LOG.debug("deleteNode: Deleting node {} from foreign source {}", (Object)foreignId, (Object)this.getForeignSource());
            Requisition req = this.getActiveRequisition(false);
            if (req != null) {
                req.updateDateStamp();
                req.deleteNode(foreignId);
                this.save(req);
            }
        }

        void deleteInterface(String foreignId, String ipAddress) {
            RequisitionNode node;
            LOG.debug("deleteInterface: Deleting interface {} from node {}/{}", new Object[]{ipAddress, this.getForeignSource(), foreignId});
            Requisition req = this.getActiveRequisition(false);
            if (req != null && (node = req.getNode(foreignId)) != null) {
                req.updateDateStamp();
                node.deleteInterface(ipAddress);
                this.save(req);
            }
        }

        void deleteInterfaceService(String foreignId, String ipAddress, String service) {
            RequisitionInterface iface;
            RequisitionNode node;
            LOG.debug("deleteInterfaceService: Deleting service {} from interface {} on node {}/{}", new Object[]{service, ipAddress, this.getForeignSource(), foreignId});
            Requisition req = this.getActiveRequisition(false);
            if (req != null && (node = req.getNode(foreignId)) != null && (iface = node.getInterface(ipAddress)) != null) {
                req.updateDateStamp();
                iface.deleteMonitoredService(service);
                this.save(req);
            }
        }

        void deleteCategory(String foreignId, String category) {
            RequisitionNode node;
            LOG.debug("deleteCategory: Deleting category {} from node {}/{}", new Object[]{category, this.getForeignSource(), foreignId});
            Requisition req = this.getActiveRequisition(false);
            if (req != null && (node = req.getNode(foreignId)) != null) {
                req.updateDateStamp();
                node.deleteCategory(category);
                this.save(req);
            }
        }

        void deleteAssetParameter(String foreignId, String parameter) {
            RequisitionNode node;
            LOG.debug("deleteAssetParameter: Deleting asset parameter {} from node {}/{}", new Object[]{parameter, this.getForeignSource(), foreignId});
            Requisition req = this.getActiveRequisition(false);
            if (req != null && (node = req.getNode(foreignId)) != null) {
                req.updateDateStamp();
                node.deleteAsset(parameter);
                this.save(req);
            }
        }

        RequisitionAsset getAssetParameter(String foreignId, String parameter) {
            this.flush();
            Requisition req = this.getActiveRequisition(false);
            RequisitionNode node = req == null ? null : req.getNode(foreignId);
            return node == null ? null : node.getAsset(parameter);
        }

        RequisitionAssetCollection getAssetParameters(String foreignId) {
            this.flush();
            Requisition req = this.getActiveRequisition(false);
            RequisitionNode node = req == null ? null : req.getNode(foreignId);
            return node == null ? null : new RequisitionAssetCollection((Collection)node.getAssets());
        }

        RequisitionCategory getCategory(String foreignId, String category) {
            this.flush();
            Requisition req = this.getActiveRequisition(false);
            RequisitionNode node = req == null ? null : req.getNode(foreignId);
            return node == null ? null : node.getCategory(category);
        }

        RequisitionCategoryCollection getCategories(String foreignId) {
            this.flush();
            Requisition req = this.getActiveRequisition(false);
            RequisitionNode node = req == null ? null : req.getNode(foreignId);
            return node == null ? null : new RequisitionCategoryCollection((Collection)node.getCategories());
        }

        RequisitionInterface getInterfaceForNode(String foreignId, String ipAddress) {
            this.flush();
            Requisition req = this.getActiveRequisition(false);
            RequisitionNode node = req == null ? null : req.getNode(foreignId);
            return node == null ? null : node.getInterface(ipAddress);
        }

        RequisitionInterfaceCollection getInterfacesForNode(String foreignId) {
            this.flush();
            Requisition req = this.getActiveRequisition(false);
            RequisitionNode node = req == null ? null : req.getNode(foreignId);
            return node == null ? null : new RequisitionInterfaceCollection((Collection)node.getInterfaces());
        }

        RequisitionNode getNode(String foreignId) {
            this.flush();
            Requisition req = this.getActiveRequisition(false);
            return req == null ? null : req.getNode(foreignId);
        }

        RequisitionNodeCollection getNodes() {
            this.flush();
            Requisition req = this.getActiveRequisition(false);
            return req == null ? null : new RequisitionNodeCollection((Collection)req.getNodes());
        }

        Requisition getRequisition() {
            this.flush();
            return this.getActiveRequisition(false);
        }

        RequisitionMonitoredService getServiceForInterface(String foreignId, String ipAddress, String service) {
            this.flush();
            Requisition req = this.getActiveRequisition(false);
            RequisitionNode node = req == null ? null : req.getNode(foreignId);
            RequisitionInterface iface = node == null ? null : node.getInterface(ipAddress);
            return iface == null ? null : iface.getMonitoredService(service);
        }

        RequisitionMonitoredServiceCollection getServicesForInterface(String foreignId, String ipAddress) {
            this.flush();
            Requisition req = this.getActiveRequisition(false);
            RequisitionNode node = req == null ? null : req.getNode(foreignId);
            RequisitionInterface iface = node == null ? null : node.getInterface(ipAddress);
            return iface == null ? null : new RequisitionMonitoredServiceCollection((Collection)iface.getMonitoredServices());
        }

        URL createSnapshot() throws MalformedURLException {
            this.flush();
            Requisition pending = this.getPendingForeignSourceRepository().getRequisition(this.getForeignSource());
            Requisition deployed = this.getDeployedForeignSourceRepository().getRequisition(this.getForeignSource());
            URL activeUrl = pending == null || deployed != null && deployed.getDateStamp().compare(pending.getDateStamp()) > -1 ? this.getDeployedForeignSourceRepository().getRequisitionURL(this.getForeignSource()) : RequisitionFileUtils.createSnapshot((ForeignSourceRepository)this.getPendingForeignSourceRepository(), (String)this.getForeignSource(), (Date)pending.getDate()).toURI().toURL();
            return activeUrl;
        }

        private void flush() {
            if (this.m_pending != null) {
                this.getPendingForeignSourceRepository().save(this.m_pending);
                this.m_pending = null;
            }
            this.getPendingForeignSourceRepository().flush();
            this.getDeployedForeignSourceRepository().flush();
        }
    }
}

