/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer.support;

import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import org.opennms.netmgt.dao.api.ResourceDao;
import org.opennms.netmgt.model.OnmsResource;
import org.opennms.netmgt.model.OnmsResourceType;
import org.opennms.web.api.Util;
import org.opennms.web.svclayer.ChooseResourceService;
import org.opennms.web.svclayer.model.ChooseResourceModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class DefaultChooseResourceService
implements ChooseResourceService,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultChooseResourceService.class);
    public ResourceDao m_resourceDao;

    @Override
    public ChooseResourceModel findChildResources(String resourceId, String endUrl) {
        if (resourceId == null) {
            throw new IllegalArgumentException("resourceId parameter may not be null");
        }
        if (endUrl == null) {
            throw new IllegalArgumentException("endUrl parameter may not be null");
        }
        ChooseResourceModel model = new ChooseResourceModel();
        model.setEndUrl(endUrl);
        OnmsResource resource = this.m_resourceDao.getResourceById(resourceId);
        if (resource == null) {
            throw new IllegalArgumentException("resource \"" + resourceId + "\" could not be found");
        }
        model.setResource(resource);
        LinkedHashMap<OnmsResourceType, List<OnmsResource>> resourceTypeMap = new LinkedHashMap<OnmsResourceType, List<OnmsResource>>();
        for (OnmsResource childResource : resource.getChildResources()) {
            if (!resourceTypeMap.containsKey(childResource.getResourceType())) {
                resourceTypeMap.put(childResource.getResourceType(), new LinkedList());
            }
            LOG.info("getId(): {}", (Object)childResource.getId());
            LOG.info("getName(): {}", (Object)childResource.getName());
            ((List)resourceTypeMap.get(childResource.getResourceType())).add(this.checkLabelForQuotes(childResource));
        }
        model.setResourceTypes(resourceTypeMap);
        return model;
    }

    private OnmsResource checkLabelForQuotes(OnmsResource childResource) {
        String lbl = Util.convertToJsSafeString(childResource.getLabel());
        OnmsResource resource = new OnmsResource(childResource.getName(), lbl, childResource.getResourceType(), childResource.getAttributes(), childResource.getPath());
        resource.setParent(childResource.getParent());
        resource.setEntity(childResource.getEntity());
        resource.setLink(childResource.getLink());
        return resource;
    }

    public void afterPropertiesSet() {
        if (this.m_resourceDao == null) {
            throw new IllegalStateException("resourceDao property not set");
        }
    }

    public ResourceDao getResourceDao() {
        return this.m_resourceDao;
    }

    public void setResourceDao(ResourceDao resourceDao) {
        this.m_resourceDao = resourceDao;
    }
}

