/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.svclayer.model;

import java.util.ArrayList;
import java.util.List;
import org.opennms.web.api.Util;
import org.springframework.validation.Errors;

public class SimpleWebTable {
    private List<Cell> m_columnHeaders = new ArrayList<Cell>();
    private List<List<Cell>> m_rows = new ArrayList<List<Cell>>();
    private List<Cell> m_currentRow = null;
    private String m_title = "";
    private Errors m_errors = null;

    public List<Cell> getColumnHeaders() {
        return this.m_columnHeaders;
    }

    public List<List<Cell>> getRows() {
        return this.m_rows;
    }

    public String getTitle() {
        return this.m_title;
    }

    public void setTitle(String title) {
        this.m_title = title;
    }

    public Cell addColumn(Object headerContent, String headerStyle) {
        Cell headerCell = new Cell(headerContent, headerStyle);
        this.m_columnHeaders.add(headerCell);
        return headerCell;
    }

    public Cell addColumn(Object headerContent) {
        return this.addColumn(headerContent, "");
    }

    public void newRow() {
        ArrayList<Cell> row = new ArrayList<Cell>();
        this.m_rows.add(row);
        this.m_currentRow = row;
    }

    public Cell addCell(Object cellContent, String cellStyle, String link) {
        if (this.m_currentRow == null) {
            throw new IllegalStateException("make sure you call newRow before trying to add any cells to the table!");
        }
        Cell cell = new Cell(cellContent, cellStyle, link);
        this.m_currentRow.add(cell);
        return cell;
    }

    public Cell addCell(Object cellContent, String cellStyle) {
        return this.addCell(cellContent, cellStyle, null);
    }

    public Cell addCell(String cellContent) {
        return this.addCell(cellContent, "", null);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("<h2>" + Util.htmlify(this.getTitle()) + "</h2>\n");
        buf.append("<table>\n");
        buf.append("  <tr>\n");
        for (Cell cell : this.getColumnHeaders()) {
            buf.append("    <th style=\"" + cell.getStyleClass() + "\">\n");
            if (cell.getLink() != null) {
                buf.append("      <a href=\"" + Util.htmlify(cell.getLink()) + "\">" + cell.getContent() + "</a>\n");
            } else {
                buf.append("      " + cell.getContent() + "\n");
            }
            buf.append("    </th>\n");
        }
        buf.append("  </tr>\n");
        for (List list : this.getRows()) {
            buf.append("  <tr>\n");
            for (Cell cell : list) {
                buf.append("    <td style=\"" + cell.getStyleClass() + "\">\n");
                if (cell.getLink() != null) {
                    buf.append("      <a href=\"" + Util.htmlify(cell.getLink()) + "\">" + cell.getContent() + "</a>\n");
                } else {
                    buf.append("      " + cell.getContent() + "\n");
                }
                buf.append("    </td>\n");
            }
            buf.append("  </tr>\n");
        }
        buf.append("</table>\n");
        return buf.toString();
    }

    public Errors getErrors() {
        return this.m_errors;
    }

    public void setErrors(Errors errors) {
        this.m_errors = errors;
    }

    public static class Cell {
        private Object m_content;
        private String m_styleClass;
        private String m_link;

        public Cell() {
        }

        public Cell(Object content, String styleClass) {
            this.m_content = content;
            this.m_styleClass = styleClass;
        }

        public Cell(Object content, String styleClass, String link) {
            this.m_content = content;
            this.m_styleClass = styleClass;
            this.m_link = link;
        }

        public Object getContent() {
            return this.m_content;
        }

        public void setContent(Object content) {
            this.m_content = content;
        }

        public String getStyleClass() {
            return this.m_styleClass;
        }

        public void setStyleClass(String styleClass) {
            this.m_styleClass = styleClass;
        }

        public String getLink() {
            return this.m_link;
        }

        public void setLink(String link) {
            this.m_link = link;
        }

        public boolean equals(Object o) {
            if (o == null || !(o instanceof Cell)) {
                return false;
            }
            Cell c = (Cell)o;
            if (!(this.m_content == null && c.m_content == null || this.m_content != null && this.m_content.equals(c.m_content))) {
                return false;
            }
            if (!(this.m_styleClass == null && c.m_styleClass == null || this.m_styleClass != null && this.m_styleClass.equals(c.m_styleClass))) {
                return false;
            }
            return this.m_link == null && c.m_link == null || this.m_link != null && this.m_link.equals(c.m_link);
        }

        public String toString() {
            return "Content: \"" + this.m_content + "\", styleClass: \"" + this.m_styleClass + "\", link: \"" + this.m_link + "\"";
        }
    }
}

