/*
 * Decompiled with CFR 0.152.
 */
package org.opennms.web.category;

import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.opennms.netmgt.model.OnmsIpInterface;
import org.opennms.netmgt.model.OnmsMonitoredService;
import org.opennms.netmgt.model.OnmsNode;
import org.opennms.netmgt.xml.rtc.Node;
import org.opennms.web.category.AvailabilityIpInterface;

@XmlRootElement(name="node")
public class AvailabilityNode {
    @XmlAttribute(name="id")
    private Long m_nodeId;
    @XmlAttribute(name="availability")
    private Double m_availability;
    @XmlAttribute(name="service-count")
    private Long m_serviceCount;
    @XmlAttribute(name="service-down-count")
    private Long m_serviceDownCount;
    @XmlElementWrapper(name="ipinterfaces")
    @XmlElement(name="ipinterface")
    private final List<AvailabilityIpInterface> m_ipInterfaces = new ArrayList<AvailabilityIpInterface>();

    public AvailabilityNode() {
        this.m_nodeId = -1L;
        this.m_availability = -1.0;
        this.m_serviceCount = 0L;
        this.m_serviceDownCount = 0L;
    }

    public AvailabilityNode(Node node) {
        this.m_nodeId = node.getNodeid();
        this.m_availability = node.getNodevalue();
        this.m_serviceCount = node.getNodesvccount();
        this.m_serviceDownCount = node.getNodesvcdowncount();
    }

    public AvailabilityNode(OnmsNode node, double availability) {
        this.m_nodeId = node.getId().longValue();
        this.m_availability = availability;
        this.m_serviceCount = 0L;
        this.m_serviceDownCount = 0L;
        for (OnmsIpInterface iface : node.getIpInterfaces()) {
            for (OnmsMonitoredService svc : iface.getMonitoredServices()) {
                Long l = this.m_serviceCount;
                Long l2 = this.m_serviceCount = Long.valueOf(this.m_serviceCount + 1L);
                if (!svc.isDown()) continue;
                l = this.m_serviceDownCount;
                l2 = this.m_serviceDownCount = Long.valueOf(this.m_serviceDownCount + 1L);
            }
        }
    }

    public Long getId() {
        return this.m_nodeId;
    }

    public void addIpInterface(AvailabilityIpInterface iface) {
        this.m_ipInterfaces.add(iface);
    }
}

